/*
 * Decompiled with CFR 0.152.
 */
package org.emulinker.kaillera.model.impl;

import java.net.InetSocketAddress;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.emulinker.kaillera.access.AccessManager;
import org.emulinker.kaillera.model.KailleraGame;
import org.emulinker.kaillera.model.KailleraUser;
import org.emulinker.kaillera.model.event.GameStartedEvent;
import org.emulinker.kaillera.model.event.KailleraEvent;
import org.emulinker.kaillera.model.event.KailleraEventListener;
import org.emulinker.kaillera.model.event.UserQuitEvent;
import org.emulinker.kaillera.model.event.UserQuitGameEvent;
import org.emulinker.kaillera.model.exception.ChatException;
import org.emulinker.kaillera.model.exception.ClientAddressException;
import org.emulinker.kaillera.model.exception.CloseGameException;
import org.emulinker.kaillera.model.exception.ConnectionTypeException;
import org.emulinker.kaillera.model.exception.CreateGameException;
import org.emulinker.kaillera.model.exception.DropGameException;
import org.emulinker.kaillera.model.exception.FloodException;
import org.emulinker.kaillera.model.exception.GameChatException;
import org.emulinker.kaillera.model.exception.GameDataException;
import org.emulinker.kaillera.model.exception.GameKickException;
import org.emulinker.kaillera.model.exception.JoinGameException;
import org.emulinker.kaillera.model.exception.LoginException;
import org.emulinker.kaillera.model.exception.PingTimeException;
import org.emulinker.kaillera.model.exception.QuitException;
import org.emulinker.kaillera.model.exception.QuitGameException;
import org.emulinker.kaillera.model.exception.StartGameException;
import org.emulinker.kaillera.model.exception.UserNameException;
import org.emulinker.kaillera.model.exception.UserReadyException;
import org.emulinker.kaillera.model.impl.KailleraGameImpl;
import org.emulinker.kaillera.model.impl.KailleraServerImpl;
import org.emulinker.util.EmuLang;
import org.emulinker.util.EmuUtil;
import org.emulinker.util.Executable;

public final class KailleraUserImpl
implements KailleraUser,
Executable {
    private static Log log = LogFactory.getLog(KailleraUserImpl.class);
    private static final String EMULINKER_CLIENT_NAME = "Emulinker Suprclient";
    private KailleraServerImpl server;
    private KailleraGameImpl game;
    private int id;
    private String name;
    private String protocol;
    private String clientType;
    private byte connectionType;
    private int ping;
    private InetSocketAddress connectSocketAddress;
    private InetSocketAddress clientSocketAddress;
    private int status;
    private boolean loggedIn;
    private String toString;
    private int access;
    private boolean emulinkerClient;
    private long connectTime;
    private long lastActivity;
    private long lastKeepAlive;
    private long lastChatTime;
    private long lastCreateGameTime;
    private long lastTimeout;
    private int playerNumber = -1;
    private long gameDataErrorTime = -1L;
    private boolean isRunning = false;
    private boolean stopFlag = false;
    private KailleraEventListener listener;
    private BlockingQueue<KailleraEvent> eventQueue = new LinkedBlockingQueue<KailleraEvent>();

    public KailleraUserImpl(int userID, String protocol, InetSocketAddress connectSocketAddress, KailleraEventListener listener, KailleraServerImpl server) {
        this.id = userID;
        this.protocol = protocol;
        this.connectSocketAddress = connectSocketAddress;
        this.server = server;
        this.listener = listener;
        this.toString = "User" + userID + "(" + connectSocketAddress.getAddress().getHostAddress() + ")";
        this.lastTimeout = 0L;
        this.lastCreateGameTime = 0L;
        this.lastChatTime = 0L;
        this.lastKeepAlive = this.connectTime = System.currentTimeMillis();
        this.lastActivity = this.connectTime;
    }

    public int getID() {
        return this.id;
    }

    public InetSocketAddress getConnectSocketAddress() {
        return this.connectSocketAddress;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public long getConnectTime() {
        return this.connectTime;
    }

    public int getStatus() {
        return this.status;
    }

    public boolean isLoggedIn() {
        return this.loggedIn;
    }

    public void setLoggedIn() {
        this.loggedIn = true;
    }

    public void setLoggedIn(boolean loggedIn) {
        loggedIn = false;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.toString = "User" + this.id + "(" + (name.length() > 15 ? name.substring(0, 15) + "..." : name) + "/" + this.connectSocketAddress.getAddress().getHostAddress() + ")";
    }

    public String getClientType() {
        return this.clientType;
    }

    public void setClientType(String clientType) {
        this.clientType = clientType;
        if (clientType != null && clientType.startsWith(EMULINKER_CLIENT_NAME)) {
            this.emulinkerClient = true;
        }
    }

    public boolean isEmuLinkerClient() {
        return this.emulinkerClient;
    }

    public byte getConnectionType() {
        return this.connectionType;
    }

    public void setConnectionType(byte connectionType) {
        this.connectionType = connectionType;
    }

    public InetSocketAddress getSocketAddress() {
        return this.clientSocketAddress;
    }

    public void setSocketAddress(InetSocketAddress clientSocketAddress) {
        this.clientSocketAddress = clientSocketAddress;
    }

    public int getPing() {
        return this.ping;
    }

    public void setPing(int ping) {
        this.ping = ping;
    }

    public long getLastActivity() {
        return this.lastActivity;
    }

    public long getLastKeepAlive() {
        return this.lastKeepAlive;
    }

    public void updateLastKeepAlive() {
        this.lastKeepAlive = System.currentTimeMillis();
    }

    public KailleraEventListener getListener() {
        return this.listener;
    }

    public KailleraServerImpl getServer() {
        return this.server;
    }

    public KailleraGameImpl getGame() {
        return this.game;
    }

    protected void setGame(KailleraGameImpl game) {
        this.game = game;
        if (game == null) {
            this.playerNumber = -1;
        }
    }

    protected void setStatus(int status) {
        this.status = status;
    }

    protected long getLastChatTime() {
        return this.lastChatTime;
    }

    protected long getLastCreateGameTime() {
        return this.lastCreateGameTime;
    }

    protected long getLastTimeout() {
        return this.lastTimeout;
    }

    protected void setLastTimeout() {
        this.lastTimeout = System.currentTimeMillis();
    }

    public int getAccess() {
        return this.access;
    }

    public String getAccessStr() {
        return AccessManager.ACCESS_NAMES[this.access];
    }

    protected void setAccess(int access) {
        this.access = access;
    }

    public int getPlayerNumber() {
        return this.playerNumber;
    }

    protected void setPlayerNumber(int playerNumber) {
        this.playerNumber = playerNumber;
    }

    public void updateLastActivity() {
        this.lastActivity = this.lastKeepAlive = System.currentTimeMillis();
    }

    public boolean equals(Object obj) {
        return obj instanceof KailleraUserImpl && ((KailleraUserImpl)obj).getID() == this.getID();
    }

    public String toString() {
        return this.toString;
    }

    public String toDetailedString() {
        StringBuilder sb = new StringBuilder();
        sb.append("KailleraUserImpl[id=");
        sb.append(this.getID());
        sb.append(" protocol=");
        sb.append(this.getProtocol());
        sb.append(" status=");
        sb.append(KailleraUser.STATUS_NAMES[this.getStatus()]);
        sb.append(" name=");
        sb.append(this.getName());
        sb.append(" clientType=");
        sb.append(this.getClientType());
        sb.append(" ping=");
        sb.append(this.getPing());
        sb.append(" connectionType=");
        sb.append(KailleraUser.CONNECTION_TYPE_NAMES[this.getConnectionType()]);
        sb.append(" remoteAddress=");
        sb.append(this.getSocketAddress() == null ? EmuUtil.formatSocketAddress(this.getConnectSocketAddress()) : EmuUtil.formatSocketAddress(this.getSocketAddress()));
        sb.append("]");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        KailleraUserImpl kailleraUserImpl = this;
        synchronized (kailleraUserImpl) {
            if (!this.isRunning) {
                log.debug((Object)(this + "  thread stop request ignored: not running!"));
                return;
            }
            if (this.stopFlag) {
                log.debug((Object)(this + "  thread stop request ignored: already stopping!"));
                return;
            }
            this.stopFlag = true;
            try {
                Thread.sleep(500L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.addEvent(new StopFlagEvent());
        }
        this.listener.stop();
    }

    public synchronized void droppedPacket() {
        if (this.game != null) {
            this.game.droppedPacket(this);
        }
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public synchronized void login() throws PingTimeException, ClientAddressException, ConnectionTypeException, UserNameException, LoginException {
        this.updateLastActivity();
        this.server.login(this);
    }

    public synchronized void chat(String message) throws ChatException, FloodException {
        this.updateLastActivity();
        this.server.chat(this, message);
        this.lastChatTime = System.currentTimeMillis();
    }

    public synchronized void gameKick(int userID) throws GameKickException {
        this.updateLastActivity();
        if (this.game == null) {
            log.warn((Object)(this + " kick User " + userID + " failed: Not in a game"));
            throw new GameKickException(EmuLang.getString("KailleraUserImpl.KickErrorNotInGame"));
        }
        this.game.kick(this, userID);
    }

    public synchronized KailleraGame createGame(String romName) throws CreateGameException, FloodException {
        this.updateLastActivity();
        if (this.getStatus() == 0) {
            log.warn((Object)(this + " create game failed: User status is Playing!"));
            throw new CreateGameException(EmuLang.getString("KailleraUserImpl.CreateGameErrorAlreadyInGame"));
        }
        if (this.getStatus() == 2) {
            log.warn((Object)(this + " create game failed: User status is Connecting!"));
            throw new CreateGameException(EmuLang.getString("KailleraUserImpl.CreateGameErrorNotFullyConnected"));
        }
        KailleraGame game = this.server.createGame(this, romName);
        this.lastCreateGameTime = System.currentTimeMillis();
        return game;
    }

    public synchronized void quit(String message) throws QuitException, DropGameException, QuitGameException, CloseGameException {
        this.updateLastActivity();
        this.server.quit(this, message);
        this.loggedIn = false;
    }

    public synchronized KailleraGame joinGame(int gameID) throws JoinGameException {
        this.updateLastActivity();
        if (this.game != null) {
            log.warn((Object)(this + " join game failed: Already in: " + this.game));
            throw new JoinGameException(EmuLang.getString("KailleraUserImpl.JoinGameErrorAlreadyInGame"));
        }
        if (this.getStatus() == 0) {
            log.warn((Object)(this + " join game failed: User status is Playing!"));
            throw new JoinGameException(EmuLang.getString("KailleraUserImpl.JoinGameErrorAnotherGameRunning"));
        }
        if (this.getStatus() == 2) {
            log.warn((Object)(this + " join game failed: User status is Connecting!"));
            throw new JoinGameException(EmuLang.getString("KailleraUserImpl.JoinGameErrorNotFullConnected"));
        }
        KailleraGameImpl game = (KailleraGameImpl)this.server.getGame(gameID);
        if (game == null) {
            log.warn((Object)(this + " join game failed: Game " + gameID + " does not exist!"));
            throw new JoinGameException(EmuLang.getString("KailleraUserImpl.JoinGameErrorDoesNotExist"));
        }
        this.playerNumber = game.join(this);
        this.setGame(game);
        this.gameDataErrorTime = -1L;
        return game;
    }

    public synchronized void gameChat(String message, int messageID) throws GameChatException {
        this.updateLastActivity();
        if (this.game == null) {
            log.warn((Object)(this + " game chat failed: Not in a game"));
            throw new GameChatException(EmuLang.getString("KailleraUserImpl.GameChatErrorNotInGame"));
        }
        this.game.chat(this, message);
    }

    public synchronized void dropGame() throws DropGameException {
        this.updateLastActivity();
        this.setStatus(1);
        if (this.game != null) {
            this.game.drop(this, this.playerNumber);
        } else {
            log.debug((Object)(this + " drop game failed: Not in a game"));
        }
    }

    public synchronized void quitGame() throws DropGameException, QuitGameException, CloseGameException {
        this.updateLastActivity();
        if (this.game == null) {
            log.debug((Object)(this + " quit game failed: Not in a game"));
            return;
        }
        if (this.status == 0) {
            this.game.drop(this, this.playerNumber);
            this.setStatus(1);
        }
        this.game.quit(this, this.playerNumber);
        if (this.status != 1) {
            this.setStatus(1);
        }
        this.setGame(null);
        this.addEvent(new UserQuitGameEvent(this.game, this));
    }

    public synchronized void startGame() throws StartGameException {
        this.updateLastActivity();
        if (this.game == null) {
            log.warn((Object)(this + " start game failed: Not in a game"));
            throw new StartGameException(EmuLang.getString("KailleraUserImpl.StartGameErrorNotInGame"));
        }
        this.game.start(this);
    }

    public synchronized void playerReady() throws UserReadyException {
        this.updateLastActivity();
        if (this.game == null) {
            log.warn((Object)(this + " player ready failed: Not in a game"));
            throw new UserReadyException(EmuLang.getString("KailleraUserImpl.PlayerReadyErrorNotInGame"));
        }
        this.game.ready(this, this.playerNumber);
    }

    public void addGameData(byte[] data) throws GameDataException {
        this.updateLastActivity();
        try {
            if (this.game == null) {
                throw new GameDataException(EmuLang.getString("KailleraUserImpl.GameDataErrorNotInGame"), data, this.getConnectionType(), 1, 1);
            }
            this.game.addData(this, this.playerNumber, data);
            this.gameDataErrorTime = 0L;
        }
        catch (GameDataException e) {
            log.debug((Object)(this + " add game data failed: " + e.getMessage()));
            if (this.gameDataErrorTime > 0L) {
                if (System.currentTimeMillis() - this.gameDataErrorTime > 30000L) {
                    log.debug((Object)(this + ": error game data exceeds drop timeout!"));
                    throw new GameDataException(e.getMessage());
                }
                throw e;
            }
            this.gameDataErrorTime = System.currentTimeMillis();
            throw e;
        }
    }

    void addEvent(KailleraEvent event) {
        if (event == null) {
            log.error((Object)(this + ": ignoring null event!"));
            return;
        }
        this.eventQueue.offer(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.isRunning = true;
        log.debug((Object)(this + " thread running..."));
        try {
            while (!this.stopFlag) {
                KailleraEvent event = this.eventQueue.poll(200L, TimeUnit.SECONDS);
                if (event == null) continue;
                if (event instanceof StopFlagEvent) {
                    break;
                }
                this.listener.actionPerformed(event);
                if (event instanceof GameStartedEvent) {
                    this.setStatus(0);
                    continue;
                }
                if (!(event instanceof UserQuitEvent) || !((UserQuitEvent)event).getUser().equals(this)) continue;
                this.stop();
            }
        }
        catch (InterruptedException e) {
            log.error((Object)(this + " thread interrupted!"));
        }
        catch (Throwable e) {
            log.fatal((Object)(this + " thread caught unexpected exception!"), e);
        }
        finally {
            this.isRunning = false;
            log.debug((Object)(this + " thread exiting..."));
        }
    }

    private static class StopFlagEvent
    implements KailleraEvent {
        private StopFlagEvent() {
        }

        public String toString() {
            return "StopFlagEvent";
        }
    }
}

