/*
 * Decompiled with CFR 0.152.
 */
package org.emulinker.net;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.emulinker.util.EmuUtil;

public abstract class UDPRelay2 {
    private static Log log = LogFactory.getLog(UDPRelay2.class);
    public static final int DEFAULT_BUFFER_SIZE = 4096;
    private static int threadCounter = 0;
    protected int listenPort;
    protected int bufferSize;
    protected InetSocketAddress serverSocketAddress;
    protected boolean started = false;
    protected boolean stopFlag = false;
    protected Exception exception;
    protected Hashtable relayThreads = new Hashtable();
    protected Hashtable<Integer, DatagramChannel> channels = new Hashtable();

    public UDPRelay2(InetSocketAddress serverSocketAddress, int listenPort) {
        this(serverSocketAddress, listenPort, 4096);
    }

    public UDPRelay2(InetSocketAddress serverSocketAddress, int listenPort, int bufferSize) {
        this.serverSocketAddress = serverSocketAddress;
        this.listenPort = listenPort;
        this.bufferSize = bufferSize;
    }

    public int getListenPort() {
        return this.listenPort;
    }

    public InetSocketAddress getServerSocketAddress() {
        return this.serverSocketAddress;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public Exception getException() {
        return this.exception;
    }

    public boolean isStarted() {
        return this.started;
    }

    protected abstract ByteBuffer processClientToServer(ByteBuffer var1, InetSocketAddress var2, InetSocketAddress var3);

    protected abstract ByteBuffer processServerToClient(ByteBuffer var1, InetSocketAddress var2, InetSocketAddress var3);

    public synchronized void start() throws IOException {
        if (!this.started) {
            this.stopFlag = false;
            this.relayThreads.put(this.serverSocketAddress, new RelayThread(this.listenPort, this.serverSocketAddress));
            this.started = true;
        } else {
            log.warn((Object)"Already started");
        }
    }

    public synchronized void stop() {
        if (this.started) {
            log.debug((Object)"Stoping...");
            this.stopFlag = true;
            Enumeration e = this.relayThreads.elements();
            while (e.hasMoreElements()) {
                ((RelayThread)e.nextElement()).close();
            }
            this.started = false;
        } else {
            log.warn((Object)"Not running");
        }
    }

    protected class RelayThread
    extends Thread {
        protected int port;
        protected DatagramChannel channel;
        protected InetSocketAddress forwardAddress;
        protected String name;
        protected long lastActivity;
        protected boolean running = false;

        protected RelayThread(InetSocketAddress forwardAddress) throws IOException {
            this(-1, forwardAddress);
        }

        protected RelayThread(int port, InetSocketAddress forwardAddress) throws IOException {
            if (port > 0) {
                this.channel = UDPRelay2.this.channels.get(port);
                if (this.channel == null) {
                    this.channel = DatagramChannel.open();
                    this.channel.socket().bind(new InetSocketAddress(port));
                    UDPRelay2.this.channels.put(port, this.channel);
                    log.debug((Object)("Created new DatagramChannel bound to specific port " + this.channel.socket().getLocalPort() + " that will forward to " + EmuUtil.formatSocketAddress(forwardAddress)));
                } else {
                    log.debug((Object)("Using previously created DatagramChannel bound to port " + this.channel.socket().getLocalPort() + " that will forward to " + EmuUtil.formatSocketAddress(forwardAddress)));
                }
            } else {
                this.channel = DatagramChannel.open();
                this.channel.socket().bind(null);
                log.debug((Object)("Creating new DatagramChannel bound to arbitrary port " + this.channel.socket().getLocalPort() + " that will forward to " + EmuUtil.formatSocketAddress(forwardAddress)));
            }
            this.lastActivity = System.currentTimeMillis();
            this.forwardAddress = forwardAddress;
            this.name = "RelayThread." + threadCounter++ + ": " + this.channel.socket().getLocalPort() + "->" + EmuUtil.formatSocketAddress(forwardAddress);
            this.start();
            while (!this.running) {
                try {
                    Thread.sleep(100L);
                }
                catch (Exception e) {
                    log.error((Object)"Sleep Interrupted!", (Throwable)e);
                }
            }
        }

        public String toString() {
            return this.name;
        }

        public InetSocketAddress getForwardAddress() {
            return this.forwardAddress;
        }

        public long getLastActivity() {
            return this.lastActivity;
        }

        public DatagramChannel getChannel() {
            return this.channel;
        }

        public void send(ByteBuffer buffer, InetSocketAddress target) throws IOException {
            this.channel.send(buffer, target);
            this.lastActivity = System.currentTimeMillis();
        }

        public void close() {
            try {
                this.channel.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            log.debug((Object)(this.name + " Running"));
            try {
                ByteBuffer receiveBuffer = ByteBuffer.allocate(4096);
                while (!UDPRelay2.this.stopFlag) {
                    this.running = true;
                    receiveBuffer.clear();
                    InetSocketAddress fromAddress = (InetSocketAddress)this.channel.receive(receiveBuffer);
                    receiveBuffer.flip();
                    this.lastActivity = System.currentTimeMillis();
                    ByteBuffer sendBuffer = null;
                    sendBuffer = fromAddress.equals(UDPRelay2.this.getServerSocketAddress()) ? UDPRelay2.this.processServerToClient(receiveBuffer, fromAddress, this.getForwardAddress()) : UDPRelay2.this.processClientToServer(receiveBuffer, fromAddress, this.getForwardAddress());
                    if (sendBuffer == null || sendBuffer.limit() <= 0) continue;
                    RelayThread responseThread = (RelayThread)UDPRelay2.this.relayThreads.get(fromAddress);
                    if (responseThread == null) {
                        log.debug((Object)("No RelayThread is registered to forward to " + EmuUtil.formatSocketAddress(fromAddress) + "... creating new RelayThread"));
                        responseThread = new RelayThread(fromAddress);
                        UDPRelay2.this.relayThreads.put(fromAddress, responseThread);
                    }
                    responseThread.send(sendBuffer, this.getForwardAddress());
                }
            }
            catch (IOException e) {
                log.warn((Object)(this.name + " caught IOException"), (Throwable)e);
                if (UDPRelay2.this.exception != null) {
                    UDPRelay2.this.exception = e;
                }
            }
            catch (Exception e) {
                log.fatal((Object)(this.name + " caught unexpected exception"), (Throwable)e);
                if (UDPRelay2.this.exception != null) {
                    UDPRelay2.this.exception = e;
                }
            }
            finally {
                UDPRelay2.this.stop();
                this.running = false;
            }
            log.debug((Object)(this.name + " Exiting"));
        }
    }
}

