/*
 * Decompiled with CFR 0.152.
 */
package org.emulinker.net;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.emulinker.net.BindException;
import org.emulinker.util.EmuUtil;
import org.emulinker.util.Executable;
import org.picocontainer.Startable;

public abstract class UDPServer
implements Executable,
Startable {
    private static Log log = LogFactory.getLog(UDPServer.class);
    private int bindPort;
    private DatagramChannel channel;
    private boolean isRunning = false;
    private boolean stopFlag = false;

    public UDPServer() {
        this(true);
    }

    public UDPServer(boolean shutdownOnExit) {
        if (shutdownOnExit) {
            Runtime.getRuntime().addShutdownHook(new ShutdownThread());
        }
    }

    public int getBindPort() {
        return this.bindPort;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public synchronized boolean isBound() {
        if (this.channel == null) {
            return false;
        }
        if (this.channel.socket() == null) {
            return false;
        }
        return !this.channel.socket().isClosed();
    }

    public boolean isConnected() {
        return this.channel.isConnected();
    }

    public synchronized void start() {
        log.debug((Object)(this.toString() + " received start request!"));
        if (this.isRunning) {
            log.debug((Object)(this.toString() + " start request ignored: already running!"));
            return;
        }
        this.stopFlag = false;
    }

    protected boolean getStopFlag() {
        return this.stopFlag;
    }

    public synchronized void stop() {
        this.stopFlag = true;
        if (this.channel != null) {
            try {
                this.channel.close();
            }
            catch (IOException e) {
                log.error((Object)("Failed to close DatagramChannel: " + e.getMessage()));
            }
        }
    }

    protected synchronized void bind() throws BindException {
        this.bind(-1);
    }

    protected synchronized void bind(int port) throws BindException {
        try {
            this.channel = DatagramChannel.open();
            if (port > 0) {
                this.channel.socket().bind(new InetSocketAddress(port));
            } else {
                this.channel.socket().bind(null);
            }
            this.bindPort = this.channel.socket().getLocalPort();
            ByteBuffer tempBuffer = this.getBuffer();
            int bufferSize = tempBuffer.capacity() * 2;
            this.releaseBuffer(tempBuffer);
            this.channel.socket().setReceiveBufferSize(bufferSize);
            this.channel.socket().setSendBufferSize(bufferSize);
        }
        catch (IOException e) {
            throw new BindException("Failed to bind to port " + port, port, e);
        }
        this.start();
    }

    protected abstract ByteBuffer getBuffer();

    protected abstract void releaseBuffer(ByteBuffer var1);

    protected abstract void handleReceived(ByteBuffer var1, InetSocketAddress var2);

    protected void send(ByteBuffer buffer, InetSocketAddress toSocketAddress) {
        if (!this.isBound()) {
            log.warn((Object)("Failed to send to " + EmuUtil.formatSocketAddress(toSocketAddress) + ": UDPServer is not bound!"));
            return;
        }
        try {
            this.channel.send(buffer, toSocketAddress);
        }
        catch (Exception e) {
            log.error((Object)("Failed to send on port " + this.getBindPort() + ": " + e.getMessage()), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.isRunning = true;
        log.debug((Object)(this.toString() + ": thread running..."));
        try {
            while (!this.stopFlag) {
                try {
                    ByteBuffer buffer = this.getBuffer();
                    InetSocketAddress fromSocketAddress = (InetSocketAddress)this.channel.receive(buffer);
                    if (this.stopFlag) {
                        break;
                    }
                    if (fromSocketAddress == null) {
                        throw new IOException("Failed to receive from DatagramChannel: fromSocketAddress == null");
                    }
                    buffer.flip();
                    this.handleReceived(buffer, fromSocketAddress);
                    this.releaseBuffer(buffer);
                }
                catch (SocketException e) {
                    if (this.stopFlag) {
                        break;
                    }
                    log.error((Object)("Failed to receive on port " + this.getBindPort() + ": " + e.getMessage()));
                }
                catch (IOException e) {
                    if (this.stopFlag) {
                        break;
                    }
                    log.error((Object)("Failed to receive on port " + this.getBindPort() + ": " + e.getMessage()));
                }
            }
        }
        catch (Throwable e) {
            log.fatal((Object)("UDPServer on port " + this.getBindPort() + " caught unexpected exception!"), e);
            this.stop();
        }
        finally {
            this.isRunning = false;
            log.debug((Object)(this.toString() + ": thread exiting..."));
        }
    }

    private class ShutdownThread
    extends Thread {
        private ShutdownThread() {
        }

        public void run() {
            UDPServer.this.stop();
        }
    }
}

