/*
 * Decompiled with CFR 0.152.
 */
package org.emulinker.util;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EmuLang {
    private static Log log = LogFactory.getLog(EmuLang.class);
    private static final String BUNDLE_NAME = "language";
    private static final ResourceBundle RESOURCE_BUNDLE = ResourceBundle.getBundle("language");

    private EmuLang() {
    }

    public static boolean hasString(String key) {
        try {
            RESOURCE_BUNDLE.getString(key);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String getString(String key) {
        try {
            return RESOURCE_BUNDLE.getString(key);
        }
        catch (MissingResourceException e) {
            log.error((Object)("Missing language property: " + key));
            return key;
        }
    }

    public static String getString(String key, Object ... messageArgs) {
        try {
            return new MessageFormat(RESOURCE_BUNDLE.getString(key)).format(messageArgs);
        }
        catch (MissingResourceException e) {
            log.error((Object)("Missing language property: " + key));
            return key;
        }
    }
}

