/*
 * Decompiled with CFR 0.152.
 */
package org.emulinker.util;

import java.util.LinkedList;
import java.util.StringTokenizer;

public class WildcardStringPattern {
    protected boolean equals;
    protected boolean startsWith;
    protected boolean endsWith;
    protected boolean contains;
    private String startString = "";
    private String endString = "";
    private LinkedList<String> containsStrings = new LinkedList();

    public static void main(String[] args) {
        WildcardStringPattern test = new WildcardStringPattern(args[0]);
        for (int i = 1; i < args.length; ++i) {
            boolean match = test.match(args[i]);
            System.out.println(args[i] + " = " + match);
        }
    }

    public WildcardStringPattern(String pattern) {
        if (pattern == null || pattern.equals("")) {
            return;
        }
        LinkedList<String> elements = new LinkedList<String>();
        StringTokenizer st = new StringTokenizer(pattern, "*", true);
        while (st.hasMoreElements()) {
            elements.add(st.nextToken());
        }
        if (elements.size() == 1) {
            String s = (String)elements.getFirst();
            if (s.equals("*")) {
                return;
            }
            this.equals = true;
            this.startString = (String)elements.getFirst();
            return;
        }
        if (!((String)elements.getFirst()).equals("*")) {
            this.startsWith = true;
            this.startString = (String)elements.getFirst();
            elements.removeFirst();
        }
        if (!((String)elements.getLast()).equals("*")) {
            this.endsWith = true;
            this.endString = (String)elements.getLast();
            elements.removeLast();
        }
        for (String x : elements) {
            if (x.equals("*")) continue;
            this.containsStrings.add(x);
            this.contains = true;
        }
    }

    public boolean match(String s) {
        if (s == null || s.equals("")) {
            return false;
        }
        if (this.equals && !s.equals(this.startString)) {
            return false;
        }
        if (this.startsWith && !s.startsWith(this.startString)) {
            return false;
        }
        if (this.endsWith && !s.endsWith(this.endString)) {
            return false;
        }
        if (this.contains) {
            for (String pattern : this.containsStrings) {
                int idx = s.indexOf(pattern);
                if (idx == -1) {
                    return false;
                }
                if (idx + pattern.length() == s.length()) {
                    s = "";
                    continue;
                }
                s = s.substring(idx + pattern.length());
            }
        }
        return true;
    }

    public String toString() {
        if (this.equals) {
            return this.startString;
        }
        String s = this.startString;
        s = s + "*";
        for (String pattern : this.containsStrings) {
            s = s + pattern + "*";
        }
        s = s + this.endString;
        return s;
    }
}

