/*
 * Decompiled with CFR 0.152.
 */
package org.nanocontainer;

import java.io.File;
import java.io.IOException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.nanocontainer.script.ScriptedContainerBuilderFactory;
import org.picocontainer.defaults.ObjectReference;
import org.picocontainer.defaults.SimpleReference;

public class Standalone {
    private static final char HELP_OPT = 'h';
    private static final char VERSION_OPT = 'v';
    private static final char COMPOSITION_OPT = 'c';
    private static final char QUIET_OPT = 'q';
    private static final char NOWAIT_OPT = 'n';

    static final Options createOptions() {
        Options options = new Options();
        options.addOption(String.valueOf('h'), "help", false, "print this message and exit");
        options.addOption(String.valueOf('v'), "version", false, "print the version information and exit");
        options.addOption(String.valueOf('c'), "composition", true, "specify the composition file");
        options.addOption(String.valueOf('q'), "quiet", false, "forces ScriptedContainerBuilderFactory to be quiet");
        options.addOption(String.valueOf('n'), "nowait", false, "forces ScriptedContainerBuilderFactory to exit after start");
        return options;
    }

    public static void main(String[] args) {
        String composition;
        CommandLine cl = null;
        Options options = Standalone.createOptions();
        try {
            cl = Standalone.getCommandLine(args, options);
        }
        catch (ParseException e) {
            System.out.println("Error in parsing arguments: ");
            e.printStackTrace();
            System.exit(-1);
        }
        if (cl.hasOption('h')) {
            Standalone.printUsage(options);
            System.exit(0);
        }
        if (cl.hasOption('v')) {
            Standalone.printVersion();
            System.exit(0);
        }
        if ((composition = cl.getOptionValue('c')) == null) {
            Standalone.printUsage(options);
            System.exit(0);
        }
        boolean quiet = cl.hasOption('q');
        boolean nowait = cl.hasOption('n');
        try {
            Standalone.buildAndStartContainer(composition, quiet, nowait);
        }
        catch (RuntimeException e) {
            System.err.println("Failed to start application. Cause : " + e.getMessage());
            e.printStackTrace();
        }
        catch (IOException e) {
            System.err.println("Failed to start application for IO reasons. Exception message : " + e.getMessage());
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            System.err.println("Failed to start application. A Class was not found. Exception message : " + e.getMessage());
            e.printStackTrace();
        }
        if (!quiet) {
            System.out.println("Exiting ScriptedContainerBuilderFactory's standalone main method.");
        }
    }

    private static void buildAndStartContainer(String compositionFileName, boolean quiet, boolean nowait) throws IOException, ClassNotFoundException {
        ScriptedContainerBuilderFactory scriptedContainerBuilderFactory = new ScriptedContainerBuilderFactory(new File(compositionFileName));
        SimpleReference containerRef = new SimpleReference();
        scriptedContainerBuilderFactory.getContainerBuilder().buildContainer((ObjectReference)containerRef, null, null, true);
        if (!nowait) {
            Standalone.setShutdownHook(quiet, scriptedContainerBuilderFactory, (ObjectReference)containerRef);
        }
    }

    private static void setShutdownHook(final boolean quiet, final ScriptedContainerBuilderFactory scriptedContainerBuilderFactory, final ObjectReference containerRef) {
        Runnable shutdownHook = new Runnable(){

            public void run() {
                Standalone.shuttingDown(quiet, scriptedContainerBuilderFactory, containerRef);
            }
        };
        Runtime.getRuntime().addShutdownHook(new Thread(shutdownHook));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void shuttingDown(boolean quiet, ScriptedContainerBuilderFactory scriptedContainerBuilderFactory, ObjectReference containerRef) {
        try {
            scriptedContainerBuilderFactory.getContainerBuilder().killContainer(containerRef);
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
        finally {
            if (!quiet) {
                System.out.println("Exiting Virtual Machine");
            }
        }
    }

    static CommandLine getCommandLine(String[] args, Options options) throws ParseException {
        if (args.length == 0) {
            throw new ParseException("No arguments specified");
        }
        PosixParser parser = new PosixParser();
        return parser.parse(options, args);
    }

    private static void printUsage(Options options) {
        String lineSeparator = System.getProperty("line.separator");
        StringBuffer usage = new StringBuffer();
        usage.append(lineSeparator);
        usage.append("ScriptedContainerBuilderFactory: Standalone -c <composition> [-q|-n|-h|-v]");
        usage.append(options.getOptions());
        System.out.println(usage.toString());
    }

    private static void printVersion() {
        System.out.println("1.0");
    }
}

