/*
 * Decompiled with CFR 0.152.
 */
package org.nanocontainer.script.bsh;

import bsh.EvalError;
import bsh.Interpreter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import org.nanocontainer.script.bsh.BeanShellScriptInitializationException;
import org.picocontainer.Parameter;
import org.picocontainer.PicoContainer;
import org.picocontainer.PicoInitializationException;
import org.picocontainer.PicoIntrospectionException;
import org.picocontainer.defaults.AbstractComponentAdapter;
import org.picocontainer.defaults.UnsatisfiableDependenciesException;

public class BeanShellComponentAdapter
extends AbstractComponentAdapter {
    private final Parameter[] parameters;
    private Object instance = null;

    public BeanShellComponentAdapter(Object componentKey, Class componentImplementation, Parameter[] parameters) {
        super(componentKey, componentImplementation);
        this.parameters = parameters;
    }

    public Object getComponentInstance(PicoContainer pico) throws PicoInitializationException, PicoIntrospectionException {
        if (this.instance == null) {
            try {
                Interpreter i = new Interpreter();
                i.set("adapter", (Object)this);
                i.set("picoContainer", (Object)pico);
                i.set("componentKey", this.getComponentKey());
                i.set("componentImplementation", (Object)this.getComponentImplementation());
                i.set("parameters", (Object)(this.parameters != null ? Arrays.asList(this.parameters) : Collections.EMPTY_LIST));
                i.eval("import " + this.getComponentImplementation().getName() + ";");
                String scriptPath = "/" + this.getComponentImplementation().getName().replace('.', '/') + ".bsh";
                URL scriptURL = this.getComponentImplementation().getResource(scriptPath);
                if (scriptURL == null) {
                    throw new BeanShellScriptInitializationException("Couldn't load script at path " + scriptPath);
                }
                InputStreamReader sourceReader = new InputStreamReader(scriptURL.openStream());
                i.eval((Reader)sourceReader, i.getNameSpace(), scriptURL.toExternalForm());
                this.instance = i.get("instance");
                if (this.instance == null) {
                    throw new BeanShellScriptInitializationException("The 'instance' variable was not instantiated");
                }
            }
            catch (EvalError e) {
                throw new BeanShellScriptInitializationException(e);
            }
            catch (IOException e) {
                throw new BeanShellScriptInitializationException(e);
            }
        }
        return this.instance;
    }

    public void verify(PicoContainer pico) throws UnsatisfiableDependenciesException {
    }
}

