/*
 * Decompiled with CFR 0.152.
 */
package org.emulinker.kaillera.controller.v086;

import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.emulinker.kaillera.access.AccessManager;
import org.emulinker.kaillera.controller.KailleraServerController;
import org.emulinker.kaillera.controller.messaging.MessageFormatException;
import org.emulinker.kaillera.controller.messaging.ParseException;
import org.emulinker.kaillera.controller.v086.LastMessageBuffer;
import org.emulinker.kaillera.controller.v086.action.ACKAction;
import org.emulinker.kaillera.controller.v086.action.CachedGameDataAction;
import org.emulinker.kaillera.controller.v086.action.ChatAction;
import org.emulinker.kaillera.controller.v086.action.CloseGameAction;
import org.emulinker.kaillera.controller.v086.action.CreateGameAction;
import org.emulinker.kaillera.controller.v086.action.DropGameAction;
import org.emulinker.kaillera.controller.v086.action.FatalActionException;
import org.emulinker.kaillera.controller.v086.action.GameChatAction;
import org.emulinker.kaillera.controller.v086.action.GameDataAction;
import org.emulinker.kaillera.controller.v086.action.GameDesynchAction;
import org.emulinker.kaillera.controller.v086.action.GameInfoAction;
import org.emulinker.kaillera.controller.v086.action.GameKickAction;
import org.emulinker.kaillera.controller.v086.action.GameStatusAction;
import org.emulinker.kaillera.controller.v086.action.GameTimeoutAction;
import org.emulinker.kaillera.controller.v086.action.InfoMessageAction;
import org.emulinker.kaillera.controller.v086.action.JoinGameAction;
import org.emulinker.kaillera.controller.v086.action.KeepAliveAction;
import org.emulinker.kaillera.controller.v086.action.LoginAction;
import org.emulinker.kaillera.controller.v086.action.PlayerDesynchAction;
import org.emulinker.kaillera.controller.v086.action.QuitAction;
import org.emulinker.kaillera.controller.v086.action.QuitGameAction;
import org.emulinker.kaillera.controller.v086.action.StartGameAction;
import org.emulinker.kaillera.controller.v086.action.UserReadyAction;
import org.emulinker.kaillera.controller.v086.action.V086Action;
import org.emulinker.kaillera.controller.v086.action.V086GameEventHandler;
import org.emulinker.kaillera.controller.v086.action.V086ServerEventHandler;
import org.emulinker.kaillera.controller.v086.action.V086UserEventHandler;
import org.emulinker.kaillera.controller.v086.protocol.V086Bundle;
import org.emulinker.kaillera.controller.v086.protocol.V086BundleFormatException;
import org.emulinker.kaillera.controller.v086.protocol.V086Message;
import org.emulinker.kaillera.model.KailleraServer;
import org.emulinker.kaillera.model.KailleraUser;
import org.emulinker.kaillera.model.event.AllReadyEvent;
import org.emulinker.kaillera.model.event.ChatEvent;
import org.emulinker.kaillera.model.event.ConnectedEvent;
import org.emulinker.kaillera.model.event.GameChatEvent;
import org.emulinker.kaillera.model.event.GameClosedEvent;
import org.emulinker.kaillera.model.event.GameCreatedEvent;
import org.emulinker.kaillera.model.event.GameDataEvent;
import org.emulinker.kaillera.model.event.GameDesynchEvent;
import org.emulinker.kaillera.model.event.GameEvent;
import org.emulinker.kaillera.model.event.GameInfoEvent;
import org.emulinker.kaillera.model.event.GameStartedEvent;
import org.emulinker.kaillera.model.event.GameStatusChangedEvent;
import org.emulinker.kaillera.model.event.GameTimeoutEvent;
import org.emulinker.kaillera.model.event.InfoMessageEvent;
import org.emulinker.kaillera.model.event.KailleraEvent;
import org.emulinker.kaillera.model.event.KailleraEventListener;
import org.emulinker.kaillera.model.event.PlayerDesynchEvent;
import org.emulinker.kaillera.model.event.ServerEvent;
import org.emulinker.kaillera.model.event.UserDroppedGameEvent;
import org.emulinker.kaillera.model.event.UserEvent;
import org.emulinker.kaillera.model.event.UserJoinedEvent;
import org.emulinker.kaillera.model.event.UserJoinedGameEvent;
import org.emulinker.kaillera.model.event.UserQuitEvent;
import org.emulinker.kaillera.model.event.UserQuitGameEvent;
import org.emulinker.kaillera.model.exception.NewConnectionException;
import org.emulinker.kaillera.model.exception.ServerFullException;
import org.emulinker.net.BindException;
import org.emulinker.net.PrivateUDPServer;
import org.emulinker.util.ClientGameDataCache;
import org.emulinker.util.EmuUtil;
import org.emulinker.util.GameDataCache;
import org.emulinker.util.ServerGameDataCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class V086Controller
implements KailleraServerController {
    private static Log log = LogFactory.getLog(V086Controller.class);
    private int MAX_BUNDLE_SIZE = 5;
    private int bufferSize = 4096;
    private boolean isRunning = false;
    private ThreadPoolExecutor threadPool;
    private KailleraServer server;
    private AccessManager accessManager;
    private String[] clientTypes;
    private Map<Integer, V086ClientHandler> clientHandlers = new ConcurrentHashMap<Integer, V086ClientHandler>();
    private int portRangeStart;
    private int extraPorts;
    private Queue<Integer> portRangeQueue = new ConcurrentLinkedQueue<Integer>();
    private Map<Class, V086ServerEventHandler> serverEventHandlers = new HashMap<Class, V086ServerEventHandler>();
    private Map<Class, V086GameEventHandler> gameEventHandlers = new HashMap<Class, V086GameEventHandler>();
    private Map<Class, V086UserEventHandler> userEventHandlers = new HashMap<Class, V086UserEventHandler>();
    private V086Action[] actions = new V086Action[25];

    public V086Controller(KailleraServer server, ThreadPoolExecutor threadPool, AccessManager accessManager, Configuration config) throws NoSuchElementException, ConfigurationException {
        this.threadPool = threadPool;
        this.server = server;
        this.accessManager = accessManager;
        this.bufferSize = config.getInt("controllers.v086.bufferSize");
        this.clientTypes = config.getStringArray("controllers.v086.clientTypes.clientType");
        this.portRangeStart = config.getInt("controllers.v086.portRangeStart");
        this.extraPorts = config.getInt("controllers.v086.extraPorts", 0);
        int maxPort = 0;
        int i = this.portRangeStart;
        while (i <= this.portRangeStart + server.getMaxUsers() + this.extraPorts) {
            this.portRangeQueue.add(i);
            maxPort = i++;
        }
        log.warn((Object)("Listening on UDP ports: " + this.portRangeStart + " to " + maxPort + ".  Make sure these ports are open in your firewall!"));
        if (this.bufferSize <= 0) {
            throw new ConfigurationException("controllers.v086.bufferSize must be > 0");
        }
        this.actions[3] = LoginAction.getInstance();
        this.actions[6] = ACKAction.getInstance();
        this.actions[7] = ChatAction.getInstance();
        this.actions[10] = CreateGameAction.getInstance();
        this.actions[12] = JoinGameAction.getInstance();
        this.actions[9] = KeepAliveAction.getInstance();
        this.actions[11] = QuitGameAction.getInstance();
        this.actions[1] = QuitAction.getInstance();
        this.actions[17] = StartGameAction.getInstance();
        this.actions[8] = GameChatAction.getInstance();
        this.actions[15] = GameKickAction.getInstance();
        this.actions[21] = UserReadyAction.getInstance();
        this.actions[19] = CachedGameDataAction.getInstance();
        this.actions[18] = GameDataAction.getInstance();
        this.actions[20] = DropGameAction.getInstance();
        this.serverEventHandlers.put(ChatEvent.class, ChatAction.getInstance());
        this.serverEventHandlers.put(GameCreatedEvent.class, CreateGameAction.getInstance());
        this.serverEventHandlers.put(UserJoinedEvent.class, LoginAction.getInstance());
        this.serverEventHandlers.put(GameClosedEvent.class, CloseGameAction.getInstance());
        this.serverEventHandlers.put(UserQuitEvent.class, QuitAction.getInstance());
        this.serverEventHandlers.put(GameStatusChangedEvent.class, GameStatusAction.getInstance());
        this.gameEventHandlers.put(UserJoinedGameEvent.class, JoinGameAction.getInstance());
        this.gameEventHandlers.put(UserQuitGameEvent.class, QuitGameAction.getInstance());
        this.gameEventHandlers.put(GameStartedEvent.class, StartGameAction.getInstance());
        this.gameEventHandlers.put(GameChatEvent.class, GameChatAction.getInstance());
        this.gameEventHandlers.put(AllReadyEvent.class, UserReadyAction.getInstance());
        this.gameEventHandlers.put(GameDataEvent.class, GameDataAction.getInstance());
        this.gameEventHandlers.put(UserDroppedGameEvent.class, DropGameAction.getInstance());
        this.gameEventHandlers.put(GameDesynchEvent.class, GameDesynchAction.getInstance());
        this.gameEventHandlers.put(PlayerDesynchEvent.class, PlayerDesynchAction.getInstance());
        this.gameEventHandlers.put(GameInfoEvent.class, GameInfoAction.getInstance());
        this.gameEventHandlers.put(GameTimeoutEvent.class, GameTimeoutAction.getInstance());
        this.gameEventHandlers.put(GameTimeoutEvent.class, GameTimeoutAction.getInstance());
        this.userEventHandlers.put(ConnectedEvent.class, ACKAction.getInstance());
        this.userEventHandlers.put(InfoMessageEvent.class, InfoMessageAction.getInstance());
    }

    @Override
    public String getVersion() {
        return "v086";
    }

    @Override
    public String[] getClientTypes() {
        return this.clientTypes;
    }

    @Override
    public KailleraServer getServer() {
        return this.server;
    }

    @Override
    public int getNumClients() {
        return this.clientHandlers.size();
    }

    @Override
    public int getBufferSize() {
        return this.bufferSize;
    }

    public final Map<Class, V086ServerEventHandler> getServerEventHandlers() {
        return this.serverEventHandlers;
    }

    public final Map<Class, V086GameEventHandler> getGameEventHandlers() {
        return this.gameEventHandlers;
    }

    public final Map<Class, V086UserEventHandler> getUserEventHandlers() {
        return this.userEventHandlers;
    }

    public final V086Action[] getActions() {
        return this.actions;
    }

    public final Map<Integer, V086ClientHandler> getClientHandlers() {
        return this.clientHandlers;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public String toString() {
        return "V086Controller[clients=" + this.clientHandlers.size() + " isRunning=" + this.isRunning + "]";
    }

    @Override
    public int newConnection(InetSocketAddress clientSocketAddress, String protocol) throws ServerFullException, NewConnectionException {
        if (!this.isRunning) {
            throw new NewConnectionException("Controller is not running");
        }
        V086ClientHandler clientHandler = new V086ClientHandler(clientSocketAddress);
        KailleraUser user = this.server.newConnection(clientSocketAddress, protocol, clientHandler);
        int boundPort = -1;
        int bindAttempts = 0;
        while (bindAttempts++ < 5) {
            Integer portInteger = this.portRangeQueue.poll();
            if (portInteger == null) {
                log.error((Object)("No ports are available to bind for: " + user));
            } else {
                int port = portInteger;
                log.info((Object)("Private port " + port + " allocated to: " + user));
                try {
                    clientHandler.bind(port);
                    boundPort = port;
                    break;
                }
                catch (BindException e) {
                    log.error((Object)("Failed to bind to port " + port + " for: " + user + ": " + e.getMessage()), (Throwable)e);
                    log.debug((Object)(this.toString() + " returning port " + port + " to available port queue: " + (this.portRangeQueue.size() + 1) + " available"));
                    this.portRangeQueue.add(port);
                }
            }
            try {
                Thread.sleep(5L);
            }
            catch (InterruptedException e) {}
        }
        if (boundPort < 0) {
            clientHandler.stop();
            throw new NewConnectionException("Failed to bind!");
        }
        clientHandler.start(user);
        return boundPort;
    }

    public synchronized void start() {
        this.isRunning = true;
    }

    public synchronized void stop() {
        this.isRunning = false;
        for (V086ClientHandler clientHandler : this.clientHandlers.values()) {
            clientHandler.stop();
        }
        this.clientHandlers.clear();
    }

    public class V086ClientHandler
    extends PrivateUDPServer
    implements KailleraEventListener {
        private KailleraUser user;
        private int messageNumberCounter;
        private int prevMessageNumber;
        private int lastMessageNumber;
        private GameDataCache clientCache;
        private GameDataCache serverCache;
        private LastMessageBuffer lastMessageBuffer;
        private V086Message[] outMessages;
        private ByteBuffer inBuffer;
        private ByteBuffer outBuffer;
        private Object inSynch;
        private Object outSynch;
        private long testStart;
        private long lastMeasurement;
        private int measurementCount;
        private int bestTime;
        private int clientRetryCount;
        private long lastResend;

        private V086ClientHandler(InetSocketAddress remoteSocketAddress) {
            super(false, remoteSocketAddress.getAddress());
            this.messageNumberCounter = 0;
            this.prevMessageNumber = -1;
            this.lastMessageNumber = -1;
            this.clientCache = null;
            this.serverCache = null;
            this.lastMessageBuffer = new LastMessageBuffer(V086Controller.this.MAX_BUNDLE_SIZE);
            this.outMessages = new V086Message[V086Controller.this.MAX_BUNDLE_SIZE];
            this.inBuffer = ByteBuffer.allocateDirect(V086Controller.this.bufferSize);
            this.outBuffer = ByteBuffer.allocateDirect(V086Controller.this.bufferSize);
            this.inSynch = new Object();
            this.outSynch = new Object();
            this.measurementCount = 0;
            this.bestTime = Integer.MAX_VALUE;
            this.clientRetryCount = 0;
            this.lastResend = 0L;
            this.inBuffer.order(ByteOrder.LITTLE_ENDIAN);
            this.outBuffer.order(ByteOrder.LITTLE_ENDIAN);
            this.resetGameDataCache();
        }

        public String toString() {
            if (this.getBindPort() > 0) {
                return "V086Controller(" + this.getBindPort() + ")";
            }
            return "V086Controller(unbound)";
        }

        public V086Controller getController() {
            return V086Controller.this;
        }

        public KailleraUser getUser() {
            return this.user;
        }

        public synchronized int getNextMessageNumber() {
            if (this.messageNumberCounter > 65535) {
                this.messageNumberCounter = 0;
            }
            return this.messageNumberCounter++;
        }

        public int getPrevMessageNumber() {
            return this.prevMessageNumber;
        }

        public int getLastMessageNumber() {
            return this.lastMessageNumber;
        }

        public GameDataCache getClientGameDataCache() {
            return this.clientCache;
        }

        public GameDataCache getServerGameDataCache() {
            return this.serverCache;
        }

        public void resetGameDataCache() {
            this.clientCache = new ClientGameDataCache(256);
            this.serverCache = new ServerGameDataCache(256);
        }

        public void startSpeedTest() {
            this.testStart = this.lastMeasurement = System.currentTimeMillis();
            this.measurementCount = 0;
        }

        public void addSpeedMeasurement() {
            int et = (int)(System.currentTimeMillis() - this.lastMeasurement);
            if (et < this.bestTime) {
                this.bestTime = et;
            }
            ++this.measurementCount;
            this.lastMeasurement = System.currentTimeMillis();
        }

        public int getSpeedMeasurementCount() {
            return this.measurementCount;
        }

        public int getBestNetworkSpeed() {
            return this.bestTime;
        }

        public int getAverageNetworkSpeed() {
            return (int)((this.lastMeasurement - this.testStart) / (long)this.measurementCount);
        }

        public void bind(int port) throws BindException {
            super.bind(port);
        }

        public void start(KailleraUser user) {
            this.user = user;
            log.debug((Object)(this.toString() + " thread starting (ThreadPool:" + V086Controller.this.threadPool.getActiveCount() + "/" + V086Controller.this.threadPool.getPoolSize() + ")"));
            V086Controller.this.threadPool.execute(this);
            Thread.yield();
            log.debug((Object)(this.toString() + " thread started (ThreadPool:" + V086Controller.this.threadPool.getActiveCount() + "/" + V086Controller.this.threadPool.getPoolSize() + ")"));
            V086Controller.this.clientHandlers.put(user.getID(), this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stop() {
            V086ClientHandler v086ClientHandler = this;
            synchronized (v086ClientHandler) {
                if (this.getStopFlag()) {
                    return;
                }
                int port = -1;
                if (this.isBound()) {
                    port = this.getBindPort();
                }
                log.debug((Object)(this.toString() + " Stoping!"));
                super.stop();
                if (port > 0) {
                    log.debug((Object)(this.toString() + " returning port " + port + " to available port queue: " + (V086Controller.this.portRangeQueue.size() + 1) + " available"));
                    V086Controller.this.portRangeQueue.add(port);
                }
            }
            if (this.user != null) {
                V086Controller.this.clientHandlers.remove(this.user.getID());
                this.user.stop();
                this.user = null;
            }
        }

        protected ByteBuffer getBuffer() {
            this.inBuffer.clear();
            return this.inBuffer;
        }

        protected void releaseBuffer(ByteBuffer buffer) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void handleReceived(ByteBuffer buffer) {
            V086Bundle inBundle = null;
            try {
                inBundle = V086Bundle.parse(buffer, this.lastMessageNumber);
            }
            catch (ParseException e) {
                buffer.rewind();
                log.warn((Object)(this.toString() + " failed to parse: " + EmuUtil.dumpBuffer(buffer)), (Throwable)e);
                return;
            }
            catch (V086BundleFormatException e) {
                buffer.rewind();
                log.warn((Object)(this.toString() + " received invalid message bundle: " + EmuUtil.dumpBuffer(buffer)), (Throwable)e);
                return;
            }
            catch (MessageFormatException e) {
                buffer.rewind();
                log.warn((Object)(this.toString() + " received invalid message: " + EmuUtil.dumpBuffer(buffer)), (Throwable)e);
                return;
            }
            if (inBundle.getNumMessages() == 0) {
                log.debug((Object)(this.toString() + " received bundle of " + inBundle.getNumMessages() + " messages from " + this.user));
                ++this.clientRetryCount;
                this.resend(this.clientRetryCount);
                return;
            }
            this.clientRetryCount = 0;
            try {
                Object e = this.inSynch;
                synchronized (e) {
                    V086Message[] messages = inBundle.getMessages();
                    for (int i = inBundle.getNumMessages() - 1; i >= 0; --i) {
                        V086Action action;
                        if (messages[i].getNumber() <= this.lastMessageNumber) continue;
                        this.prevMessageNumber = this.lastMessageNumber;
                        this.lastMessageNumber = messages[i].getNumber();
                        if (this.prevMessageNumber + 1 != this.lastMessageNumber) {
                            log.warn((Object)(this.user + " dropped a packet! (" + this.prevMessageNumber + " to " + this.lastMessageNumber + ")"));
                            this.user.droppedPacket();
                        }
                        if ((action = V086Controller.this.actions[messages[i].getID()]) == null) {
                            log.error((Object)("No action defined to handle client message: " + messages[i]));
                            continue;
                        }
                        action.performAction(messages[i], this);
                    }
                }
            }
            catch (FatalActionException e) {
                log.warn((Object)(this.toString() + " fatal action, closing connection: " + e.getMessage()));
                Thread.yield();
                this.stop();
            }
        }

        public void actionPerformed(KailleraEvent event) {
            if (event instanceof GameEvent) {
                V086GameEventHandler eventHandler = (V086GameEventHandler)V086Controller.this.gameEventHandlers.get(event.getClass());
                if (eventHandler == null) {
                    log.error((Object)(this.toString() + " found no GameEventHandler registered to handle game event: " + event));
                    return;
                }
                eventHandler.handleEvent((GameEvent)event, this);
            } else if (event instanceof ServerEvent) {
                V086ServerEventHandler eventHandler = (V086ServerEventHandler)V086Controller.this.serverEventHandlers.get(event.getClass());
                if (eventHandler == null) {
                    log.error((Object)(this.toString() + " found no ServerEventHandler registered to handle server event: " + event));
                    return;
                }
                eventHandler.handleEvent((ServerEvent)event, this);
            } else if (event instanceof UserEvent) {
                V086UserEventHandler eventHandler = (V086UserEventHandler)V086Controller.this.userEventHandlers.get(event.getClass());
                if (eventHandler == null) {
                    log.error((Object)(this.toString() + " found no UserEventHandler registered to handle user event: " + event));
                    return;
                }
                eventHandler.handleEvent((UserEvent)event, this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resend(int timeoutCounter) {
            Object object = this.outSynch;
            synchronized (object) {
                if (System.currentTimeMillis() - this.lastResend > (long)V086Controller.this.server.getMaxPing()) {
                    int numToSend = 3 * timeoutCounter;
                    if (numToSend > V086Controller.this.MAX_BUNDLE_SIZE) {
                        numToSend = V086Controller.this.MAX_BUNDLE_SIZE;
                    }
                    log.debug((Object)(this + ": resending last " + numToSend + " messages"));
                    this.send(null, numToSend);
                    this.lastResend = System.currentTimeMillis();
                } else {
                    log.debug((Object)"Skipping resend...");
                }
            }
        }

        public void send(V086Message outMessage) {
            this.send(outMessage, 3);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void send(V086Message outMessage, int numToSend) {
            Object object = this.outSynch;
            synchronized (object) {
                if (outMessage != null) {
                    this.lastMessageBuffer.add(outMessage);
                }
                numToSend = this.lastMessageBuffer.fill(this.outMessages, numToSend);
                V086Bundle outBundle = new V086Bundle(this.outMessages, numToSend);
                outBundle.writeTo(this.outBuffer);
                this.outBuffer.flip();
                super.send(this.outBuffer);
                this.outBuffer.clear();
            }
        }
    }
}

