/*
 * Decompiled with CFR 0.152.
 */
package org.emulinker.kaillera.controller.v086.action;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.emulinker.kaillera.controller.v086.V086Controller;
import org.emulinker.kaillera.controller.v086.action.V086GameEventHandler;
import org.emulinker.kaillera.model.KailleraUser;
import org.emulinker.kaillera.model.event.GameEvent;
import org.emulinker.kaillera.model.event.GameTimeoutEvent;

public class GameTimeoutAction
implements V086GameEventHandler {
    private static Log log = LogFactory.getLog(GameTimeoutAction.class);
    private static final String desc = "GameTimeoutAction";
    private static GameTimeoutAction singleton = new GameTimeoutAction();
    private int handledCount = 0;

    public static GameTimeoutAction getInstance() {
        return singleton;
    }

    private GameTimeoutAction() {
    }

    public int getHandledEventCount() {
        return this.handledCount;
    }

    public String toString() {
        return desc;
    }

    public void handleEvent(GameEvent event, V086Controller.V086ClientHandler clientHandler) {
        KailleraUser user;
        ++this.handledCount;
        GameTimeoutEvent timeoutEvent = (GameTimeoutEvent)event;
        KailleraUser player = timeoutEvent.getUser();
        if (player.equals(user = clientHandler.getUser())) {
            log.debug((Object)(user + " received timeout event " + timeoutEvent.getTimeoutNumber() + " for " + timeoutEvent.getGame() + ": resending messages..."));
            clientHandler.resend(timeoutEvent.getTimeoutNumber());
        } else {
            log.debug((Object)(user + " received timeout event " + timeoutEvent.getTimeoutNumber() + " from " + player + " for " + timeoutEvent.getGame()));
        }
    }
}

