/*
 * Decompiled with CFR 0.152.
 */
package org.emulinker.kaillera.controller.v086.protocol;

import java.nio.ByteBuffer;
import org.emulinker.kaillera.controller.messaging.MessageFormatException;
import org.emulinker.kaillera.controller.messaging.ParseException;
import org.emulinker.kaillera.controller.v086.protocol.V086Message;
import org.emulinker.util.EmuUtil;
import org.emulinker.util.UnsignedUtil;

public class GameData
extends V086Message {
    public static final byte ID = 18;
    public static final String DESC = "Game Data";
    private byte[] gameData;

    public static void main(String[] args) throws Exception {
        byte[] data = new byte[9];
        long st = System.currentTimeMillis();
        GameData msg = new GameData(0, data);
        ByteBuffer byteByffer = ByteBuffer.allocateDirect(4096);
        for (int i = 0; i < 65535; ++i) {
            msg.writeTo(byteByffer);
            byteByffer.clear();
        }
        System.out.println("et=" + (System.currentTimeMillis() - st));
    }

    public GameData(int messageNumber, byte[] gameData) throws MessageFormatException {
        super(messageNumber);
        if (gameData.length <= 0 || gameData.length > 65535) {
            throw new MessageFormatException("Invalid " + this.getDescription() + " format: gameData.remaining() = " + gameData.length);
        }
        this.gameData = gameData;
    }

    public byte getID() {
        return 18;
    }

    public String getDescription() {
        return DESC;
    }

    public byte[] getGameData() {
        return this.gameData;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getInfoString());
        sb.append("[gameData=");
        sb.append(EmuUtil.arrayToString(this.gameData, ','));
        sb.append("]");
        return sb.toString();
    }

    public int getBodyLength() {
        return this.gameData.length + 3;
    }

    public void writeBodyTo(ByteBuffer buffer) {
        buffer.put((byte)0);
        UnsignedUtil.putUnsignedShort(buffer, this.gameData.length);
        buffer.put(this.gameData);
    }

    public static GameData parse(int messageNumber, ByteBuffer buffer) throws ParseException, MessageFormatException {
        if (buffer.remaining() < 4) {
            throw new ParseException("Failed byte count validation!");
        }
        byte b = buffer.get();
        int dataSize = UnsignedUtil.getUnsignedShort(buffer);
        if (dataSize <= 0 || dataSize > buffer.remaining()) {
            throw new MessageFormatException("Invalid Game Data format: dataSize = " + dataSize);
        }
        byte[] gameData = new byte[dataSize];
        buffer.get(gameData);
        return new GameData(messageNumber, gameData);
    }
}

