/*
 * Decompiled with CFR 0.152.
 */
package org.emulinker.kaillera.controller.v086.protocol;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.emulinker.kaillera.controller.messaging.ByteBufferMessage;
import org.emulinker.kaillera.controller.messaging.MessageFormatException;
import org.emulinker.kaillera.controller.messaging.ParseException;
import org.emulinker.kaillera.controller.v086.protocol.V086BundleFormatException;
import org.emulinker.kaillera.controller.v086.protocol.V086Message;
import org.emulinker.util.EmuUtil;
import org.emulinker.util.UnsignedUtil;

public class V086Bundle
extends ByteBufferMessage {
    public static final String DESC = "Kaillera v.086 Message Bundle";
    protected V086Message[] messages;
    protected int numToWrite;
    protected int length = -1;

    public V086Bundle(V086Message[] messages) {
        this(messages, Integer.MAX_VALUE);
    }

    public V086Bundle(V086Message[] messages, int numToWrite) {
        this.numToWrite = messages.length;
        if (numToWrite < this.numToWrite) {
            this.numToWrite = numToWrite;
        }
        this.messages = messages;
    }

    public String getDescription() {
        return DESC;
    }

    public int getNumMessages() {
        return this.numToWrite;
    }

    public V086Message[] getMessages() {
        return this.messages;
    }

    public int getLength() {
        if (this.length == -1) {
            for (int i = 0; i < this.numToWrite && this.messages[i] != null; ++i) {
                this.length += this.messages[i].getLength();
            }
        }
        return this.length;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Kaillera v.086 Message Bundle (" + this.numToWrite + " messages) (" + this.getLength() + " bytes)");
        sb.append(EmuUtil.LB);
        for (int i = 0; i < this.numToWrite && this.messages[i] != null; ++i) {
            sb.append("\tMessage " + (i + 1) + ": " + this.messages[i].toString() + EmuUtil.LB);
        }
        return sb.toString();
    }

    public void writeTo(ByteBuffer buffer) {
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        buffer.put((byte)this.numToWrite);
        for (int i = 0; i < this.numToWrite && this.messages[i] != null; ++i) {
            this.messages[i].writeTo(buffer);
        }
    }

    public static V086Bundle parse(ByteBuffer buffer) throws ParseException, V086BundleFormatException, MessageFormatException {
        return V086Bundle.parse(buffer, -1);
    }

    public static V086Bundle parse(ByteBuffer buffer, int lastMessageID) throws ParseException, V086BundleFormatException, MessageFormatException {
        int messageNumber;
        int parsedCount;
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        if (buffer.limit() < 5) {
            throw new V086BundleFormatException("Invalid buffer length: " + buffer.limit());
        }
        int messageCount = buffer.get();
        if (messageCount <= 0 || messageCount > 32) {
            throw new V086BundleFormatException("Invalid message count: " + messageCount);
        }
        if (buffer.limit() < 1 + messageCount * 6) {
            throw new V086BundleFormatException("Invalid bundle length: " + buffer.limit());
        }
        V086Message[] messages = new V086Message[messageCount];
        for (parsedCount = 0; parsedCount < messageCount && (messageNumber = UnsignedUtil.getUnsignedShort(buffer)) > lastMessageID; ++parsedCount) {
            short messageLength = buffer.getShort();
            if (messageLength < 2 || messageLength > buffer.remaining() || messageLength > buffer.limit()) {
                throw new ParseException("Invalid message length: " + messageLength);
            }
            messages[parsedCount] = V086Message.parse(messageNumber, messageLength, buffer);
        }
        return new V086Bundle(messages, parsedCount);
    }
}

