/*
 * Decompiled with CFR 0.152.
 */
package org.emulinker.kaillera.model;

import java.util.Collection;
import org.emulinker.kaillera.model.KailleraServer;
import org.emulinker.kaillera.model.KailleraUser;
import org.emulinker.kaillera.model.exception.CloseGameException;
import org.emulinker.kaillera.model.exception.DropGameException;
import org.emulinker.kaillera.model.exception.GameChatException;
import org.emulinker.kaillera.model.exception.GameDataException;
import org.emulinker.kaillera.model.exception.GameKickException;
import org.emulinker.kaillera.model.exception.JoinGameException;
import org.emulinker.kaillera.model.exception.QuitGameException;
import org.emulinker.kaillera.model.exception.StartGameException;
import org.emulinker.kaillera.model.exception.UserReadyException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface KailleraGame {
    public static final byte STATUS_WAITING = 0;
    public static final byte STATUS_PLAYING = 1;
    public static final byte STATUS_SYNCHRONIZING = 2;
    public static final String[] STATUS_NAMES = new String[]{"Waiting", "Playing", "Synchronizing"};

    public int getID();

    public String getRomName();

    public String getClientType();

    public KailleraUser getOwner();

    public int getPlayerNumber(KailleraUser var1);

    public int getNumPlayers();

    public KailleraUser getPlayer(int var1);

    public Collection<? extends KailleraUser> getPlayers();

    public int getStatus();

    public KailleraServer getServer();

    public void droppedPacket(KailleraUser var1);

    public int join(KailleraUser var1) throws JoinGameException;

    public void chat(KailleraUser var1, String var2) throws GameChatException;

    public void kick(KailleraUser var1, int var2) throws GameKickException;

    public void start(KailleraUser var1) throws StartGameException;

    public void ready(KailleraUser var1, int var2) throws UserReadyException;

    public void addData(KailleraUser var1, int var2, byte[] var3) throws GameDataException;

    public void drop(KailleraUser var1, int var2) throws DropGameException;

    public void quit(KailleraUser var1, int var2) throws DropGameException, QuitGameException, CloseGameException;
}

