/*
 * Decompiled with CFR 0.152.
 */
package org.emulinker.kaillera.model;

import java.net.InetSocketAddress;
import java.util.Collection;
import org.emulinker.kaillera.model.KailleraGame;
import org.emulinker.kaillera.model.KailleraUser;
import org.emulinker.kaillera.model.event.KailleraEventListener;
import org.emulinker.kaillera.model.exception.ChatException;
import org.emulinker.kaillera.model.exception.ClientAddressException;
import org.emulinker.kaillera.model.exception.CloseGameException;
import org.emulinker.kaillera.model.exception.ConnectionTypeException;
import org.emulinker.kaillera.model.exception.CreateGameException;
import org.emulinker.kaillera.model.exception.DropGameException;
import org.emulinker.kaillera.model.exception.FloodException;
import org.emulinker.kaillera.model.exception.LoginException;
import org.emulinker.kaillera.model.exception.NewConnectionException;
import org.emulinker.kaillera.model.exception.PingTimeException;
import org.emulinker.kaillera.model.exception.QuitException;
import org.emulinker.kaillera.model.exception.QuitGameException;
import org.emulinker.kaillera.model.exception.ServerFullException;
import org.emulinker.kaillera.model.exception.UserNameException;
import org.emulinker.release.ReleaseInfo;
import org.picocontainer.Startable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface KailleraServer
extends Startable {
    public ReleaseInfo getReleaseInfo();

    public int getNumUsers();

    public int getNumGames();

    public int getMaxUsers();

    public int getMaxGames();

    public int getMaxPing();

    public Collection<? extends KailleraUser> getUsers();

    public Collection<? extends KailleraGame> getGames();

    public KailleraUser getUser(int var1);

    public KailleraGame getGame(int var1);

    public KailleraUser newConnection(InetSocketAddress var1, String var2, KailleraEventListener var3) throws ServerFullException, NewConnectionException;

    public void login(KailleraUser var1) throws PingTimeException, ClientAddressException, ConnectionTypeException, UserNameException, LoginException;

    public void chat(KailleraUser var1, String var2) throws ChatException, FloodException;

    public KailleraGame createGame(KailleraUser var1, String var2) throws CreateGameException, FloodException;

    public void quit(KailleraUser var1, String var2) throws QuitException, DropGameException, QuitGameException, CloseGameException;
}

