/*
 * Decompiled with CFR 0.152.
 */
package org.emulinker.kaillera.model.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.emulinker.kaillera.master.StatsCollector;
import org.emulinker.kaillera.model.KailleraGame;
import org.emulinker.kaillera.model.KailleraUser;
import org.emulinker.kaillera.model.event.AllReadyEvent;
import org.emulinker.kaillera.model.event.GameChatEvent;
import org.emulinker.kaillera.model.event.GameDataEvent;
import org.emulinker.kaillera.model.event.GameEvent;
import org.emulinker.kaillera.model.event.GameInfoEvent;
import org.emulinker.kaillera.model.event.GameStartedEvent;
import org.emulinker.kaillera.model.event.GameStatusChangedEvent;
import org.emulinker.kaillera.model.event.GameTimeoutEvent;
import org.emulinker.kaillera.model.event.PlayerDesynchEvent;
import org.emulinker.kaillera.model.event.UserDroppedGameEvent;
import org.emulinker.kaillera.model.event.UserJoinedGameEvent;
import org.emulinker.kaillera.model.event.UserQuitGameEvent;
import org.emulinker.kaillera.model.exception.CloseGameException;
import org.emulinker.kaillera.model.exception.DropGameException;
import org.emulinker.kaillera.model.exception.GameChatException;
import org.emulinker.kaillera.model.exception.GameDataException;
import org.emulinker.kaillera.model.exception.GameKickException;
import org.emulinker.kaillera.model.exception.JoinGameException;
import org.emulinker.kaillera.model.exception.QuitGameException;
import org.emulinker.kaillera.model.exception.StartGameException;
import org.emulinker.kaillera.model.exception.UserReadyException;
import org.emulinker.kaillera.model.impl.AutoFireDetector;
import org.emulinker.kaillera.model.impl.KailleraServerImpl;
import org.emulinker.kaillera.model.impl.KailleraUserImpl;
import org.emulinker.kaillera.model.impl.PlayerActionQueue;
import org.emulinker.kaillera.model.impl.PlayerTimeoutException;
import org.emulinker.util.EmuLang;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class KailleraGameImpl
implements KailleraGame {
    private static Log log = LogFactory.getLog(KailleraGameImpl.class);
    private int id;
    private String romName;
    private String toString;
    private Date startDate;
    private int bufferSize;
    private int timeoutMillis;
    private int desynchTimeouts;
    private KailleraServerImpl server;
    private KailleraUserImpl owner;
    private List<KailleraUserImpl> players = new CopyOnWriteArrayList<KailleraUserImpl>();
    private StatsCollector statsCollector;
    private List<Integer> kickedUsers = new ArrayList<Integer>();
    private int status = 0;
    private boolean synched = false;
    private int actionsPerMessage;
    private PlayerActionQueue[] playerActionQueues;
    private AutoFireDetector autoFireDetector;

    public KailleraGameImpl(int gameID, String romName, KailleraUserImpl owner, KailleraServerImpl server, int bufferSize, int timeoutMillis, int desynchTimeouts) {
        this.id = gameID;
        this.romName = romName;
        this.owner = owner;
        this.server = server;
        this.actionsPerMessage = owner.getConnectionType();
        this.bufferSize = bufferSize;
        this.timeoutMillis = timeoutMillis;
        this.desynchTimeouts = desynchTimeouts;
        this.toString = "Game" + this.id + "(" + (romName.length() > 15 ? romName.substring(0, 15) + "..." : romName) + ")";
        this.startDate = new Date();
        this.statsCollector = server.getStatsCollector();
        this.autoFireDetector = server.getAutoFireDetector(this);
    }

    @Override
    public int getID() {
        return this.id;
    }

    @Override
    public String getRomName() {
        return this.romName;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    @Override
    public KailleraUser getOwner() {
        return this.owner;
    }

    @Override
    public int getPlayerNumber(KailleraUser user) {
        return this.players.indexOf(user) + 1;
    }

    @Override
    public KailleraUser getPlayer(int playerNumber) {
        if (playerNumber > this.players.size()) {
            log.error((Object)(this + ": getPlayer(" + playerNumber + ") failed! (size = " + this.players.size() + ")"));
            return null;
        }
        return this.players.get(playerNumber - 1);
    }

    @Override
    public int getNumPlayers() {
        return this.players.size();
    }

    public List<KailleraUserImpl> getPlayers() {
        return this.players;
    }

    @Override
    public int getStatus() {
        return this.status;
    }

    public boolean isSynched() {
        return this.synched;
    }

    @Override
    public KailleraServerImpl getServer() {
        return this.server;
    }

    void setStatus(int status) {
        this.status = status;
        this.server.addEvent(new GameStatusChangedEvent(this.server, this));
    }

    @Override
    public String getClientType() {
        return this.getOwner().getClientType();
    }

    public String toString() {
        return this.toString;
    }

    public String toDetailedString() {
        StringBuilder sb = new StringBuilder();
        sb.append("KailleraGame[id=");
        sb.append(this.getID());
        sb.append(" romName=");
        sb.append(this.getRomName());
        sb.append(" owner=");
        sb.append(this.getOwner());
        sb.append(" numPlayers=");
        sb.append(this.getNumPlayers());
        sb.append(" status=");
        sb.append(KailleraGame.STATUS_NAMES[this.getStatus()]);
        sb.append("]");
        return sb.toString();
    }

    int getPlayingCount() {
        int count = 0;
        for (KailleraUserImpl player : this.players) {
            if (player.getStatus() != 0) continue;
            ++count;
        }
        return count;
    }

    int getSynchedCount() {
        if (this.playerActionQueues == null) {
            return 0;
        }
        int count = 0;
        for (int i = 0; i < this.playerActionQueues.length; ++i) {
            if (!this.playerActionQueues[i].isSynched()) continue;
            ++count;
        }
        return count;
    }

    void addEvent(GameEvent event) {
        for (KailleraUserImpl player : this.players) {
            player.addEvent(event);
        }
    }

    public AutoFireDetector getAutoFireDetector() {
        return this.autoFireDetector;
    }

    @Override
    public synchronized void chat(KailleraUser user, String message) throws GameChatException {
        if (!this.players.contains(user)) {
            log.warn((Object)(user + " game chat denied: not in " + this));
            throw new GameChatException(EmuLang.getString("KailleraGameImpl.GameChatErrorNotInGame"));
        }
        log.info((Object)(user + ", " + this + " gamechat: " + message));
        this.addEvent(new GameChatEvent(this, user, message));
    }

    public synchronized void announce(String announcement) {
        this.addEvent(new GameInfoEvent(this, announcement));
    }

    @Override
    public synchronized void kick(KailleraUser user, int userID) throws GameKickException {
        if (!user.equals(this.getOwner())) {
            log.warn((Object)(user + " kick denied: not the owner of " + this));
            throw new GameKickException(EmuLang.getString("KailleraGameImpl.GameKickDeniedNotGameOwner"));
        }
        if (user.getID() == userID) {
            log.warn((Object)(user + " kick denied: attempt to kick self"));
            throw new GameKickException(EmuLang.getString("KailleraGameImpl.GameKickDeniedCannotKickSelf"));
        }
        for (KailleraUserImpl player : this.players) {
            if (player.getID() != userID) continue;
            try {
                log.info((Object)(user + " kicked: " + userID + " from " + this));
                this.kickedUsers.add(userID);
                player.quitGame();
                return;
            }
            catch (Exception e) {
                log.error((Object)"Caught exception while making user quit game! This shouldn't happen!", (Throwable)e);
            }
        }
        log.warn((Object)(user + " kick failed: user " + userID + " not found in: " + this));
        throw new GameKickException(EmuLang.getString("KailleraGameImpl.GameKickErrorUserNotFound"));
    }

    @Override
    public synchronized int join(KailleraUser user) throws JoinGameException {
        if (this.players.contains(user)) {
            log.warn((Object)(user + " join game denied: already in " + this));
            throw new JoinGameException(EmuLang.getString("KailleraGameImpl.JoinGameErrorAlreadyInGame"));
        }
        int access = this.server.getAccessManager().getAccess(user.getSocketAddress().getAddress());
        if (access == 1 && this.kickedUsers.contains(user.getID())) {
            log.warn((Object)(user + " join game denied: previously kicked: " + this));
            throw new JoinGameException(EmuLang.getString("KailleraGameImpl.JoinGameDeniedPreviouslyKicked"));
        }
        if (access == 1 && this.getStatus() != 0) {
            log.warn((Object)(user + " join game denied: attempt to join game in progress: " + this));
            throw new JoinGameException(EmuLang.getString("KailleraGameImpl.JoinGameDeniedGameIsInProgress"));
        }
        this.players.add((KailleraUserImpl)user);
        this.server.addEvent(new GameStatusChangedEvent(this.server, this));
        log.info((Object)(user + " joined: " + this));
        this.addEvent(new UserJoinedGameEvent(this, user));
        if (user.equals(this.owner) && this.autoFireDetector != null) {
            if (this.autoFireDetector.getSensitivity() > 0) {
                this.announce(EmuLang.getString("KailleraGameImpl.AutofireDetectionOn"));
                this.announce(EmuLang.getString("KailleraGameImpl.AutofireCurrentSensitivity", this.autoFireDetector.getSensitivity()));
            } else {
                this.announce(EmuLang.getString("KailleraGameImpl.AutofireDetectionOff"));
            }
            this.announce(EmuLang.getString("KailleraGameImpl.GameHelp"));
        }
        return this.players.indexOf(user) + 1;
    }

    @Override
    public synchronized void start(KailleraUser user) throws StartGameException {
        if (!user.equals(this.getOwner())) {
            log.warn((Object)(user + " start game denied: not the owner of " + this));
            throw new StartGameException(EmuLang.getString("KailleraGameImpl.StartGameDeniedOnlyOwnerMayStart"));
        }
        if (this.status == 2) {
            log.warn((Object)(user + " start game failed: " + this + " status is " + KailleraGame.STATUS_NAMES[this.status]));
            throw new StartGameException(EmuLang.getString("KailleraGameImpl.StartGameErrorSynchronizing"));
        }
        if (this.status == 1) {
            log.warn((Object)(user + " start game failed: " + this + " status is " + KailleraGame.STATUS_NAMES[this.status]));
            throw new StartGameException(EmuLang.getString("KailleraGameImpl.StartGameErrorStatusIsPlaying"));
        }
        int access = this.server.getAccessManager().getAccess(user.getSocketAddress().getAddress());
        if (access == 1 && this.getNumPlayers() < 2 && !this.server.getAllowSinglePlayer()) {
            log.warn((Object)(user + " start game denied: " + this + " needs at least 2 players"));
            throw new StartGameException(EmuLang.getString("KailleraGameImpl.StartGameDeniedSinglePlayerNotAllowed"));
        }
        for (KailleraUserImpl player : this.players) {
            if (player.getConnectionType() != this.owner.getConnectionType()) {
                log.warn((Object)(user + " start game denied: " + this + ": All players must use the same connection type"));
                this.addEvent(new GameInfoEvent(this, EmuLang.getString("KailleraGameImpl.StartGameConnectionTypeMismatchInfo", KailleraUser.CONNECTION_TYPE_NAMES[this.owner.getConnectionType()])));
                throw new StartGameException(EmuLang.getString("KailleraGameImpl.StartGameDeniedConnectionTypeMismatch"));
            }
            if (player.getClientType().equals(this.getClientType())) continue;
            log.warn((Object)(user + " start game denied: " + this + ": All players must use the same emulator!"));
            this.addEvent(new GameInfoEvent(this, EmuLang.getString("KailleraGameImpl.StartGameEmulatorMismatchInfo", this.getClientType())));
            throw new StartGameException(EmuLang.getString("KailleraGameImpl.StartGameDeniedEmulatorMismatch"));
        }
        log.info((Object)(user + " started: " + this));
        this.setStatus(2);
        if (this.autoFireDetector != null) {
            this.autoFireDetector.start(this.players.size());
        }
        this.playerActionQueues = new PlayerActionQueue[this.players.size()];
        for (int i = 0; i < this.playerActionQueues.length; ++i) {
            KailleraUserImpl player;
            player = this.players.get(i);
            int playerNumber = i + 1;
            this.playerActionQueues[i] = new PlayerActionQueue(playerNumber, player, this.getNumPlayers(), this.bufferSize, this.timeoutMillis, true);
            player.setPlayerNumber(playerNumber);
            log.info((Object)(this + ": " + player + " is player number " + playerNumber));
            if (this.autoFireDetector == null) continue;
            this.autoFireDetector.addPlayer(player, playerNumber);
        }
        if (this.statsCollector != null) {
            this.statsCollector.gameStarted(this.server, this);
        }
        this.addEvent(new GameStartedEvent(this));
    }

    @Override
    public synchronized void ready(KailleraUser user, int playerNumber) throws UserReadyException {
        if (!this.players.contains(user)) {
            log.warn((Object)(user + " ready game failed: not in " + this));
            throw new UserReadyException(EmuLang.getString("KailleraGameImpl.ReadyGameErrorNotInGame"));
        }
        if (this.status != 2) {
            log.warn((Object)(user + " ready failed: " + this + " status is " + KailleraGame.STATUS_NAMES[this.status]));
            throw new UserReadyException(EmuLang.getString("KailleraGameImpl.ReadyGameErrorIncorrectState"));
        }
        if (this.playerActionQueues == null) {
            log.error((Object)(user + " ready failed: " + this + " playerActionQueues == null!"));
            throw new UserReadyException(EmuLang.getString("KailleraGameImpl.ReadyGameErrorInternalError"));
        }
        log.info((Object)(user + " (player " + playerNumber + ") is ready to play: " + this));
        this.playerActionQueues[playerNumber - 1].setSynched(true);
        if (this.getSynchedCount() == this.getNumPlayers()) {
            log.info((Object)(this + " all players are ready: starting..."));
            this.setStatus(1);
            this.synched = true;
            this.addEvent(new AllReadyEvent(this));
        }
    }

    @Override
    public synchronized void drop(KailleraUser user, int playerNumber) throws DropGameException {
        if (!this.players.contains(user)) {
            log.warn((Object)(user + " drop game failed: not in " + this));
            throw new DropGameException(EmuLang.getString("KailleraGameImpl.DropGameErrorNotInGame"));
        }
        if (this.playerActionQueues == null) {
            log.error((Object)(user + " drop failed: " + this + " playerActionQueues == null!"));
            throw new DropGameException(EmuLang.getString("KailleraGameImpl.DropGameErrorInternalError"));
        }
        log.info((Object)(user + " dropped: " + this));
        this.playerActionQueues[playerNumber - 1].setSynched(false);
        if (this.getSynchedCount() < 2 && this.synched) {
            this.synched = false;
            for (PlayerActionQueue q : this.playerActionQueues) {
                q.setSynched(false);
            }
            log.info((Object)(this + ": game desynched: less than 2 players playing!"));
        }
        if (this.autoFireDetector != null) {
            this.autoFireDetector.stop(playerNumber);
        }
        if (this.getPlayingCount() == 0) {
            this.setStatus(0);
        }
        this.addEvent(new UserDroppedGameEvent(this, user, playerNumber));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void quit(KailleraUser user, int playerNumber) throws DropGameException, QuitGameException, CloseGameException {
        KailleraGameImpl kailleraGameImpl = this;
        synchronized (kailleraGameImpl) {
            if (!this.players.remove(user)) {
                log.warn((Object)(user + " quit game failed: not in " + this));
                throw new QuitGameException(EmuLang.getString("KailleraGameImpl.QuitGameErrorNotInGame"));
            }
            log.info((Object)(user + " quit: " + this));
            this.addEvent(new UserQuitGameEvent(this, user));
        }
        if (user.equals(this.owner)) {
            this.server.closeGame(this, user);
        } else {
            this.server.addEvent(new GameStatusChangedEvent(this.server, this));
        }
    }

    synchronized void close(KailleraUser user) throws CloseGameException {
        if (!user.equals(this.owner)) {
            log.warn((Object)(user + " close game denied: not the owner of " + this));
            throw new CloseGameException(EmuLang.getString("KailleraGameImpl.CloseGameErrorNotGameOwner"));
        }
        if (this.synched) {
            this.synched = false;
            for (PlayerActionQueue q : this.playerActionQueues) {
                q.setSynched(false);
            }
            log.info((Object)(this + ": game desynched: game closed!"));
        }
        for (KailleraUserImpl player : this.players) {
            player.setGame(null);
        }
        if (this.autoFireDetector != null) {
            this.autoFireDetector.stop();
        }
        this.players.clear();
    }

    @Override
    public synchronized void droppedPacket(KailleraUser user) {
        if (!this.synched) {
            return;
        }
        int playerNumber = user.getPlayerNumber();
        if (this.playerActionQueues != null && this.playerActionQueues[playerNumber - 1].isSynched()) {
            this.playerActionQueues[playerNumber - 1].setSynched(false);
            log.info((Object)(this + ": " + user + ": player desynched: dropped a packet!"));
            this.addEvent(new PlayerDesynchEvent(this, user, EmuLang.getString("KailleraGameImpl.DesynchDetectedDroppedPacket", user.getName())));
            if (this.getSynchedCount() < 2 && this.synched) {
                this.synched = false;
                for (PlayerActionQueue q : this.playerActionQueues) {
                    q.setSynched(false);
                }
                log.info((Object)(this + ": game desynched: less than 2 players synched!"));
            }
        }
    }

    @Override
    public void addData(KailleraUser user, int playerNumber, byte[] data) throws GameDataException {
        if (this.playerActionQueues == null) {
            return;
        }
        int bytesPerAction = data.length / this.actionsPerMessage;
        int timeoutCounter = 0;
        int arraySize = this.playerActionQueues.length * this.actionsPerMessage * bytesPerAction;
        if (!this.synched) {
            throw new GameDataException(EmuLang.getString("KailleraGameImpl.DesynchedWarning"), data, this.actionsPerMessage, playerNumber, this.playerActionQueues.length);
        }
        this.playerActionQueues[playerNumber - 1].addActions(data);
        if (this.autoFireDetector != null) {
            this.autoFireDetector.addData(playerNumber, data, bytesPerAction);
        }
        byte[] response = new byte[arraySize];
        for (int actionCounter = 0; actionCounter < this.actionsPerMessage; ++actionCounter) {
            block3: for (int playerCounter = 0; playerCounter < this.playerActionQueues.length; ++playerCounter) {
                while (this.synched) {
                    try {
                        this.playerActionQueues[playerCounter].getAction(playerNumber, response, actionCounter * (this.playerActionQueues.length * bytesPerAction) + playerCounter * bytesPerAction, bytesPerAction);
                        continue block3;
                    }
                    catch (PlayerTimeoutException e) {
                        e.setTimeoutNumber(++timeoutCounter);
                        this.handleTimeout(e);
                    }
                }
            }
        }
        if (!this.synched) {
            throw new GameDataException(EmuLang.getString("KailleraGameImpl.DesynchedWarning"), data, bytesPerAction, playerNumber, this.playerActionQueues.length);
        }
        ((KailleraUserImpl)user).addEvent(new GameDataEvent(this, response));
    }

    private synchronized void handleTimeout(PlayerTimeoutException e) {
        if (!this.synched) {
            return;
        }
        int playerNumber = e.getPlayerNumber();
        int timeoutNumber = e.getTimeoutNumber();
        PlayerActionQueue playerActionQueue = this.playerActionQueues[playerNumber - 1];
        if (!playerActionQueue.isSynched() || e.equals(playerActionQueue.getLastTimeout())) {
            return;
        }
        playerActionQueue.setLastTimeout(e);
        KailleraUserImpl player = e.getPlayer();
        if (timeoutNumber < this.desynchTimeouts) {
            log.info((Object)(this + ": " + player + ": Timeout #" + timeoutNumber));
            this.addEvent(new GameTimeoutEvent(this, player, timeoutNumber));
        } else {
            log.info((Object)(this + ": " + player + ": Timeout #" + timeoutNumber));
            playerActionQueue.setSynched(false);
            log.info((Object)(this + ": " + player + ": player desynched: Lagged!"));
            this.addEvent(new PlayerDesynchEvent(this, player, EmuLang.getString("KailleraGameImpl.DesynchDetectedPlayerLagged", player.getName())));
            if (this.getSynchedCount() < 2) {
                this.synched = false;
                for (PlayerActionQueue q : this.playerActionQueues) {
                    q.setSynched(false);
                }
                log.info((Object)(this + ": game desynched: less than 2 players synched!"));
            }
        }
    }
}

