/*
 * Decompiled with CFR 0.152.
 */
package org.emulinker.kaillera.controller.v086.action;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.emulinker.kaillera.controller.messaging.MessageFormatException;
import org.emulinker.kaillera.controller.v086.V086Controller;
import org.emulinker.kaillera.controller.v086.action.AdminCommandAction;
import org.emulinker.kaillera.controller.v086.action.FatalActionException;
import org.emulinker.kaillera.controller.v086.action.V086Action;
import org.emulinker.kaillera.controller.v086.action.V086ServerEventHandler;
import org.emulinker.kaillera.controller.v086.protocol.Chat;
import org.emulinker.kaillera.controller.v086.protocol.Chat_Notification;
import org.emulinker.kaillera.controller.v086.protocol.Chat_Request;
import org.emulinker.kaillera.controller.v086.protocol.InformationMessage;
import org.emulinker.kaillera.controller.v086.protocol.V086Message;
import org.emulinker.kaillera.model.event.ChatEvent;
import org.emulinker.kaillera.model.event.ServerEvent;
import org.emulinker.kaillera.model.exception.ActionException;
import org.emulinker.util.EmuLang;

public class ChatAction
implements V086Action,
V086ServerEventHandler {
    public static final String ADMIN_COMMAND_ESCAPE_STRING = "/";
    private static Log log = LogFactory.getLog(ChatAction.class);
    private static final String desc = "ChatAction";
    private static ChatAction singleton = new ChatAction();
    private int actionCount = 0;
    private int handledCount = 0;

    public static ChatAction getInstance() {
        return singleton;
    }

    private ChatAction() {
    }

    public int getActionPerformedCount() {
        return this.actionCount;
    }

    public int getHandledEventCount() {
        return this.handledCount;
    }

    public String toString() {
        return desc;
    }

    public void performAction(V086Message message, V086Controller.V086ClientHandler clientHandler) throws FatalActionException {
        if (!(message instanceof Chat_Request)) {
            throw new FatalActionException("Received incorrect instance of Chat: " + message);
        }
        if (((Chat)message).getMessage().startsWith(ADMIN_COMMAND_ESCAPE_STRING)) {
            try {
                AdminCommandAction.getInstance().performAction(message, clientHandler);
                return;
            }
            catch (FatalActionException e) {
                log.warn((Object)("Admin command failed, processing as chat: " + e.getMessage()));
            }
        }
        ++this.actionCount;
        try {
            clientHandler.getUser().chat(((Chat)message).getMessage());
        }
        catch (ActionException e) {
            log.info((Object)("Chat Denied: " + clientHandler.getUser() + ": " + ((Chat)message).getMessage()));
            try {
                clientHandler.send(new InformationMessage(clientHandler.getNextMessageNumber(), "server", EmuLang.getString("ChatAction.ChatDenied", e.getMessage())));
            }
            catch (MessageFormatException e2) {
                log.error((Object)("Failed to contruct InformationMessage message: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    public void handleEvent(ServerEvent event, V086Controller.V086ClientHandler clientHandler) {
        ++this.handledCount;
        try {
            ChatEvent chatEvent = (ChatEvent)event;
            clientHandler.send(new Chat_Notification(clientHandler.getNextMessageNumber(), chatEvent.getUser().getName(), chatEvent.getMessage()));
        }
        catch (MessageFormatException e) {
            log.error((Object)("Failed to contruct Chat_Notification message: " + e.getMessage()), (Throwable)e);
        }
    }
}

