/*
 * Decompiled with CFR 0.152.
 */
package org.emulinker.kaillera.controller.v086.action;

import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.emulinker.kaillera.controller.messaging.MessageFormatException;
import org.emulinker.kaillera.controller.v086.V086Controller;
import org.emulinker.kaillera.controller.v086.action.FatalActionException;
import org.emulinker.kaillera.controller.v086.action.V086Action;
import org.emulinker.kaillera.controller.v086.protocol.GameChat;
import org.emulinker.kaillera.controller.v086.protocol.V086Message;
import org.emulinker.kaillera.model.exception.ActionException;
import org.emulinker.kaillera.model.impl.KailleraGameImpl;
import org.emulinker.kaillera.model.impl.KailleraUserImpl;
import org.emulinker.util.EmuLang;

public class GameOwnerCommandAction
implements V086Action {
    public static final String COMMAND_HELP = "/help";
    public static final String COMMAND_DETECTAUTOFIRE = "/detectautofire";
    private static Log log = LogFactory.getLog(GameOwnerCommandAction.class);
    private static final String desc = "GameOwnerCommandAction";
    private static GameOwnerCommandAction singleton = new GameOwnerCommandAction();
    private int actionCount = 0;

    public static GameOwnerCommandAction getInstance() {
        return singleton;
    }

    private GameOwnerCommandAction() {
    }

    public int getActionPerformedCount() {
        return this.actionCount;
    }

    public String toString() {
        return desc;
    }

    public void performAction(V086Message message, V086Controller.V086ClientHandler clientHandler) throws FatalActionException {
        GameChat chatMessage = (GameChat)message;
        String chat = chatMessage.getMessage();
        KailleraUserImpl user = (KailleraUserImpl)clientHandler.getUser();
        KailleraGameImpl game = user.getGame();
        if (game == null) {
            throw new FatalActionException("GameOwner Command Failed: Not in a game: " + chat);
        }
        if (!user.equals(game.getOwner())) {
            log.warn((Object)("GameOwner Command Denied: Not game owner: " + game + ": " + user + ": " + chat));
            return;
        }
        try {
            if (chat.startsWith(COMMAND_HELP)) {
                this.processHelp(chat, game, user, clientHandler);
            } else if (chat.startsWith(COMMAND_DETECTAUTOFIRE)) {
                this.processDetectAutoFire(chat, game, user, clientHandler);
            } else {
                log.info((Object)("Unknown GameOwner Command: " + game + ": " + user + ": " + chat));
            }
        }
        catch (ActionException e) {
            log.info((Object)("GameOwner Command Failed: " + game + ": " + user + ": " + chat));
            game.announce(EmuLang.getString("GameOwnerCommandAction.CommandFailed", e.getMessage()));
        }
        catch (MessageFormatException e) {
            log.error((Object)("Failed to contruct message: " + e.getMessage()), (Throwable)e);
        }
    }

    private void processHelp(String message, KailleraGameImpl game, KailleraUserImpl admin, V086Controller.V086ClientHandler clientHandler) throws ActionException, MessageFormatException {
        game.announce(EmuLang.getString("GameOwnerCommandAction.AvailableCommands"));
        game.announce(EmuLang.getString("GameOwnerCommandAction.SetAutofireDetection"));
    }

    private void autoFireHelp(KailleraGameImpl game) {
        int cur = game.getAutoFireDetector().getSensitivity();
        game.announce(EmuLang.getString("GameOwnerCommandAction.HelpSensitivity"));
        game.announce(EmuLang.getString("GameOwnerCommandAction.HelpDisable"));
        game.announce(EmuLang.getString("GameOwnerCommandAction.HelpCurrentSensitivity", cur) + (cur == 0 ? EmuLang.getString("GameOwnerCommandAction.HelpDisabled") : ""));
    }

    private void processDetectAutoFire(String message, KailleraGameImpl game, KailleraUserImpl admin, V086Controller.V086ClientHandler clientHandler) throws ActionException, MessageFormatException {
        if (game.getStatus() != 0) {
            game.announce(EmuLang.getString("GameOwnerCommandAction.AutoFireChangeDeniedInGame"));
            return;
        }
        StringTokenizer st = new StringTokenizer(message, " ");
        if (st.countTokens() != 2) {
            this.autoFireHelp(game);
            return;
        }
        String command = st.nextToken();
        String sensitivityStr = st.nextToken();
        int sensitivity = -1;
        try {
            sensitivity = Integer.parseInt(sensitivityStr);
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        if (sensitivity > 5 || sensitivity < 0) {
            this.autoFireHelp(game);
            return;
        }
        game.getAutoFireDetector().setSensitivity(sensitivity);
        game.announce(EmuLang.getString("GameOwnerCommandAction.HelpCurrentSensitivity", sensitivity) + (sensitivity == 0 ? EmuLang.getString("GameOwnerCommandAction.HelpDisabled") : ""));
    }
}

