/*
 * Decompiled with CFR 0.152.
 */
package org.emulinker.kaillera.controller.v086.action;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.emulinker.kaillera.controller.messaging.MessageFormatException;
import org.emulinker.kaillera.controller.v086.V086Controller;
import org.emulinker.kaillera.controller.v086.action.FatalActionException;
import org.emulinker.kaillera.controller.v086.action.V086Action;
import org.emulinker.kaillera.controller.v086.action.V086ServerEventHandler;
import org.emulinker.kaillera.controller.v086.protocol.InformationMessage;
import org.emulinker.kaillera.controller.v086.protocol.ServerACK;
import org.emulinker.kaillera.controller.v086.protocol.UserInformation;
import org.emulinker.kaillera.controller.v086.protocol.UserJoined;
import org.emulinker.kaillera.controller.v086.protocol.V086Message;
import org.emulinker.kaillera.model.KailleraUser;
import org.emulinker.kaillera.model.event.ServerEvent;
import org.emulinker.kaillera.model.event.UserJoinedEvent;
import org.emulinker.kaillera.model.impl.KailleraUserImpl;

public class LoginAction
implements V086Action,
V086ServerEventHandler {
    private static Log log = LogFactory.getLog(LoginAction.class);
    private static final String desc = "LoginAction";
    private static LoginAction singleton = new LoginAction();
    private int actionCount = 0;
    private int handledCount = 0;

    public static LoginAction getInstance() {
        return singleton;
    }

    private LoginAction() {
    }

    public int getActionPerformedCount() {
        return this.actionCount;
    }

    public int getHandledEventCount() {
        return this.handledCount;
    }

    public String toString() {
        return desc;
    }

    public void performAction(V086Message message, V086Controller.V086ClientHandler clientHandler) throws FatalActionException {
        ++this.actionCount;
        UserInformation userInfo = (UserInformation)message;
        KailleraUser user = clientHandler.getUser();
        user.setName(userInfo.getUserName());
        user.setClientType(userInfo.getClientType());
        user.setSocketAddress(clientHandler.getRemoteSocketAddress());
        user.setConnectionType(userInfo.getConnectionType());
        clientHandler.startSpeedTest();
        try {
            clientHandler.send(new ServerACK(clientHandler.getNextMessageNumber()));
        }
        catch (MessageFormatException e) {
            log.error((Object)("Failed to contruct ServerACK message: " + e.getMessage()), (Throwable)e);
        }
    }

    public void handleEvent(ServerEvent event, V086Controller.V086ClientHandler clientHandler) {
        ++this.handledCount;
        UserJoinedEvent userJoinedEvent = (UserJoinedEvent)event;
        try {
            KailleraUserImpl user = (KailleraUserImpl)userJoinedEvent.getUser();
            clientHandler.send(new UserJoined(clientHandler.getNextMessageNumber(), user.getName(), user.getID(), user.getPing(), user.getConnectionType()));
            KailleraUserImpl thisUser = (KailleraUserImpl)clientHandler.getUser();
            if (thisUser.isEmuLinkerClient() && thisUser.getAccess() == 3 && !user.equals(thisUser)) {
                clientHandler.send(new InformationMessage(clientHandler.getNextMessageNumber(), "server", ":USERINFO=" + user.getID() + "," + user.getConnectSocketAddress().getAddress().getHostAddress() + "," + user.getAccessStr()));
            }
        }
        catch (MessageFormatException e) {
            log.error((Object)("Failed to contruct UserJoined_Notification message: " + e.getMessage()), (Throwable)e);
        }
    }
}

