/*
 * Decompiled with CFR 0.152.
 */
package org.emulinker.kaillera.controller.v086.protocol;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.emulinker.kaillera.controller.messaging.ByteBufferMessage;
import org.emulinker.kaillera.controller.messaging.MessageFormatException;
import org.emulinker.kaillera.controller.messaging.ParseException;
import org.emulinker.kaillera.controller.v086.protocol.V086Message;
import org.emulinker.kaillera.model.KailleraUser;
import org.emulinker.util.EmuUtil;
import org.emulinker.util.UnsignedUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlayerInformation
extends V086Message {
    public static final byte ID = 13;
    public static final String DESC = "Player Information";
    private List<Player> players;

    public PlayerInformation(int messageNumber, List<Player> players) throws MessageFormatException {
        super(messageNumber);
        this.players = players;
    }

    @Override
    public byte getID() {
        return 13;
    }

    @Override
    public String getDescription() {
        return DESC;
    }

    public int getNumPlayers() {
        return this.players.size();
    }

    public List<Player> getPlayers() {
        return this.players;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getInfoString() + "[players=" + this.players.size() + "]");
        if (!this.players.isEmpty()) {
            sb.append(EmuUtil.LB);
        }
        for (Player p : this.players) {
            sb.append("\t" + p);
            sb.append(EmuUtil.LB);
        }
        return sb.toString();
    }

    @Override
    public int getBodyLength() {
        int len = 5;
        for (Player p : this.players) {
            len += p.getLength();
        }
        return len;
    }

    @Override
    public void writeBodyTo(ByteBuffer buffer) {
        buffer.put((byte)0);
        buffer.putInt(this.players.size());
        for (Player p : this.players) {
            p.writeTo(buffer);
        }
    }

    public static PlayerInformation parse(int messageNumber, ByteBuffer buffer) throws ParseException, MessageFormatException {
        if (buffer.remaining() < 14) {
            throw new ParseException("Failed byte count validation!");
        }
        byte b = buffer.get();
        if (b != 0) {
            throw new MessageFormatException("Invalid Player Information format: byte 0 = " + EmuUtil.byteToHex(b));
        }
        int numPlayers = buffer.getInt();
        int minLen = numPlayers * 9;
        if (buffer.remaining() < minLen) {
            throw new ParseException("Failed byte count validation!");
        }
        ArrayList<Player> players = new ArrayList<Player>(numPlayers);
        for (int j = 0; j < numPlayers; ++j) {
            if (buffer.remaining() < 9) {
                throw new ParseException("Failed byte count validation!");
            }
            String userName = EmuUtil.readString(buffer, 0, charset);
            if (buffer.remaining() < 7) {
                throw new ParseException("Failed byte count validation!");
            }
            long ping = UnsignedUtil.getUnsignedInt(buffer);
            int userID = UnsignedUtil.getUnsignedShort(buffer);
            byte connectionType = buffer.get();
            players.add(new Player(userName, ping, userID, connectionType));
        }
        return new PlayerInformation(messageNumber, players);
    }

    public static class Player {
        private String userName;
        private long ping;
        private int userID;
        private byte connectionType;

        public Player(String userName, long ping, int userID, byte connectionType) throws MessageFormatException {
            if (userName.length() == 0) {
                throw new MessageFormatException("Invalid Player Information format: userName.length == 0, (userID = " + userID + ")");
            }
            if (ping < 0L || ping > 2048L) {
                throw new MessageFormatException("Invalid Player Information format: ping out of acceptable range: " + ping);
            }
            if (userID < 0 || userID > 65535) {
                throw new MessageFormatException("Invalid Player Information format: userID out of acceptable range: " + userID);
            }
            if (connectionType < 1 || connectionType > 6) {
                throw new MessageFormatException("Invalid Player Information format: connectionType out of acceptable range: " + connectionType);
            }
            this.userName = userName;
            this.ping = ping;
            this.userID = userID;
            this.connectionType = connectionType;
        }

        public String getUserName() {
            return this.userName;
        }

        public long getPing() {
            return this.ping;
        }

        public int getUserID() {
            return this.userID;
        }

        public byte getConnectionType() {
            return this.connectionType;
        }

        public String toString() {
            return "[userName=" + this.userName + " ping=" + this.ping + " userID=" + this.userID + " connectionType=" + KailleraUser.CONNECTION_TYPE_NAMES[this.connectionType] + "]";
        }

        public int getLength() {
            return this.userName.length() + 8;
        }

        public void writeTo(ByteBuffer buffer) {
            EmuUtil.writeString(buffer, this.userName, 0, ByteBufferMessage.charset);
            UnsignedUtil.putUnsignedInt(buffer, this.ping);
            UnsignedUtil.putUnsignedShort(buffer, this.userID);
            buffer.put(this.connectionType);
        }
    }
}

