/*
 * Decompiled with CFR 0.152.
 */
package org.emulinker.kaillera.model.impl;

import java.util.Arrays;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.emulinker.kaillera.model.KailleraGame;
import org.emulinker.kaillera.model.KailleraUser;
import org.emulinker.kaillera.model.impl.AutoFireDetector;
import org.emulinker.kaillera.model.impl.KailleraGameImpl;
import org.emulinker.util.EmuLang;
import org.emulinker.util.EmuUtil;

public class AutoFireScanner2
implements AutoFireDetector {
    protected static Log log = LogFactory.getLog(AutoFireScanner2.class);
    private static int[][] SENSITIVITY_TABLE = new int[][]{{0, 0}, {2, 13}, {3, 11}, {4, 9}, {5, 7}, {6, 5}};
    protected static ExecutorService executor = Executors.newCachedThreadPool();
    protected KailleraGame game;
    protected int sensitivity;
    protected int maxDelay;
    protected int minReps;
    protected ScanningJob[] scanningJobs;

    public AutoFireScanner2(KailleraGame game, int sensitivity) {
        this.game = game;
        this.setSensitivity(sensitivity);
    }

    public int getSensitivity() {
        return this.sensitivity;
    }

    public void setSensitivity(int sensitivity) {
        if (sensitivity < 0 || sensitivity > 5) {
            this.sensitivity = 0;
        } else {
            this.sensitivity = sensitivity;
            this.maxDelay = SENSITIVITY_TABLE[sensitivity][0];
            this.minReps = SENSITIVITY_TABLE[sensitivity][1];
        }
    }

    public void start(int numPlayers) {
        if (this.sensitivity <= 0) {
            return;
        }
        this.scanningJobs = new ScanningJob[numPlayers];
    }

    public void addPlayer(KailleraUser player, int playerNumber) {
        if (this.sensitivity <= 0 || this.scanningJobs == null) {
            return;
        }
        this.scanningJobs[playerNumber - 1] = new ScanningJob(player, playerNumber);
    }

    public void stop(int playerNumber) {
        if (this.sensitivity <= 0 || this.scanningJobs == null) {
            return;
        }
        this.scanningJobs[playerNumber - 1].stop();
    }

    public void stop() {
        if (this.sensitivity <= 0 || this.scanningJobs == null) {
            return;
        }
        for (int i = 0; i < this.scanningJobs.length; ++i) {
            this.scanningJobs[i].stop();
        }
    }

    public void addData(int playerNumber, byte[] data, int bytesPerAction) {
        if (this.sensitivity <= 0 || this.scanningJobs == null) {
            return;
        }
        this.scanningJobs[playerNumber - 1].addData(data, bytesPerAction);
    }

    protected class ScanningJob
    implements Runnable {
        private KailleraUser user;
        private int playerNumber;
        private int bytesPerAction = -1;
        private int sizeLimit;
        private int bufferSize = 5;
        private int size = 0;
        private byte[][] buffer;
        private int head = 0;
        private int tail = 0;
        private int pos = 0;
        private boolean running = false;
        private boolean stopFlag = false;

        protected ScanningJob(KailleraUser user, int playerNumber) {
            this.user = user;
            this.playerNumber = playerNumber;
            this.sizeLimit = (AutoFireScanner2.this.maxDelay + 1) * AutoFireScanner2.this.minReps * 5;
            this.buffer = new byte[this.bufferSize][this.sizeLimit];
        }

        protected synchronized void addData(byte[] data, int bytesPerAction) {
            if (this.pos + data.length >= this.sizeLimit) {
                int firstSize = this.sizeLimit - this.pos;
                System.arraycopy(data, 0, this.buffer[this.tail], this.pos, firstSize);
                this.tail = (this.tail + 1) % this.bufferSize;
                System.arraycopy(data, firstSize, this.buffer[this.tail], 0, data.length - firstSize);
                this.pos = data.length - firstSize;
                ++this.size;
                if (this.bytesPerAction <= 0) {
                    this.bytesPerAction = bytesPerAction;
                }
                if (!this.running) {
                    executor.submit(this);
                }
            } else {
                System.arraycopy(data, 0, this.buffer[this.tail], this.pos, data.length);
                this.pos += data.length;
            }
        }

        protected void stop() {
            this.stopFlag = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            ScanningJob scanningJob = this;
            synchronized (scanningJob) {
                this.running = true;
            }
            try {
                block20: while (this.size > 0 && !this.stopFlag) {
                    Object data = null;
                    ScanningJob scanningJob2 = this;
                    synchronized (scanningJob2) {
                        data = this.buffer[this.head];
                        this.head = (this.head + 1) % this.bufferSize;
                        --this.size;
                    }
                    int actionCount = ((Object)data).length / this.bytesPerAction;
                    byte[] thisAction = new byte[this.bytesPerAction];
                    byte[] lastAction = new byte[this.bytesPerAction];
                    byte[] actionA = new byte[this.bytesPerAction];
                    int aPos = 0;
                    int aCount = 0;
                    int aSequence = 0;
                    int lastASequence = 0;
                    int aSequenceCount = 0;
                    byte[] actionB = new byte[this.bytesPerAction];
                    int bPos = 0;
                    int bCount = 0;
                    int bSequence = 0;
                    int lastBSequence = 0;
                    int bSequenceCount = 0;
                    for (int i = 0; i < actionCount; ++i) {
                        System.arraycopy(data, i * this.bytesPerAction, thisAction, 0, this.bytesPerAction);
                        if (aCount == 0) {
                            System.arraycopy(thisAction, 0, actionA, 0, this.bytesPerAction);
                            aPos = i;
                            aCount = 1;
                            aSequence = 1;
                        } else if (Arrays.equals(thisAction, actionA)) {
                            ++aCount;
                            if (Arrays.equals(thisAction, lastAction)) {
                                ++aSequence;
                            } else {
                                aSequenceCount = lastASequence == aSequence && aSequence <= AutoFireScanner2.this.maxDelay ? ++aSequenceCount : 0;
                                lastASequence = aSequence;
                                aSequence = 1;
                            }
                        } else if (bCount == 0) {
                            System.arraycopy(thisAction, 0, actionB, 0, this.bytesPerAction);
                            bPos = i;
                            bCount = 1;
                            bSequence = 1;
                        } else if (Arrays.equals(thisAction, actionB)) {
                            ++bCount;
                            if (Arrays.equals(thisAction, lastAction)) {
                                ++bSequence;
                            } else {
                                bSequenceCount = lastBSequence == bSequence && bSequence <= AutoFireScanner2.this.maxDelay ? ++bSequenceCount : 0;
                                lastBSequence = bSequence;
                                bSequence = 1;
                            }
                        } else {
                            actionA = lastAction;
                            aCount = 1;
                            aSequence = 1;
                            aSequenceCount = 0;
                            actionB = thisAction;
                            bCount = 1;
                            bSequence = 0;
                            bSequenceCount = 0;
                        }
                        System.arraycopy(thisAction, 0, lastAction, 0, this.bytesPerAction);
                        if (aSequenceCount < AutoFireScanner2.this.minReps || bSequenceCount < AutoFireScanner2.this.minReps || this.stopFlag) continue;
                        KailleraGameImpl gameImpl = (KailleraGameImpl)AutoFireScanner2.this.game;
                        gameImpl.announce(EmuLang.getString("AutoFireScanner2.AutoFireDetected", this.user.getName()));
                        log.info((Object)("AUTOUSERDUMP\t" + EmuUtil.DATE_FORMAT.format(gameImpl.getStartDate()) + "\t" + (aSequence < bSequence ? aSequence : bSequence) + "\t" + AutoFireScanner2.this.game.getID() + "\t" + AutoFireScanner2.this.game.getRomName() + "\t" + this.user.getName() + "\t" + this.user.getSocketAddress().getAddress().getHostAddress()));
                        continue block20;
                    }
                }
            }
            catch (Exception e) {
                log.error((Object)("AutoFireScanner2 thread for " + this.user + " caught exception!"), (Throwable)e);
            }
            finally {
                ScanningJob scanningJob3 = this;
                synchronized (scanningJob3) {
                    this.running = false;
                }
            }
        }
    }
}

