/*
 * Decompiled with CFR 0.152.
 */
package org.emulinker.kaillera.pico;

import java.lang.reflect.InvocationTargetException;
import java.util.Date;
import java.util.NoSuchElementException;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.emulinker.net.BindException;
import org.emulinker.release.ReleaseInfo;
import org.emulinker.util.PicoUtil;
import org.picocontainer.PicoContainer;
import org.picocontainer.defaults.PicoInvocationTargetInitializationException;

public class PicoStarter {
    private static Log log = LogFactory.getLog(PicoStarter.class);
    public static final String CONFIG_FILE = "components.xml";
    private PicoContainer container;

    public static void main(String[] args) {
        try {
            try {
                new PicoStarter();
            }
            catch (InvocationTargetException ite) {
                throw ite.getCause();
            }
            catch (PicoInvocationTargetInitializationException pitie) {
                throw pitie.getCause();
            }
        }
        catch (NoSuchElementException e) {
            log.fatal((Object)"EmuLinker server failed to start!");
            log.fatal((Object)e);
            System.out.println("Failed to start! A required propery is missing: " + e.getMessage());
            System.exit(1);
        }
        catch (ConfigurationException e) {
            log.fatal((Object)"EmuLinker server failed to start!");
            log.fatal((Object)e);
            System.out.println("Failed to start! A configuration parameter is incorrect: " + e.getMessage());
            System.exit(1);
        }
        catch (BindException e) {
            log.fatal((Object)"EmuLinker server failed to start!");
            log.fatal((Object)e);
            System.out.println("Failed to start! A server is already running: " + e.getMessage());
            System.exit(1);
        }
        catch (Throwable e) {
            log.fatal((Object)"EmuLinker server failed to start!");
            log.fatal((Object)e);
            System.err.println("Failed to start! Caught unexpected error, stacktrace follows: " + e.getMessage());
            e.printStackTrace(System.err);
            System.exit(1);
        }
    }

    private PicoStarter() throws Exception {
        System.out.println("EmuLinker server Starting...");
        log.info((Object)"Loading and starting components from components.xml");
        this.container = PicoUtil.buildContainer(null, "EmuLinker", "/components.xml");
        ReleaseInfo releaseInfo = (ReleaseInfo)this.container.getComponentInstanceOfType(ReleaseInfo.class);
        System.out.println(releaseInfo.getWelcome());
        System.out.println("EmuLinker server is running @ " + new Date());
    }

    public PicoContainer getContainer() {
        return this.container;
    }
}

