/*
 * Decompiled with CFR 0.152.
 */
package org.emulinker.net;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.emulinker.net.UDPServer;
import org.emulinker.util.EmuUtil;

public abstract class PrivateUDPServer
extends UDPServer {
    private static Log log = LogFactory.getLog(PrivateUDPServer.class);
    private InetAddress remoteAddress;
    private InetSocketAddress remoteSocketAddress;

    public PrivateUDPServer(boolean shutdownOnExit, InetAddress remoteAddress) {
        super(shutdownOnExit);
        this.remoteAddress = remoteAddress;
    }

    public InetAddress getRemoteInetAddress() {
        return this.remoteAddress;
    }

    public InetSocketAddress getRemoteSocketAddress() {
        return this.remoteSocketAddress;
    }

    protected void handleReceived(ByteBuffer buffer, InetSocketAddress inboundSocketAddress) {
        if (this.remoteSocketAddress == null) {
            this.remoteSocketAddress = inboundSocketAddress;
        } else if (!inboundSocketAddress.equals(this.remoteSocketAddress)) {
            log.warn((Object)("Rejecting packet received from wrong address: " + EmuUtil.formatSocketAddress(inboundSocketAddress) + " != " + EmuUtil.formatSocketAddress(this.remoteSocketAddress)));
            return;
        }
        this.handleReceived(buffer);
    }

    protected abstract void handleReceived(ByteBuffer var1);

    protected void send(ByteBuffer buffer) {
        super.send(buffer, this.remoteSocketAddress);
    }
}

