/*
 * Decompiled with CFR 0.152.
 */
package org.emulinker.util;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.emulinker.util.CircularBlockingByteQueue;

public class GameDataQueue {
    private static Log log = LogFactory.getLog(GameDataQueue.class);
    private int gameID;
    private int numPlayers;
    private PlayerDataQueue[] playerQueues;
    private int timeoutMillis;
    private int retries;
    private boolean gameDesynched = false;

    public GameDataQueue(int gameID, int numPlayers, int timeoutMillis, int retries) {
        this.gameID = gameID;
        this.numPlayers = numPlayers;
        this.timeoutMillis = timeoutMillis;
        this.retries = retries;
        this.playerQueues = new PlayerDataQueue[numPlayers];
        for (int i = 0; i < this.playerQueues.length; ++i) {
            this.playerQueues[i] = new PlayerDataQueue(i + 1);
        }
    }

    public int getGameID() {
        return this.gameID;
    }

    public int getNumPlayers() {
        return this.numPlayers;
    }

    public int getTimeoutMillis() {
        return this.timeoutMillis;
    }

    public int getRetries() {
        return this.retries;
    }

    public void setGameDesynched() {
        this.gameDesynched = true;
    }

    public void addData(int playerNumber, byte[] data) {
        for (int i = 0; i < data.length; ++i) {
            this.addData(playerNumber, data[i]);
        }
    }

    public void addData(int playerNumber, byte data) {
        for (int i = 0; i < this.numPlayers; ++i) {
            this.playerQueues[i].addData(playerNumber, data);
        }
    }

    public byte[] getData(int playerNumber, int byteCount, int bytesPerAction) throws PlayerTimeoutException, DesynchException {
        return this.playerQueues[playerNumber - 1].getData(byteCount, bytesPerAction);
    }

    public static class DesynchException
    extends Exception {
        private int playerNumber;

        private DesynchException(String msg, int playerNumber, TimeoutException e) {
            super(msg, e);
            this.playerNumber = playerNumber;
        }

        public int getPlayerNumber() {
            return this.playerNumber;
        }
    }

    public static class PlayerTimeoutException
    extends Exception {
        private int playerNumber;
        private int timeoutNumber;

        private PlayerTimeoutException(int playerNumber, int timeoutNumber, TimeoutException e) {
            super(e);
            this.playerNumber = playerNumber;
            this.timeoutNumber = timeoutNumber;
        }

        public int getPlayerNumber() {
            return this.playerNumber;
        }

        public int getTimeoutNumber() {
            return this.timeoutNumber;
        }
    }

    private class PlayerDataQueue {
        private int thisPlayerNumber;
        private CircularBlockingByteQueue[] queues;
        private int lastI = 0;
        private int lastJ = 0;
        private byte[] lastData = null;
        private int timeoutCounter = 0;

        private PlayerDataQueue(int playerNumber) {
            this.thisPlayerNumber = playerNumber;
            this.queues = new CircularBlockingByteQueue[GameDataQueue.this.numPlayers];
            for (int i = 0; i < this.queues.length; ++i) {
                this.queues[i] = new CircularBlockingByteQueue(GameDataQueue.this.numPlayers * 6 * 4);
            }
        }

        private void addData(int playerNumber, byte data) {
            this.queues[playerNumber - 1].put(data);
        }

        private byte[] getData(int byteCount, int bytesPerAction) throws PlayerTimeoutException, DesynchException {
            byte[] data = null;
            if (this.lastData != null) {
                data = this.lastData;
                this.lastData = null;
            } else {
                data = new byte[byteCount * GameDataQueue.this.numPlayers];
            }
            for (int i = this.lastI; i < byteCount / bytesPerAction * GameDataQueue.this.numPlayers; ++i) {
                for (int j = this.lastJ; j < bytesPerAction; ++j) {
                    try {
                        data[i * bytesPerAction + j] = this.queues[i % GameDataQueue.this.numPlayers].get(GameDataQueue.this.timeoutMillis, TimeUnit.MILLISECONDS);
                        continue;
                    }
                    catch (TimeoutException e) {
                        this.lastI = i;
                        this.lastJ = j;
                        this.lastData = data;
                        if (++this.timeoutCounter > GameDataQueue.this.retries) {
                            throw new DesynchException("Player " + (i % GameDataQueue.this.numPlayers + 1) + " is lagged!", i % GameDataQueue.this.numPlayers + 1, e);
                        }
                        throw new PlayerTimeoutException(i % GameDataQueue.this.numPlayers + 1, this.timeoutCounter, e);
                    }
                }
            }
            this.lastJ = 0;
            this.lastI = 0;
            this.lastData = null;
            this.timeoutCounter = 0;
            return data;
        }
    }
}

