/*
 * Decompiled with CFR 0.152.
 */
package org.emulinker.util;

import java.util.Arrays;
import java.util.HashMap;
import org.emulinker.util.GameDataCache;

public class ServerGameDataCache
implements GameDataCache {
    protected byte[][] array;
    protected HashMap<Integer, Integer> map;
    protected int head = 0;
    protected int tail = 0;
    protected int size = 0;

    public ServerGameDataCache(int size) {
        this.array = new byte[size][];
        this.map = new HashMap(size, 0.05f);
    }

    public String toString() {
        return "ServerGameDataCache[size=" + this.size + " head=" + this.head + " tail=" + this.tail + "]";
    }

    public boolean isEmpty() {
        return this.head == this.tail;
    }

    public int size() {
        return this.size;
    }

    public boolean contains(byte[] data) {
        return this.indexOf(data) >= 0;
    }

    public int indexOf(byte[] data) {
        Integer i = this.map.get(Arrays.hashCode(data));
        return i == null ? -1 : this.unconvert(i);
    }

    public byte[] get(int index) {
        this.rangeCheck(index);
        return this.array[this.convert(index)];
    }

    public byte[] set(int index, byte[] data) {
        this.rangeCheck(index);
        int convertedIndex = this.convert(index);
        byte[] oldValue = this.array[convertedIndex];
        this.array[convertedIndex] = data;
        this.map.put(Arrays.hashCode(data), convertedIndex);
        return oldValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] remove(int index) {
        byte[] byArray;
        block13: {
            int pos;
            block12: {
                this.rangeCheck(index);
                pos = this.convert(index);
                try {
                    this.map.remove(Arrays.hashCode(this.array[pos]));
                    byArray = this.array[pos];
                    Object var5_4 = null;
                    this.array[pos] = null;
                    if (pos != this.head) break block12;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    this.array[pos] = null;
                    if (pos == this.head) {
                        this.head = (this.head + 1) % this.array.length;
                    } else if (pos == this.tail) {
                        this.tail = (this.tail - 1 + this.array.length) % this.array.length;
                    } else if (pos > this.head && pos > this.tail) {
                        System.arraycopy(this.array, this.head, this.array, this.head + 1, pos - this.head);
                        this.head = (this.head + 1) % this.array.length;
                    } else {
                        System.arraycopy(this.array, pos + 1, this.array, pos, this.tail - pos - 1);
                        this.tail = (this.tail - 1 + this.array.length) % this.array.length;
                    }
                    --this.size;
                    throw throwable;
                }
                this.head = (this.head + 1) % this.array.length;
                break block13;
            }
            if (pos == this.tail) {
                this.tail = (this.tail - 1 + this.array.length) % this.array.length;
            } else if (pos > this.head && pos > this.tail) {
                System.arraycopy(this.array, this.head, this.array, this.head + 1, pos - this.head);
                this.head = (this.head + 1) % this.array.length;
            } else {
                System.arraycopy(this.array, pos + 1, this.array, pos, this.tail - pos - 1);
                this.tail = (this.tail - 1 + this.array.length) % this.array.length;
            }
        }
        --this.size;
        return byArray;
    }

    public void clear() {
        for (int i = 0; i < this.size; ++i) {
            this.array[this.convert((int)i)] = null;
        }
        this.size = 0;
        this.tail = 0;
        this.head = 0;
        this.map.clear();
    }

    public int add(byte[] data) {
        if (this.size == this.array.length) {
            this.remove(0);
        }
        int pos = this.tail;
        this.array[this.tail] = data;
        this.map.put(Arrays.hashCode(data), this.tail);
        this.tail = (this.tail + 1) % this.array.length;
        ++this.size;
        return this.unconvert(pos);
    }

    protected int convert(int index) {
        return (index + this.head) % this.array.length;
    }

    protected int unconvert(int index) {
        if (index >= this.head) {
            return index - this.head;
        }
        return this.array.length - this.head + index;
    }

    protected void rangeCheck(int index) {
        if (index >= this.size || index < 0) {
            throw new IndexOutOfBoundsException("index=" + index + ", size=" + this.size);
        }
    }
}

