/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import org.apache.commons.collections.map.LinkedMap;
import org.apache.commons.configuration.AbstractConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationKey;
import org.apache.commons.configuration.PropertyConverter;
import org.apache.commons.lang.StringUtils;

public class HierarchicalConfiguration
extends AbstractConfiguration {
    private static final String NEW_KEY = "newKey";
    private Node root = new Node();

    public Node getRoot() {
        return this.root;
    }

    public void setRoot(Node node) {
        if (node == null) {
            throw new IllegalArgumentException("Root node must not be null!");
        }
        this.root = node;
    }

    public Object getProperty(String key) {
        List nodes = this.fetchNodeList(key);
        if (nodes.size() == 0) {
            return null;
        }
        ArrayList<Object> list = new ArrayList<Object>();
        Iterator it = nodes.iterator();
        while (it.hasNext()) {
            Node node = (Node)it.next();
            if (node.getValue() == null) continue;
            list.add(node.getValue());
        }
        if (list.size() < 1) {
            return null;
        }
        return list.size() == 1 ? list.get(0) : list;
    }

    protected void addPropertyDirect(String key, Object obj) {
        ConfigurationKey.KeyIterator it = new ConfigurationKey(key).iterator();
        Node parent = this.fetchAddNode(it, this.getRoot());
        Node child = this.createNode(it.currentKey(true));
        child.setValue(obj);
        parent.addChild(child);
    }

    public void addNodes(String key, Collection nodes) {
        Node parent;
        if (nodes == null || nodes.isEmpty()) {
            return;
        }
        if (StringUtils.isEmpty((String)key)) {
            parent = this.getRoot();
        } else {
            ConfigurationKey.KeyIterator kit = new ConfigurationKey(key).iterator();
            parent = this.fetchAddNode(kit, this.getRoot());
            ConfigurationKey keyNew = new ConfigurationKey(kit.currentKey(true));
            keyNew.append(NEW_KEY);
            parent = this.fetchAddNode(keyNew.iterator(), parent);
        }
        Iterator it = nodes.iterator();
        while (it.hasNext()) {
            parent.addChild((Node)it.next());
        }
    }

    public boolean isEmpty() {
        return !this.nodeDefined(this.getRoot());
    }

    public Configuration subset(String prefix) {
        List nodes = this.fetchNodeList(prefix);
        if (nodes.isEmpty()) {
            return new HierarchicalConfiguration();
        }
        HierarchicalConfiguration result = new HierarchicalConfiguration();
        CloneVisitor visitor = new CloneVisitor();
        Iterator it = nodes.iterator();
        while (it.hasNext()) {
            Node nd = (Node)it.next();
            nd.visit(visitor, null);
            List children = visitor.getClone().getChildren();
            if (children.size() <= 0) continue;
            for (int i = 0; i < children.size(); ++i) {
                result.getRoot().addChild((Node)children.get(i));
            }
        }
        return result.isEmpty() ? new HierarchicalConfiguration() : result;
    }

    public boolean containsKey(String key) {
        return this.getProperty(key) != null;
    }

    public void setProperty(String key, Object value) {
        Iterator itNodes = this.fetchNodeList(key).iterator();
        Iterator itValues = PropertyConverter.toIterator(value, AbstractConfiguration.getDelimiter());
        while (itNodes.hasNext() && itValues.hasNext()) {
            ((Node)itNodes.next()).setValue(itValues.next());
        }
        while (itValues.hasNext()) {
            this.addPropertyDirect(key, itValues.next());
        }
        while (itNodes.hasNext()) {
            this.clearNode((Node)itNodes.next());
        }
    }

    public void clearTree(String key) {
        List nodes = this.fetchNodeList(key);
        Iterator it = nodes.iterator();
        while (it.hasNext()) {
            this.removeNode((Node)it.next());
        }
    }

    public void clearProperty(String key) {
        List nodes = this.fetchNodeList(key);
        Iterator it = nodes.iterator();
        while (it.hasNext()) {
            this.clearNode((Node)it.next());
        }
    }

    public Iterator getKeys() {
        DefinedKeysVisitor visitor = new DefinedKeysVisitor();
        this.getRoot().visit(visitor, new ConfigurationKey());
        return visitor.getKeyList().iterator();
    }

    public Iterator getKeys(String prefix) {
        DefinedKeysVisitor visitor = new DefinedKeysVisitor(prefix);
        List nodes = this.fetchNodeList(prefix);
        ConfigurationKey key = new ConfigurationKey();
        Iterator itNodes = nodes.iterator();
        while (itNodes.hasNext()) {
            Node node = (Node)itNodes.next();
            Iterator it = node.getChildren().iterator();
            while (it.hasNext()) {
                ((Node)it.next()).visit(visitor, key);
            }
        }
        return visitor.getKeyList().iterator();
    }

    public int getMaxIndex(String key) {
        return this.fetchNodeList(key).size() - 1;
    }

    protected List fetchNodeList(String key) {
        LinkedList nodes = new LinkedList();
        this.findPropertyNodes(new ConfigurationKey(key).iterator(), this.getRoot(), nodes);
        return nodes;
    }

    protected void findPropertyNodes(ConfigurationKey.KeyIterator keyPart, Node node, Collection data) {
        if (!keyPart.hasNext()) {
            data.add(node);
        } else {
            String key = keyPart.nextKey(true);
            List children = node.getChildren(key);
            if (keyPart.hasIndex()) {
                if (keyPart.getIndex() < children.size() && keyPart.getIndex() >= 0) {
                    this.findPropertyNodes((ConfigurationKey.KeyIterator)keyPart.clone(), (Node)children.get(keyPart.getIndex()), data);
                }
            } else {
                Iterator it = children.iterator();
                while (it.hasNext()) {
                    this.findPropertyNodes((ConfigurationKey.KeyIterator)keyPart.clone(), (Node)it.next(), data);
                }
            }
        }
    }

    protected boolean nodeDefined(Node node) {
        DefinedVisitor visitor = new DefinedVisitor();
        node.visit(visitor, null);
        return visitor.isDefined();
    }

    protected void removeNode(Node node) {
        Node parent = node.getParent();
        if (parent != null) {
            parent.remove(node);
            if (!this.nodeDefined(parent)) {
                this.removeNode(parent);
            }
        }
    }

    protected void clearNode(Node node) {
        node.setValue(null);
        if (!this.nodeDefined(node)) {
            this.removeNode(node);
        }
    }

    protected Node fetchAddNode(ConfigurationKey.KeyIterator keyIt, Node startNode) {
        if (!keyIt.hasNext()) {
            throw new IllegalArgumentException("Key must be defined!");
        }
        return this.createAddPath(keyIt, this.findLastPathNode(keyIt, startNode));
    }

    protected Node findLastPathNode(ConfigurationKey.KeyIterator keyIt, Node node) {
        String keyPart = keyIt.nextKey(true);
        if (keyIt.hasNext()) {
            int idx;
            List list = node.getChildren(keyPart);
            int n = idx = keyIt.hasIndex() ? keyIt.getIndex() : list.size() - 1;
            if (idx < 0 || idx >= list.size()) {
                return node;
            }
            return this.findLastPathNode(keyIt, (Node)list.get(idx));
        }
        return node;
    }

    protected Node createAddPath(ConfigurationKey.KeyIterator keyIt, Node root) {
        if (keyIt.hasNext()) {
            Node child = this.createNode(keyIt.currentKey(true));
            root.addChild(child);
            keyIt.next();
            return this.createAddPath(keyIt, child);
        }
        return root;
    }

    protected Node createNode(String name) {
        return new Node(name);
    }

    protected static abstract class BuilderVisitor
    extends NodeVisitor {
        protected BuilderVisitor() {
        }

        public void visitBeforeChildren(Node node, ConfigurationKey key) {
            Iterator children = node.getChildren().iterator();
            Node sibling1 = null;
            Node nd = null;
            while (children.hasNext()) {
                do {
                    sibling1 = nd;
                } while ((nd = (Node)children.next()).getReference() != null && children.hasNext());
                if (nd.getReference() != null) continue;
                LinkedList<Node> newNodes = new LinkedList<Node>();
                newNodes.add(nd);
                while (children.hasNext() && (nd = (Node)children.next()).getReference() == null) {
                    newNodes.add(nd);
                }
                Node sibling2 = nd.getReference() == null ? null : nd;
                Iterator it = newNodes.iterator();
                while (it.hasNext()) {
                    Object ref;
                    Node insertNode = (Node)it.next();
                    if (insertNode.getReference() != null || (ref = this.insert(insertNode, node, sibling1, sibling2)) == null) continue;
                    insertNode.setReference(ref);
                }
            }
        }

        protected abstract Object insert(Node var1, Node var2, Node var3, Node var4);
    }

    static class CloneVisitor
    extends NodeVisitor {
        private Stack copyStack = new Stack();
        private Node result;

        public void visitAfterChildren(Node node, ConfigurationKey key) {
            this.copyStack.pop();
            if (this.copyStack.isEmpty()) {
                this.result = node;
            }
        }

        public void visitBeforeChildren(Node node, ConfigurationKey key) {
            Node copy = (Node)node.clone();
            copy.removeChildren();
            if (!this.copyStack.isEmpty()) {
                ((Node)this.copyStack.peek()).addChild(copy);
            }
            this.copyStack.push(copy);
        }

        public Node getClone() {
            return this.result;
        }
    }

    static class DefinedKeysVisitor
    extends NodeVisitor {
        private Set keyList = new HashSet();
        private String prefix;

        public DefinedKeysVisitor() {
        }

        public DefinedKeysVisitor(String prefix) {
            this();
            this.prefix = prefix;
        }

        public Set getKeyList() {
            return this.keyList;
        }

        public void visitBeforeChildren(Node node, ConfigurationKey key) {
            if (node.getValue() != null && key != null) {
                this.addKey(key);
            }
        }

        protected void addKey(ConfigurationKey key) {
            if (this.prefix == null) {
                this.keyList.add(key.toString());
            } else {
                StringBuffer buf = new StringBuffer(this.prefix);
                if (!key.isAttributeKey()) {
                    buf.append('.');
                }
                buf.append(key);
                this.keyList.add(buf.toString());
            }
        }
    }

    static class DefinedVisitor
    extends NodeVisitor {
        private boolean defined;

        DefinedVisitor() {
        }

        public boolean terminate() {
            return this.isDefined();
        }

        public void visitBeforeChildren(Node node, ConfigurationKey key) {
            this.defined = node.getValue() != null;
        }

        public boolean isDefined() {
            return this.defined;
        }
    }

    public static class NodeVisitor {
        public void visitBeforeChildren(Node node, ConfigurationKey key) {
        }

        public void visitAfterChildren(Node node, ConfigurationKey key) {
        }

        public boolean terminate() {
            return false;
        }
    }

    public static class Node
    implements Serializable,
    Cloneable {
        private Node parent;
        private String name;
        private Object value;
        private Object reference;
        private LinkedMap children;

        public Node() {
            this(null);
        }

        public Node(String name) {
            this.setName(name);
        }

        public String getName() {
            return this.name;
        }

        public Object getValue() {
            return this.value;
        }

        public Node getParent() {
            return this.parent;
        }

        public void setName(String string) {
            this.name = string;
        }

        public void setValue(Object object) {
            this.value = object;
        }

        public void setParent(Node node) {
            this.parent = node;
        }

        public Object getReference() {
            return this.reference;
        }

        public void setReference(Object ref) {
            this.reference = ref;
        }

        public void addChild(Node child) {
            ArrayList<Node> c;
            if (this.children == null) {
                this.children = new LinkedMap();
            }
            if ((c = (ArrayList<Node>)this.children.get((Object)child.getName())) == null) {
                c = new ArrayList<Node>();
                this.children.put((Object)child.getName(), c);
            }
            c.add(child);
            child.setParent(this);
        }

        public List getChildren() {
            ArrayList result = new ArrayList();
            if (this.children != null) {
                Iterator it = this.children.values().iterator();
                while (it.hasNext()) {
                    result.addAll((Collection)it.next());
                }
            }
            return result;
        }

        public List getChildren(String name) {
            if (name == null || this.children == null) {
                return this.getChildren();
            }
            ArrayList list = new ArrayList();
            List c = (List)this.children.get((Object)name);
            if (c != null) {
                list.addAll(c);
            }
            return list;
        }

        public boolean remove(Node child) {
            if (this.children == null) {
                return false;
            }
            List c = (List)this.children.get((Object)child.getName());
            if (c == null) {
                return false;
            }
            if (c.remove(child)) {
                child.removeReference();
                if (c.isEmpty()) {
                    this.children.remove((Object)child.getName());
                }
                return true;
            }
            return false;
        }

        public boolean remove(String name) {
            if (this.children == null) {
                return false;
            }
            List nodes = (List)this.children.remove((Object)name);
            if (nodes != null) {
                this.nodesRemoved(nodes);
                return true;
            }
            return false;
        }

        public void removeChildren() {
            if (this.children != null) {
                Iterator it = this.children.values().iterator();
                this.children = null;
                while (it.hasNext()) {
                    this.nodesRemoved((Collection)it.next());
                }
            }
        }

        public void visit(NodeVisitor visitor, ConfigurationKey key) {
            int length = 0;
            if (key != null) {
                length = key.length();
                if (this.getName() != null) {
                    key.append(this.getName());
                }
            }
            visitor.visitBeforeChildren(this, key);
            if (this.children != null) {
                Iterator it = this.children.values().iterator();
                while (it.hasNext() && !visitor.terminate()) {
                    Collection col = (Collection)it.next();
                    Iterator it2 = col.iterator();
                    while (it2.hasNext() && !visitor.terminate()) {
                        ((Node)it2.next()).visit(visitor, key);
                    }
                }
            }
            if (key != null) {
                key.setLength(length);
            }
            visitor.visitAfterChildren(this, key);
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException cex) {
                return null;
            }
        }

        protected void removeReference() {
        }

        private void nodesRemoved(Collection nodes) {
            Iterator it = nodes.iterator();
            while (it.hasNext()) {
                ((Node)it.next()).removeReference();
            }
        }
    }
}

