/*
 * Decompiled with CFR 0.152.
 */
package org.nanocontainer.script.groovy;

import groovy.lang.Binding;
import groovy.lang.GroovyClassLoader;
import groovy.lang.Script;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.nanocontainer.NanoContainer;
import org.nanocontainer.script.NanoContainerMarkupException;
import org.nanocontainer.script.ScriptedContainerBuilder;
import org.nanocontainer.script.groovy.NanoContainerGroovyCompilationException;
import org.picocontainer.PicoContainer;

public class GroovyContainerBuilder
extends ScriptedContainerBuilder {
    private Script groovyScript;

    public GroovyContainerBuilder(Reader script, ClassLoader classLoader) {
        super(script, classLoader);
    }

    protected PicoContainer createContainerFromScript(PicoContainer parentContainer, Object assemblyScope) {
        if (this.groovyScript == null) {
            this.createGroovyScript();
        }
        Binding binding = new Binding();
        binding.setVariable("parent", (Object)parentContainer);
        binding.setVariable("assemblyScope", assemblyScope);
        this.groovyScript.setBinding(binding);
        Object result = this.groovyScript.run();
        Object picoVariable = binding.getVariable("pico");
        if (picoVariable == null) {
            picoVariable = result;
        }
        if (picoVariable instanceof PicoContainer) {
            return (PicoContainer)picoVariable;
        }
        if (picoVariable instanceof NanoContainer) {
            return ((NanoContainer)picoVariable).getPico();
        }
        throw new NanoContainerMarkupException("Bad type for pico:" + picoVariable.getClass().getName());
    }

    private void createGroovyScript() {
        try {
            GroovyClassLoader loader = new GroovyClassLoader(this.classLoader);
            InputStream scriptIs = new InputStream(){

                public int read() throws IOException {
                    return GroovyContainerBuilder.this.script.read();
                }
            };
            Class scriptClass = loader.parseClass(scriptIs, "nanocontainer.groovy");
            this.groovyScript = InvokerHelper.createScript((Class)scriptClass, null);
        }
        catch (CompilationFailedException e) {
            throw new NanoContainerGroovyCompilationException("Compilation Failed '" + e.getMessage() + "'", e);
        }
        catch (IOException e) {
            throw new NanoContainerMarkupException(e);
        }
    }
}

