/***************************************************************************

  Arcade Emulator v0.7 by Robert Anschuetz (anschuer@orlando.veda.com)

  Usage:
  arcade <name of the game to run> <graphics mode> <sound source> <joystick toggle>

  Valid values for the game parameter are:
  Galaxian - Galaxian (Midway US) *default
  Galnamco - Galaxian (Namco Japan)
  Galturbo - Galaxian (Turbo)
  Galapx   - Galaxian Part X
  Galap1   - Galaxian Part 1
  Galap4   - Galaxian Part 4
  Supgalax - Super Galaxians
  Warofbug - War of the Bugs
  Pisces   - Pisces
  Mooncrst - Moon Cresta
  Theend   - The End
  Amidar   - Amidar
  Turtles  - Turtles
  Frogger  - Frogger
  Phoenix  - Phoenix
  Pleiads  - Pleiads
  Bagman   - Bagman
  Dkong    - Donkey Kong

  Valid graphics modes are
  0 - VESA  640x480
  1 - MODEX 256x256

  Valid sound sources are
  0 - Soundblaster
  1 - Speaker
  2 - None

  Valid graphics toggles are
  0 - Joystick
  1 - No Joystick

  Example:
  arcade galaxian 1 0 0 - will run Galaxian in MODEX with
                          Soundblaster sound and a Joystick

  Lots of help from Martin Scragg's Moon Cresta Emulator

  Lots of help from Ville Laitinen's The End Emulator

  Thanks to John Butler for Frogger position info and color table

  Thanks to Edward Massey for some speed up tips and Donkey Kong framework

  Thanks to Jarek Burczynski for Bagman emulation

  Thanks to Chuck Cochems for sound input

  Thanks to Richard Aird for the Emulator loader

  Thanks to Nicola Salmoria for Donkey Kong information

  Phoenix color table from Richard Davies

  Z80 engine by Marat Fayzulin and Marcel de Kogel

  Emulator framework built by Allard van der Bas (avdbas@wi.leidenuniv.nl)
                          and Nicola Salmoria (MC6489@mclink.it)

  If you find out something useful, don't hesitate to submit it to :
  The arcade emultion programming repository.

  So it will be available to everyone at :
  http://valhalla.ph.tn.tudelft.nl/emul8

  Send it by email to :
  avdbas@wi.leidenuniv.nl

  Version History
  ---------------
  Arcade Emulator
  0.7 02/12/97
  - Fixed major bugs from version 0.6!
  - Added support for Donkey Kong (bad sprites)

  0.6 02/09/97
  - Added support for Bagman
  - Fixed Frogger speed problems and color table
  - Updated color palette for Phoenix and Pleiads
  - Lowered octave for speaker output

  0.5 01/31/97
  - Fixed joystick code

  0.4 01/28/97
  - Added support for Phoenix and Pleiads
  - Added support for Galaxian Part 1 and Galaxian Part 4
  - Updated color palettes for Amidar, Moon Cresta, and The End
  - Added front end menu if command line parameters not supplied

  0.3 01/17/97
  - Added basic Soundblaster support (must use BLASTER environment variable)
  - Fixed some bugs

  0.2 01/15/97
  - Made code more robust (followed Multipac example)
  - Added screen shot capability
  - Added Frogger support
  - Added Galaxian Turbo support
  - Changed priority of sprites

  0.1 01/09/97
  - Added Moon Cresta support
  - Added The End support
  - Added Amidar support
  - Added Turtles support
  - Added Joystick support
  - Added MODEX (256x256) support
  - Fixed some bugs

  Galaxian Emulator
  0.2 01/08/97
  - Added PC speaker sound support
  - Synchronized interrupt
  - Added Up/Down control for War of the Bugs
  - Added Dipswitch modification mode
  - Vastly improved colors
  - Major sprite problems fixed

  0.1 01/07/97
  - Initial Release

  Known problems:
  - No star field in some games
  - Dip switches do not work in most games (need memory maps!)
  - Sound does not work in some games (ditto!)
  - No two player support in The End, Amidar, or Turtles (ditto!)
  - Bullets are not done correctly in firing games
  - Colors not correct in many games
  - Sound effects for only one background voice
  - Extraneous characters appear in War of the Bugs attract mode
  - Sprite problems in second wave of Pisces
  - Speed throttling incorrect in some games
  - Palette not correct in screen snapshot
  - Sounds not very good in Phoenix and Pleiads, though the sounds for
    shields and sounds of splitting eagles and eggs sound right
  - Sprites not right in Donkey Kong

  Help on any of the above problems would be greatly appreciated!

  File/Directory Structure:
  In the same directory as the program, create directories called
  GALAXIAN, SUPGALAX, GALAPX, WAROFBUG, PISCES, MOONCRST, AMIDAR,
  TURTLES, FROGGER, GALTURBO, GALAP1, GALAP4, PHOENIX, PLEIADS, and DKONG
  and copy the ROM images there.  The ROM naming convention is as follows:

  Galaxian (Midway US)
  --------------------
  galaxian.1j
  galaxian.1k
  galaxian.u
  galaxian.v
  galaxian.w
  galaxian.y
  galaxian.z

  Galaxian (Namco Japan)
  ----------------------
  galnamco.1j
  galnamco.1k
  galnamco.u
  galnamco.v
  galnamco.w
  galnamco.y
  galnamco.z

  Super Galaxians
  ---------------
  supgalax.1j
  supgalax.1k
  supgalax.u
  supgalax.v
  supgalax.w
  supgalax.y
  supgalax.z

  Galaxian Part X
  ---------------
  galapx.1j
  galapx.1k
  galapx.u
  galapx.v
  galapx.w
  galapx.y
  galapx.z

  Galaxian Part 1
  ---------------
  galx_1.rom
  galx_1c1.rom
  galx_1c2.rom

  Galaxian Part 4
  ---------------
  galx_4.rom
  galx_4c1.rom
  galx_4c2.rom

  Galaxian (Turbo)
  ----------------
  galturbo.1j
  galturbo.1k
  galturbo.u
  galturbo.v
  galturbo.w
  galturbo.y
  galturbo.z

  War of the Bugs
  ---------------
  warofbug.1j
  warofbug.1k
  warofbug.u
  warofbug.v
  warofbug.w
  warofbug.y
  warofbug.z

  Pisces
  ------
  pisces.1j
  pisces.1k
  pisces.a1
  pisces.a2
  pisces.b2
  pisces.c1
  pisces.d1
  pisces.e2

  Moon Cresta
  -----------
  EPR194
  EPR195
  EPR196
  EPR197
  EPR198
  EPR199
  EPR200
  EPR201
  EPR202
  EPR203
  EPR171
  EPR172

  The End
  -------
  IC13
  IC14
  IC15
  IC16
  IC17
  IC18
  IC55
  IC56
  IC30
  IC31

  Amidar
  ------
  amidar.2c
  amidar.2e
  amidar.2f
  amidar.2h
  amidar.5f
  amidar.5h

  Turtles
  -------
  turt_vid.2c
  turt_vid.2e
  turt_vid.2f
  turt_vid.2h
  turt_vid.2j
  turt_vid.5f
  turt_vid.5h

  Frogger
  -------
  frogger.ic5
  frogger.ic6
  frogger.ic7
  frogger.ic8
  frogger.606
  frogger.607

  Phoenix
  -------
  phoenix.23
  phoenix.24
  phoenix.39
  phoenix.40
  phoenix.45
  phoenix.46
  phoenix.47
  phoenix.48
  phoenix.49
  phoenix.50
  phoenix.51
  phoenix.52

  Pleiads
  -------
  pleiades.26
  pleiades.27
  pleiades.44
  pleiades.45
  pleiades.47
  pleiades.48
  pleiades.49
  pleiades.50
  pleiades.51
  pleiades.52
  pleiades.53
  pleiades.54

  Bagman
  ------
  a2_1c.bin
  a2_1e.bin
  a2_1f.bin
  a2_1j.bin
  a4_9e.bin
  a4_9f.bin
  a4_9j.bin
  a4_9k.bin
  a4_9m.bin
  a4_9n.bin

  Donkey Kong
  -----------
  dk.3n
  dk.3p
  dk.5e
  dk.5c
  dk.5b
  dk.5a
  dk.7c
  dk.7d
  dk.7e
  dk.7f

  Run-time Keys:

  1     Start 1 player game
  2     Start 2 player game (Most Games)
  3     Insert Coin
  Left  Move Left
  Right Move Right
  Up    Move Up (Some Games)
  Down  Move Down (Some Games)
  Ctrl  Fire,Jump,Bomb (Some Games)
  F6    Screen Snapshot
  F7    Joystick Toggle
  F8    Sound Toggle
  F9    Modify Dipswitches (Some Games)
        (Hold F9 and Press F1-F6 to Toggle Dipswitches 1-6)
  F10   Pause/Resume Game
  ESC   Exit

***************************************************************************/

#include <stdio.h>
#include <string.h>
#include <conio.h>
#include "gfxdecod.h"
#include "machine.h"
#include "osdepend.h"
#include "roms.h"


int             main(int argc, char **argv)
{
    int             i = 1;
    int             gamefound = 0;
    int             value;

    if (argc > 4)
    {
        if (argv[4][0] == '0')
            Joystick = 1;
        else if (argv[4][0] == '1')
            Joystick = 0;
        else
            Joystick = 0;

        if (argv[3][0] == '0')
        {
            Sound = 1;
            soundsource = SB;
        }
        else if (argv[3][0] == '1')
        {
            Sound = 1;
            soundsource = SPEAKER;
        }
        else if (argv[3][0] == '2')
        {
            Sound = 0;
            soundsource = SPEAKER;
        }
        else
        {
            Sound = 0;
            soundsource = SPEAKER;
        }

        if (argv[2][0] == '0')
            graphicsmode = VESA;
        else if (argv[2][0] == '1')
            graphicsmode = MODEX;
        else
            graphicsmode = VESA;

        while ((i < NUMBER_OF_GAMES) && !gamefound)
        {
            if (gameinfo[i].name && stricmp(argv[1], gameinfo[i].name) == 0)
            {
                gameemulated = i;
                gamefound = 1;
            }
            i++;
        }
        if (!gamefound)
            gameemulated = 0;
    }
    else if (argc > 3)
    {
        printf("JOYSTICK CONFIGURATION\n\n"
               "   0.  Joystick\n"
               "   1.  No Joystick\n\n"
               "Choice -=>");
        scanf("%d", &value);
        if (value == 0)
            Joystick = 1;
        else if (value == 1)
            Joystick = 0;
        else
            Joystick = 0;

        if (argv[3][0] == '0')
        {
            Sound = 1;
            soundsource = SB;
        }
        else if (argv[3][0] == '1')
        {
            Sound = 1;
            soundsource = SPEAKER;
        }
        else if (argv[3][0] == '2')
        {
            Sound = 0;
            soundsource = SPEAKER;
        }
        else
        {
            Sound = 0;
            soundsource = SPEAKER;
        }

        if (argv[2][0] == '0')
            graphicsmode = VESA;
        else if (argv[2][0] == '1')
            graphicsmode = MODEX;
        else
            graphicsmode = VESA;

        while ((i < NUMBER_OF_GAMES) && !gamefound)
        {
            if (gameinfo[i].name && stricmp(argv[1], gameinfo[i].name) == 0)
            {
                gameemulated = i;
                gamefound = 1;
            }
            i++;
        }
        if (!gamefound)
            gameemulated = 0;
    }
    else if (argc > 2)
    {
        if (argv[2][0] == '0')
            graphicsmode = VESA;
        else if (argv[2][0] == '1')
            graphicsmode = MODEX;
        else
            graphicsmode = VESA;

        printf("AUDIO CONFIGURATION\n\n"
               "   0.  Sound Blaster\n"
               "   1.  Speaker\n"
               "   2.  None\n\n"
               "Choice -=>");
        scanf("%d", &value);
        if (value == 0)
        {
            Sound = 1;
            soundsource = SB;
        }
        else if (value == 1)
        {
            Sound = 1;
            soundsource = SPEAKER;
        }
        else if (value == 2)
        {
            Sound = 0;
            soundsource = SPEAKER;
        }
        else
        {
            Sound = 0;
            soundsource = SPEAKER;
        }

        printf("\n\nJOYSTICK CONFIGURATION\n\n"
               "   0.  Joystick\n"
               "   1.  No Joystick\n\n"
               "Choice -=>");
        scanf("%d", &value);
        if (value == 0)
            Joystick = 1;
        else if (value == 1)
            Joystick = 0;
        else
            Joystick = 0;

        while ((i < NUMBER_OF_GAMES) && !gamefound)
        {
            if (gameinfo[i].name && stricmp(argv[1], gameinfo[i].name) == 0)
            {
                gameemulated = i;
                gamefound = 1;
            }
            i++;
        }
        if (!gamefound)
            gameemulated = 0;
    }
    else if (argc > 1)
    {
        printf("VIDEO CONFIGURATION\n\n"
               "   0.  Vesa 640x480\n"
               "   1.  ModeX 256x256\n\n"
               "Choice -=>");
        scanf("%d", &value);
        if (value == 0)
            graphicsmode = VESA;
        else if (value == 1)
            graphicsmode = MODEX;
        else
            graphicsmode = VESA;

        printf("\n\nAUDIO CONFIGURATION\n\n"
               "   0.  Sound Blaster\n"
               "   1.  Speaker\n"
               "   2.  None\n\n"
               "Choice -=>");
        scanf("%d", &value);
        if (value == 0)
        {
            Sound = 1;
            soundsource = SB;
        }
        else if (value == 1)
        {
            Sound = 1;
            soundsource = SPEAKER;
        }
        else if (value == 2)
        {
            Sound = 0;
            soundsource = SPEAKER;
        }
        else
        {
            Sound = 0;
            soundsource = SPEAKER;
        }

        printf("\n\nJOYSTICK CONFIGURATION\n\n"
               "   0.  Joystick\n"
               "   1.  No Joystick\n\n"
               "Choice -=>");
        scanf("%d", &value);
        if (value == 0)
            Joystick = 1;
        else if (value == 1)
            Joystick = 0;
        else
            Joystick = 0;

        while ((i < NUMBER_OF_GAMES) && !gamefound)
        {
            if (gameinfo[i].name && stricmp(argv[1], gameinfo[i].name) == 0)
            {
                gameemulated = i;
                gamefound = 1;
            }
            i++;
        }
        if (!gamefound)
            gameemulated = 0;

    }
    else if (argc == 1)
    {
        printf("GAME CONFIGURATION\n\n"
               "   0.  Galaxian (Midway)\n"
               "   1.  Galaxian (Namco)\n"
               "   2.  Galaxian (Turbo)\n"
               "   3.  Galaxian Part X\n"
               "   4.  Galaxian Part 1\n"
               "   5.  Galaxian Part 4\n"
               "   6.  Super Galaxians\n"
               "   7.  War of the Bugs\n"
               "   8.  Pisces\n"
               "   9.  Moon Cresta\n"
               "   10. The End\n"
               "   11. Amidar\n"
               "   12. Turtles\n"
               "   13. Frogger\n"
               "   14. Phoenix\n"
               "   15. Pleiads\n"
               "   16. Bagman\n"
               "   17. Donkey Kong\n\n"
               "Choice -=>");
        scanf("%d", &gameemulated);

        printf("\n\nVIDEO CONFIGURATION\n\n"
               "   0.  Vesa 640x480\n"
               "   1.  ModeX 256x256\n\n"
               "Choice -=>");
        scanf("%d", &value);
        if (value == 0)
            graphicsmode = VESA;
        else if (value == 1)
            graphicsmode = MODEX;
        else
            graphicsmode = VESA;

        printf("\n\nAUDIO CONFIGURATION\n\n"
               "   0.  Sound Blaster\n"
               "   1.  Speaker\n"
               "   2.  None\n\n"
               "Choice -=>");
        scanf("%d", &value);
        if (value == 0)
        {
            Sound = 1;
            soundsource = SB;
        }
        else if (value == 1)
        {
            Sound = 1;
            soundsource = SPEAKER;
        }
        else if (value == 2)
        {
            Sound = 0;
            soundsource = SPEAKER;
        }
        else
        {
            Sound = 0;
            soundsource = SPEAKER;
        }

        printf("\n\nJOYSTICK CONFIGURATION\n\n"
               "   0.  Joystick\n"
               "   1.  No Joystick\n\n"
               "Choice -=>");
        scanf("%d", &value);
        if (value == 0)
            Joystick = 1;
        else if (value == 1)
            Joystick = 0;
        else
            Joystick = 0;

    }
    if (init_machine(gameinfo[gameemulated].name) == 0)
    {
        printf("\n\nPLEASE DO NOT DISTRIBUTE THE SOURCE FILES OR THE EXECUTABLE WITH ROM IMAGES.\n"
               "DOING SO WILL HARM FURTHER EMULATOR DEVELOPMENT AND WILL CONSIDERABLY ANNOY\n"
               "THE RIGHTFUL COPYRIGHT HOLDERS OF THOSE ROM IMAGES AND CAN RESULT IN LEGAL\n"
               "ACTION UNDERTAKEN BY EARLIER MENTIONED COPYRIGHT HOLDERS.\n"
               "\n\n"
               "  1     Start 1 player game\n"
               "  2     Start 2 player game\n"
               "  3     Insert Coin\n"
               "  Left  Move Left\n"
               "  Right Move Right\n"
               "  Up    Move Up (Some Games)\n"
               "  Down  Move Down (Some Games)\n"
               "  Ctrl  Fire,Jump,Bomb (Some Games)\n"
               "  F6    Screen Snapshot\n"
               "  F7    Joystick Toggle\n"
               "  F8    Sound Toggle (Some games)\n"
               "  F9    Modify Dipswitches (Some Games)\n"
             "        (Hold F9 and Press F1-F6 to Toggle Dipswitches 1-6)\n"
               "  F10   Pause/Resume Game\n"
               "  ESC   Exit\n"
               "\n\nPress any key to continue\n");

        getch();

        if (osd_init() == 0)
        {
            if (run_machine() != 0)
                printf("Unable to start emulation\n");

            osd_exit();
        }
        else
            printf("Unable to initialize system\n");
    }
    else
        printf("Unable to initialize machine emulation\n");

    exit(0);
}
