#include "common.h"

struct GameInfo
{
    const char     *name;
    const struct RomModule *rom;
};



struct GameVidInfo
{
    const char     *name;
    const struct RomModule *gfxrom;
    const unsigned char *palette;
    const unsigned char *colortable;
};

extern const struct GameInfo gameinfo[];
extern const struct GameVidInfo gamevidinfo[];

extern const unsigned char palette[3 * 8];
extern const unsigned char colortable[4 * 16];

enum
{
    black, red, purple, cyan, yellow, blue, green, white
};

enum
{
    TE1, TE2, TE3, TE4, TE5, TE6, TE7, TE8, TE9, TEA, TEB, TEC, TED, TEE, TEF, TEG, TEH
};

enum
{
    MC1, MC2, MC3, MC4, MC5, MC6, MC7, MC8, MC9, MCA, MCB, MCC, MCD, MCE, MCF, MCG, MCH, MCI, MCJ, MCK
};

enum
{
    pBLACK, pWHITE, pRED, pGREEN, pBLUE, pCYAN, pYELLOW, pPINK, pORANGE, pLTPURPLE, pDKORANGE,
    pDKPURPLE, pDKCYAN, pDKYELLOW, pBLUISH, pPURPLE
};

enum {dkBLACK,dkDKRED1,dkDKRED2,dkRED,dkDKGRN1,dkDKBRN1,dkDKBRN2,dkLTRED1,dkBROWN,dkDKGRN2,
	dkLTORG1,dkDKGRN3,dkDKYEL,dkDKORG,dkORANGE,dkGREEN1,dkLTGRN1,dkGREEN2,dkLTGRN2,dkYELLOW,
	dkDKBLU1,dkDKPNK1,dkDKPNK2,dkLTRED2,dkLTBRN,dkLTORG2,dkLTGRN3,dkLTGRN4,dkLTYEL,dkDKBLU2,
	dkPINK1,dkDKBLU3,dkPINK2,dkCREAM,dkLTORG3,dkBLUE,dkPURPLE,dkLTBLU1,dkLTBLU2,dkWHITE1,
	dkWHITE2};

#define UNUSED BLACK
#define TOTAL_COLORS 8
#define THEEND_TOTAL_COLORS 17
#define DONKEY_KONG_TOTAL_COLORS 41
#define MOONCRST_TOTAL_COLORS 20
#define PHOENIX_TOTAL_COLORS 20
#define COLOR_CODES 16
#define PHOENIX_COLOR_CODES 32
