#include "roms.h"

const struct RomModule GalaxianGFXROMs[] =
{
    {"galaxian.1j", 0x0000, 0x0800},
    {"galaxian.1k", 0x0800, 0x0800},
    {0, 0, 0}                   // end of table
};

const struct RomModule GalaxianROMs[] =
{
    {"galaxian.u", 0x0000, 0x0800},
    {"galaxian.v", 0x0800, 0x0800},
    {"galaxian.w", 0x1000, 0x0800},
    {"galaxian.y", 0x1800, 0x0800},
    {"galaxian.z", 0x2000, 0x0800},
    {0, 0, 0}                   // end of table
};

const struct RomModule GalnamcoGFXROMs[] =
{
    {"galnamco.1j", 0x0000, 0x0800},
    {"galnamco.1k", 0x0800, 0x0800},
    {0, 0, 0}                   // end of table
};

const struct RomModule GalnamcoROMs[] =
{
    {"galnamco.u", 0x0000, 0x0800},
    {"galnamco.v", 0x0800, 0x0800},
    {"galnamco.w", 0x1000, 0x0800},
    {"galnamco.y", 0x1800, 0x0800},
    {"galnamco.z", 0x2000, 0x0800},
    {0, 0, 0}                   // end of table
};

const struct RomModule SupgalaxGFXROMs[] =
{
    {"supgalax.1j", 0x0000, 0x0800},
    {"supgalax.1k", 0x0800, 0x0800},
    {0, 0, 0}                   // end of table
};

const struct RomModule SupgalaxROMs[] =
{
    {"supgalax.u", 0x0000, 0x0800},
    {"supgalax.v", 0x0800, 0x0800},
    {"supgalax.w", 0x1000, 0x0800},
    {"supgalax.y", 0x1800, 0x0800},
    {"supgalax.z", 0x2000, 0x0800},
    {0, 0, 0}                   // end of table
};

const struct RomModule GalapxGFXROMs[] =
{
    {"galapx.1j", 0x0000, 0x0800},
    {"galapx.1k", 0x0800, 0x0800},
    {0, 0, 0}                   // end of table
};

const struct RomModule GalapxROMs[] =
{
    {"galapx.u", 0x0000, 0x0800},
    {"galapx.v", 0x0800, 0x0800},
    {"galapx.w", 0x1000, 0x0800},
    {"galapx.y", 0x1800, 0x0800},
    {"galapx.z", 0x2000, 0x0800},
    {0, 0, 0}                   // end of table
};

const struct RomModule Galap1GFXROMs[] =
{
    {"galx_1c1.rom", 0x0000, 0x0800},
    {"galx_1c2.rom", 0x0800, 0x0800},
    {0, 0, 0}                   // end of table
};

const struct RomModule Galap1ROMs[] =
{
    {"galx_1.rom", 0x0000, 0x2800},
    {0, 0, 0}                   // end of table
};

const struct RomModule Galap4GFXROMs[] =
{
    {"galx_4c1.rom", 0x0000, 0x0800},
    {"galx_4c2.rom", 0x0800, 0x0800},
    {0, 0, 0}                   // end of table
};

const struct RomModule Galap4ROMs[] =
{
    {"galx_4.rom", 0x0000, 0x2800},
    {0, 0, 0}                   // end of table
};

const struct RomModule GalturboGFXROMs[] =
{
    {"galturbo.1j", 0x0000, 0x0800},
    {"galturbo.1k", 0x0800, 0x0800},
    {0, 0, 0}                   // end of table
};

const struct RomModule GalturboROMs[] =
{
    {"galturbo.u", 0x0000, 0x0800},
    {"galturbo.v", 0x0800, 0x0800},
    {"galturbo.w", 0x1000, 0x0800},
    {"galturbo.y", 0x1800, 0x0800},
    {"galturbo.z", 0x2000, 0x0800},
    {0, 0, 0}                   // end of table
};

const struct RomModule WarofbugGFXROMs[] =
{
    {"warofbug.1j", 0x0000, 0x0800},
    {"warofbug.1k", 0x0800, 0x0800},
    {0, 0, 0}                   // end of table
};

const struct RomModule WarofbugROMs[] =
{
    {"warofbug.u", 0x0000, 0x0800},
    {"warofbug.v", 0x0800, 0x0800},
    {"warofbug.w", 0x1000, 0x0800},
    {"warofbug.y", 0x1800, 0x0800},
    {"warofbug.z", 0x2000, 0x0800},
    {0, 0, 0}                   // end of table
};

const struct RomModule PiscesGFXROMs[] =
{
    {"pisces.1j", 0x0000, 0x0800},
    {"pisces.1k", 0x0800, 0x0800},
    {0, 0, 0}                   // end of table
};

const struct RomModule PiscesROMs[] =
{
    {"pisces.a1", 0x0000, 0x0800},
    {"pisces.a2", 0x0800, 0x0800},
    {"pisces.b2", 0x1000, 0x0800},
    {"pisces.c1", 0x1800, 0x0800},
    {"pisces.d1", 0x2000, 0x0800},
    {"pisces.e2", 0x2800, 0x0800},
    {0, 0, 0}                   // end of table
};

const struct RomModule MoonCrestaGFXROMs[] =
{
    {"EPR202", 0x0000, 0x0800},
    {"EPR203", 0x0800, 0x0800},
    {"EPR171", 0x1000, 0x0800},
    {"EPR172", 0x1800, 0x0800},
    {0, 0, 0}                   // end of table
};

const struct RomModule MoonCrestaROMs[] =
{
    {"EPR194", 0x0000, 0x0800},
    {"EPR195", 0x0800, 0x0800},
    {"EPR196", 0x1000, 0x0800},
    {"EPR197", 0x1800, 0x0800},
    {"EPR198", 0x2000, 0x0800},
    {"EPR199", 0x2800, 0x0800},
    {"EPR200", 0x3000, 0x0800},
    {"EPR201", 0x3800, 0x0800},
    {0, 0, 0}                   // end of table
};

const struct RomModule TheEndGFXROMs[] =
{
    {"IC30", 0x0000, 0x0800},
    {"IC31", 0x0800, 0x0800},
    {0, 0, 0}                   // end of table
};

const struct RomModule TheEndROMs[] =
{
    {"IC13", 0x0000, 0x0800},
    {"IC14", 0x0800, 0x0800},
    {"IC15", 0x1000, 0x0800},
    {"IC16", 0x1800, 0x0800},
    {"IC17", 0x2000, 0x0800},
    {"IC18", 0x2800, 0x0800},
    {"IC56", 0x3000, 0x0800},
    {"IC55", 0x3800, 0x0800},
    {0, 0, 0}                   // end of table
};

const struct RomModule AmidarGFXROMs[] =
{
    {"amidar.5f", 0x0000, 0x0800},
    {"amidar.5h", 0x0800, 0x0800},
    {0, 0, 0}                   // end of table
};

const struct RomModule AmidarROMs[] =
{
    {"amidar.2c", 0x0000, 0x1000},
    {"amidar.2e", 0x1000, 0x1000},
    {"amidar.2f", 0x2000, 0x1000},
    {"amidar.2h", 0x3000, 0x1000},
    {0, 0, 0}                   // end of table
};

const struct RomModule TurtlesGFXROMs[] =
{
    {"turt_vid.5f", 0x0000, 0x0800},
    {"turt_vid.5h", 0x0800, 0x0800},
    {0, 0, 0}                   // end of table
};

const struct RomModule TurtlesROMs[] =
{
    {"turt_vid.2c", 0x0000, 0x1000},
    {"turt_vid.2e", 0x1000, 0x1000},
    {"turt_vid.2f", 0x2000, 0x1000},
    {"turt_vid.2h", 0x3000, 0x1000},
    {"turt_vid.2j", 0x4000, 0x1000},
    {0, 0, 0}                   // end of table
};

const struct RomModule FroggerGFXROMs[] =
{
    {"frogger.606", 0x0000, 0x0800},
    {"frogger.607", 0x0800, 0x0800},
    {0, 0, 0}                   // end of table
};

const struct RomModule FroggerROMs[] =
{
    {"frogger.ic5", 0x0000, 0x1000},
    {"frogger.ic6", 0x1000, 0x1000},
    {"frogger.ic7", 0x2000, 0x1000},
    {"frogger.ic8", 0x3000, 0x1000},
    {0, 0, 0}                   // end of table
};

const struct RomModule PhoenixGFXROMs[] =
{
    {"phoenix.39", 0x0000, 0x0800},
    {"phoenix.40", 0x0800, 0x0800},
    {"phoenix.23", 0x1000, 0x0800},
    {"phoenix.24", 0x1800, 0x0800},
    {0, 0, 0}                   // end of table
};

const struct RomModule PhoenixROMs[] =
{
    {"phoenix.45", 0x0000, 0x0800},
    {"phoenix.46", 0x0800, 0x0800},
    {"phoenix.47", 0x1000, 0x0800},
    {"phoenix.48", 0x1800, 0x0800},
    {"phoenix.49", 0x2000, 0x0800},
    {"phoenix.50", 0x2800, 0x0800},
    {"phoenix.51", 0x3000, 0x0800},
    {"phoenix.52", 0x3800, 0x0800},
    {0, 0, 0}                   // end of table
};

const struct RomModule PleiadsGFXROMs[] =
{
    {"pleiades.27", 0x0000, 0x0800},
    {"pleiades.26", 0x0800, 0x0800},
    {"pleiades.45", 0x1000, 0x0800},
    {"pleiades.44", 0x1800, 0x0800},
    {0, 0, 0}                   // end of table
};

const struct RomModule PleiadsROMs[] =
{
    {"pleiades.47", 0x0000, 0x0800},
    {"pleiades.48", 0x0800, 0x0800},
    {"pleiades.49", 0x1000, 0x0800},
    {"pleiades.50", 0x1800, 0x0800},
    {"pleiades.51", 0x2000, 0x0800},
    {"pleiades.52", 0x2800, 0x0800},
    {"pleiades.53", 0x3000, 0x0800},
    {"pleiades.54", 0x3800, 0x0800},
    {0, 0, 0}                   // end of table
};

const struct RomModule BagmanGFXROMs[] =
{
    {"a2_1e.bin", 0x0000, 0x1000},
    {"a2_1j.bin", 0x1000, 0x1000},
    {"a2_1c.bin", 0x2000, 0x1000},
    {"a2_1f.bin", 0x3000, 0x1000},
    {0, 0, 0}                   // end of table
};

const struct RomModule BagmanROMs[] =
{
    {"a4_9e.bin", 0x0000, 0x1000},
    {"a4_9f.bin", 0x1000, 0x1000},
    {"a4_9j.bin", 0x2000, 0x1000},
    {"a4_9k.bin", 0x3000, 0x1000},
    {"a4_9m.bin", 0x4000, 0x1000},
    {"a4_9n.bin", 0x5000, 0x1000},
    {0, 0, 0}                   // end of table
};

const struct RomModule DonkeyKongGFXROMs[] =
{
    {"dk.3n", 0x0000, 0x0800}, // characters a
    {"dk.3p", 0x0800, 0x0800}, // characters b
    {"dk.7c", 0x1000, 0x0800}, // top half sprites a
    {"dk.7d", 0x1800, 0x0800}, // bottom half sprites a
    {"dk.7e", 0x2000, 0x0800}, // top half sprites b
    {"dk.7f", 0x2800, 0x0800}, // bottom half sprites b
    {0, 0, 0}                   // end of table
};

const struct RomModule DonkeyKongROMs[] =
{
    {"dk.5e", 0x0000, 0x1000},
    {"dk.5c", 0x1000, 0x1000},
    {"dk.5b", 0x2000, 0x1000},
    {"dk.5a", 0x3000, 0x1000},
    {0, 0, 0}                   // end of table
};


/* "What is the palette doing here", you might ask, "it's not a ROM!" */
/* Well, actually the palette and lookup table were stored in PROMs, whose */
/* image, unfortunately, is usually unavailable. So we have to supply our */
/* own. */

const unsigned char palette[3 * TOTAL_COLORS] =
{
    0, 0, 0,                    // BLACK
    63, 0, 0,                   // RED
    238, 130, 238,              // PURPLE
    0, 63, 63,                  // CYAN,
    63, 63, 0,                  // YELLOW,
    9, 9, 63,                   // BLUE
    0, 100, 0,                  // GREEN
    54, 54, 54                  // WHITE
};

const unsigned char phoenixpalette[3 * PHOENIX_TOTAL_COLORS] =
{
    0x00, 0x00, 0x00,           /* BLACK */
    0xdb, 0xdb, 0xdb,           /* WHITE */
    0xff, 0x00, 0x00,           /* RED */
    0x00, 0xff, 0x00,           /* GREEN */
    0x24, 0x24, 0xdb,           /* BLUE */
    0x00, 0xff, 0xdb,           /* CYAN, */
    0xff, 0xff, 0x00,           /* YELLOW, */
    0xff, 0xb6, 0xdb,           /* PINK */
    0xff, 0xb6, 0x49,           /* ORANGE */
    0xff, 0x24, 0xb6,           /* LTPURPLE */
    0xff, 0xb6, 0x00,           /* DKORANGE */
    0xb6, 0x24, 0xff,           /* DKPURPLE */
    0x00, 0xdb, 0xdb,           /* DKCYAN */
    0xdb, 0xdb, 0x00,           /* DKYELLOW */
    0x95, 0x95, 0xff,           /* BLUISH */
    0xff, 0x00, 0xff,           /* PURPLE */
};

const unsigned char galaxianpalette[3 * TOTAL_COLORS] =
{
    0, 0, 0,                    // BLACK
    63, 0, 0,                   // RED
    238, 130, 238,              // PURPLE
    0, 63, 63,                  // CYAN,
    63, 63, 0,                  // YELLOW,
    9, 9, 63,                   // BLUE
    0, 100, 0,                  // GREEN
    54, 54, 54                  // WHITE
};

const unsigned char amidarpalette[3 * TOTAL_COLORS] =
{
    0, 0, 0,                    // BLACK
    63, 0, 0,                   // RED
    238, 162, 173,              // PURPLE
    0, 63, 63,                  // CYAN,
    63, 63, 0,                  // YELLOW,
    9, 9, 63,                   // BLUE
    0, 63, 0,                   // GREEN
    54, 54, 54                  // WHITE
};

static unsigned char donkeykongpalette[3 * DONKEY_KONG_TOTAL_COLORS] =
{
	0x00,0x00,0x00,	/* BLACK */
	0x49,0x00,0x00,	/* DKRED1 */
	0x92,0x00,0x00,	/* DKRED2 */
	0xff,0x00,0x00,	/* RED */
	0x00,0x24,0x00,	/* DKGRN1 */
	0x92,0x24,0x00,	/* DKBRN1 */
	0xb6,0x24,0x00,	/* DKBRN2 */
	0xff,0x24,0x00,	/* LTRED1 */
	0xdb,0x49,0x00,	/* BROWN */
	0x00,0x6c,0x00,	/* DKGRN2 */
	0xff,0x6c,0x00,	/* LTORG1 */
	0x00,0x92,0x00,	/* DKGRN3 */
	0x92,0x92,0x00,	/* DKYEL */
	0xdb,0x92,0x00,	/* DKORG */
	0xff,0x92,0x00,	/* ORANGE */
	0x00,0xdb,0x00,	/* GREEN1 */
	0x6d,0xdb,0x00,	/* LTGRN1 */
	0x00,0xff,0x00,	/* GREEN2 */
	0x49,0xff,0x00,	/* LTGRN2 */
	0xff,0xff,0x00,	/* YELLOW */
	0x00,0x00,0x55,	/* DKBLU1 */
	0xff,0x00,0x55,	/* DKPNK1 */
	0xff,0x24,0x55,	/* DKPNK2 */
	0xff,0x6d,0x55,	/* LTRED2 */
	0xdb,0x92,0x55,	/* LTBRN */
	0xff,0x92,0x55,	/* LTORG2 */
	0x24,0xff,0x55,	/* LTGRN3 */
	0x49,0xff,0x55,	/* LTGRN4 */
	0xff,0xff,0x55,	/* LTYEL */
	0x00,0x00,0xaa,	/* DKBLU2 */
	0xff,0x00,0xaa,	/* PINK1 */
	0x00,0x24,0xaa,	/* DKBLU3 */
	0xff,0x24,0xaa,	/* PINK2 */
	0xdb,0xdb,0xaa,	/* CREAM */
	0xff,0xdb,0xaa,	/* LTORG3 */
	0x00,0x00,0xff,	/* BLUE */
	0xdb,0x00,0xff,	/* PURPLE */
	0x00,0xb6,0xff,	/* LTBLU1 */
	0x92,0xdb,0xff,	/* LTBLU2 */
	0xdb,0xdb,0xff,	/* WHITE1 */
	0xff,0xff,0xff	/* WHITE2 */
};

const unsigned char theendpalette[3 * THEEND_TOTAL_COLORS] =
{
    0, 0, 0,                    // TE1
    20, 20, 20,                 // TE2
    40, 40, 40,                 // TE3
    58, 58, 58,                 // TE4
    63, 63, 63,                 // TE5
    10, 10, 20,                 // TE6
    20, 20, 40,                 // TE7
    0, 0, 63,                   // TE8
    63, 0, 0,                   // TE9
    0, 63, 0,                   // TEA
    0, 20, 0,                   // TEB
    0, 40, 0,                   // TEC
    40, 63, 63,                 // TED
    0, 0, 20,                   // TEE
    0, 0, 40,                   // TEF
    63, 20, 63,                 // TEG
    63, 0, 63,                  // TEH
};

const unsigned char mooncrstpalette[3 * MOONCRST_TOTAL_COLORS] =
{
    0, 0, 0,                    // MC1
    0, 0, 255,                  // MC2
    255, 0, 0,                  // MC3
    255, 255, 0,                // MC4
    128, 0, 255,                // MC5
    255, 128, 0,                // MC6
    255, 0, 128,                // MC7
    28, 20, 0,                  // MC8
    0, 28, 20,                  // MC9
    23, 30, 23,                 // MCA
    0, 200, 128,                // MCB
    200, 128, 200,              // MCC
    128, 255, 128,              // MCD
    200, 200, 64,               // MCE
    255, 0, 200,                // MCF
    200, 64, 255,               // MCG
    200, 255, 0,                // MCH
    0, 255, 200,                // MCI
    255, 0, 255,                // MCJ
    255, 255, 255               // MCK
};

const unsigned char froggerpalette[3 * 13] =
{
    0, 0, 0,                    // BLACK
    63, 0, 0,                   // RED
    36, 0, 55,                  // PURPLE
    0, 55, 55,                  // CYAN
    63, 63, 0,                  // YELLOW
    0, 0, 55,                   // BLUE
    8, 55, 0,                   // GREEN
    63, 63, 63,                 // WHITE
    63, 16, 0,                  // ORANGE
    0, 8, 24,                   // DARK BLUE
    55, 24, 16,                 // LIGHT BROWN
    37, 24, 16,                 // DARK BROWN
    63, 16, 55                  // PINK
};


/* The color of each character/sprite is determined by a 5 bit value, which */
/* selects the entry to use in this lookup table, and by the 2 bits of the */
/* chracter/sprite data. Additionally, bit 7 of the byte stored in Color RAM */
/* seems to be set for text characters; the reason is yet unknown. */

const unsigned char colortable[4 * COLOR_CODES] =
{
    black, white, white, white,
    black, red, blue, yellow,
    black, blue, red, yellow,
    black, blue, purple, red,
    black, blue, green, red,
    black, red, red, red,
    black, white, red, cyan,
    black, yellow, red, purple,
    black, red, blue, green,
    black, red, green, blue,
    black, red, blue, yellow,
    black, blue, red, yellow,
    black, blue, purple, red,
    black, blue, green, red,
    black, white, red, cyan,
    black, yellow, red, purple
};

/* 4 colors per pixel * 8 groups of characters * 2 charsets * 2 pallettes */
const unsigned char phoenixcolortable[4 * PHOENIX_COLOR_CODES] =
{
    /* charset A pallette A */
    pBLACK, pBLACK, pCYAN, pCYAN,   /* Background, Unused, Letters, asterisks */
    pBLACK, pYELLOW, pRED, pWHITE,  /* Background, Ship middle, Numbers/Ship,
                                     * Ship edge */
    pBLACK, pYELLOW, pRED, pWHITE,  /* Background, Ship middle, Ship, Ship
                                     * edge/bullets */
    pBLACK, pPINK, pPURPLE, pYELLOW,    /* Background, Bird eyes, Bird
                                         * middle, Bird Wings */
    pBLACK, pPINK, pPURPLE, pYELLOW,    /* Background, Bird eyes, Bird
                                         * middle, Bird Wings */
    pBLACK, pPINK, pPURPLE, pYELLOW,    /* Background, Bird eyes, Bird
                                         * middle, Bird Wings */
    pBLACK, pWHITE, pPURPLE, pYELLOW,   /* Background, Explosions */
    pBLACK, pPURPLE, pGREEN, pWHITE,    /* Background, Barrier */
    /* charset A pallette B */
    pBLACK, pBLUE, pCYAN, pCYAN,/* Background, Unused, Letters, asterisks */
    pBLACK, pYELLOW, pRED, pWHITE,  /* Background, Ship middle, Numbers/Ship,
                                     * Ship edge */
    pBLACK, pYELLOW, pRED, pWHITE,  /* Background, Ship middle, Ship, Ship
                                     * edge/bullets */
    pBLACK, pYELLOW, pGREEN, pPURPLE,   /* Background, Bird eyes, Bird
                                         * middle, Bird Wings */
    pBLACK, pYELLOW, pGREEN, pPURPLE,   /* Background, Bird eyes, Bird
                                         * middle, Bird Wings */
    pBLACK, pYELLOW, pGREEN, pPURPLE,   /* Background, Bird eyes, Bird
                                         * middle, Bird Wings */
    pBLACK, pWHITE, pRED, pPURPLE,  /* Background, Explosions */
    pBLACK, pPURPLE, pGREEN, pWHITE,    /* Background, Barrier */
    /* charset B pallette A */
    pBLACK, pRED, pBLUE, pWHITE,/* Background, Starfield */
    pBLACK, pPURPLE, pBLUISH, pDKORANGE,    /* Background, Planets */
    pBLACK, pDKPURPLE, pGREEN, pDKORANGE,   /* Background, Mothership:
                                             * turrets, u-body, l-body */
    pBLACK, pBLUISH, pDKPURPLE, pLTPURPLE,  /* Background, Motheralien: face,
                                             * body, feet */
    pBLACK, pPURPLE, pBLUISH, pGREEN,   /* Background, Eagles: face, body,
                                         * shell */
    pBLACK, pPURPLE, pBLUISH, pGREEN,   /* Background, Eagles: face, body,
                                         * feet */
    pBLACK, pPURPLE, pBLUISH, pGREEN,   /* Background, Eagles: face, body,
                                         * feet */
    pBLACK, pPURPLE, pBLUISH, pGREEN,   /* Background, Eagles: face, body,
                                         * feet */
    /* charset B pallette B */
    pBLACK, pRED, pBLUE, pWHITE,/* Background, Starfield */
    pBLACK, pPURPLE, pBLUISH, pDKORANGE,    /* Background, Planets */
    pBLACK, pDKPURPLE, pGREEN, pDKORANGE,   /* Background, Mothership:
                                             * turrets, upper body, lower
                                             * body */
    pBLACK, pBLUISH, pDKPURPLE, pLTPURPLE,  /* Background, Motheralien: face,
                                             * body, feet */
    pBLACK, pBLUISH, pLTPURPLE, pGREEN, /* Background, Eagles: face, body,
                                         * shell */
    pBLACK, pBLUISH, pLTPURPLE, pGREEN, /* Background, Eagles: face, body,
                                         * feet */
    pBLACK, pBLUISH, pLTPURPLE, pGREEN, /* Background, Eagles: face, body,
                                         * feet */
    pBLACK, pBLUISH, pLTPURPLE, pGREEN  /* Background, Eagles: face, body,
                                         * feet */
};

const unsigned char galaxiancolortable[4 * COLOR_CODES] =
{
    black, white, white, white, /* background, white text */
    black, red, blue, yellow,   /* flag ship */
    black, blue, red, yellow,   /* red bug */
    black, blue, purple, red,   /* purple bug */
    black, blue, green, red,    /* green bug */
    black, red, red, red,       /* red text */
    black, white, red, cyan,    /* player ship, cyan text */
    black, yellow, red, purple, /* explosion, purple text */
    black, black, black, black,
    black, black, black, black,
    black, black, black, black,
    black, black, black, black,
    black, black, black, black,
    black, black, black, black,
    black, black, black, black,
    black, black, black, black
};

static unsigned char donkeykongcolortable[4 * COLOR_CODES] =
{
	/* characters and sprites */
	dkBLACK,dkPINK1,dkRED,dkDKGRN3,               /* 1st level */
	dkBLACK,dkLTORG1,dkWHITE1,dkLTRED1,             /* pauline with kong */
	dkBLACK,dkRED,dkCREAM,dkBLUE,		/* Mario */
	dkBLACK,dkPINK1,dkRED,dkDKGRN3,                  /* 3rd level */
	dkBLACK,dkBLUE,dkLTBLU1,dkLTYEL,                /* 4th lvl */
	dkBLACK,dkBLUE,dkLTYEL,dkLTBLU1,               /* 2nd level */
	dkBLACK,dkRED,dkCREAM,dkBLUE,                  /* blue text */
	dkBLACK,dkLTYEL,dkBROWN,dkWHITE1,	/* hammers */
	dkBLACK,dkLTBRN,dkBROWN,dkCREAM,               /* kong */
	dkBLACK,dkRED,dkLTRED1,dkYELLOW,             /* oil flame */
	dkBLACK,dkLTBRN,dkCREAM,dkLTRED1,              /* pauline */
	dkBLACK,dkLTYEL,dkBLUE,dkBROWN,		/* barrels */
	dkBLACK,dkCREAM,dkLTBLU2,dkBLUE,	/* "oil" barrel */
	dkBLACK,dkYELLOW,dkBLUE,dkRED,               /* small mario, spring */
	dkBLACK,dkDKGRN3,dkLTBLU1,dkBROWN,            /* scared flame */
	dkBLACK,dkLTRED1,dkYELLOW,dkBLUE,            /* flame */
};

const unsigned char froggercolortable[4 * COLOR_CODES] =
{
    /* 1 UP, HI SCORE */
    black, blue, red, white,
    /* grass, CREDIT 00, fly, completed frog */
    black, 8 /* orange */ , green, cyan,
    /* logs */
    black, 10 /* ltbrown */ , white, 11 /* drkbrown */ ,
    /* frogger */
    black, purple, green, yellow,
    /* cars (3rd row) */
    black, green, cyan, 12 /* pink */ ,
    /* bulldozers (2nd row), racers (4th row), trucks (5th row), turtles */
    black, red, white, green,
    /* middle and bottom grass, score, time (middle) */
    black, purple, blue, red,
    /* racers (1st row) */
    black, red, yellow, purple,
    black, red, blue, green,    // not used
    black, red, green, blue,    // not used
    black, red, blue, yellow,   // not used
    black, blue, red, yellow,   // not used
    black, blue, purple, red,   // not used
    black, blue, green, red,    // not used
    black, white, red, cyan,    // not used
    yellow, red, purple         // not used
};

const unsigned char amidarcolortable[4 * COLOR_CODES] =
{
    black, red, blue, white,    // white text
    black, green, yellow, purple,   // yellow gorilla
    black, green, red, yellow,  // yellow line on title screen
    black, red, purple, green,
    black, yellow, green, red,
    black, red, yellow, green,
    black, white, red, purple,  // purple pig
    black, cyan, red, white,    // white pig
    black, black, black, black,
    black, black, black, black,
    black, black, black, black,
    black, black, black, black,
    black, black, black, black,
    black, black, black, black,
    black, black, black, black,
    black, black, black, black
};

const unsigned char theendcolortable[4 * COLOR_CODES] =
{
    TE1, TE2, TE3, TE5,         // white text
    TE1, TE8, TE9, TEA,         //
    TE1, TEB, TEC, TEA,         // green text
    TE1, TE9, TE8, TED,         //
    TE1, TEE, TEF, TE8,         // bluish text
    TE1, TE6, TE7, TED,         //
    TE1, TE8, TEG, TE4,         //
    TE1, TE5, TEA, TEH,         // explosion
    TE1, TE1, TE1, TE1,
    TE1, TE1, TE1, TE1,
    TE1, TE1, TE1, TE1,
    TE1, TE1, TE1, TE1,
    TE1, TE1, TE1, TE1,
    TE1, TE1, TE1, TE1,
    TE1, TE1, TE1, TE1,
    TE1, TE1, TE1, TE1,

};

const unsigned char mooncrstcolortable[4 * COLOR_CODES] =
{
    MC1, MC3, MCK, MC2,
    MC1, MC2, MC3, MC4,
    MC1, MC5, MC6, MC7,
    MC1, MC8, MC9, MCA,
    MC1, MCB, MCC, MCD,
    MC1, MCE, MCF, MCG,
    MC1, MC2, MC4, MC3,
    MC1, MCH, MCI, MCJ,
    MC1, MC1, MC1, MC1,
    MC1, MC1, MC1, MC1,
    MC1, MC1, MC1, MC1,
    MC1, MC1, MC1, MC1,
    MC1, MC1, MC1, MC1,
    MC1, MC1, MC1, MC1,
    MC1, MC1, MC1, MC1,
    MC1, MC1, MC1, MC1
};

const unsigned char bagmancolortable[4 * COLOR_CODES] =
{
    black, blue, yellow, red,   // 00 axe, hanging bag
    black, blue, yellow, red,   // 01 laying bag
    black, blue, red, yellow,   // 02 PLAYER 1 BONUS PLAYER 2
    black, white, white, white, // 03
    black, red, blue, white,    // 04 train, lift on 2nd screen, special bag
    black, red, yellow, white,  // 05 points, bonus value (0000, 3900)
    black, white, blue, green,  // 06 STERN LOGO (start screen)
    black, yellow, red, white,  // 07 BAGMAN logo (start screen)
    black, yellow, red, purple, // 08 CREDIT 01, bagman, the thing you drop
                                // bags into (I don't know correct English
                                // word)
    black, white, white, white, // 09
    black, white, white, white, // 0A
    black, white, white, white, // 0B
    black, yellow, blue, white, // 0C cops, lift on 3rd screen
    black, white, white, white, // 0D
    black, white, white, white, // 0E
    black, yellow, red, cyan    // 0F ground(sand) colour
};

const struct GameVidInfo gamevidinfo[] =
{
    {"galaxian", GalaxianGFXROMs, galaxianpalette, galaxiancolortable},
    {"galnamco", GalnamcoGFXROMs, galaxianpalette, galaxiancolortable},
    {"galturbo", GalturboGFXROMs, galaxianpalette, galaxiancolortable},
    {"galapx", GalapxGFXROMs, galaxianpalette, galaxiancolortable},
    {"galap1", Galap1GFXROMs, galaxianpalette, galaxiancolortable},
    {"galap4", Galap4GFXROMs, galaxianpalette, galaxiancolortable},
    {"supgalax", SupgalaxGFXROMs, galaxianpalette, galaxiancolortable},
    {"warofbug", WarofbugGFXROMs, galaxianpalette, galaxiancolortable},
    {"pisces", PiscesGFXROMs, palette, colortable},
    {"mooncrst", MoonCrestaGFXROMs, mooncrstpalette, mooncrstcolortable},
    {"theend", TheEndGFXROMs, theendpalette, theendcolortable},
    {"amidar", AmidarGFXROMs, amidarpalette, amidarcolortable},
    {"turtles", TurtlesGFXROMs, palette, colortable},
    {"frogger", FroggerGFXROMs, froggerpalette, froggercolortable},
    {"phoenix", PhoenixGFXROMs, phoenixpalette, phoenixcolortable},
    {"pleiads", PleiadsGFXROMs, phoenixpalette, phoenixcolortable},
    {"bagman", BagmanGFXROMs, palette, bagmancolortable},
    {"dkong", DonkeyKongGFXROMs, donkeykongpalette, donkeykongcolortable}
};

const struct GameInfo gameinfo[] =
{
    {"galaxian", GalaxianROMs},
    {"galnamco", GalnamcoROMs},
    {"galturbo", GalturboROMs},
    {"galapx", GalapxROMs},
    {"galap1", Galap1ROMs},
    {"galap4", Galap4ROMs},
    {"supgalax", SupgalaxROMs},
    {"warofbug", WarofbugROMs},
    {"pisces", PiscesROMs},
    {"mooncrst", MoonCrestaROMs},
    {"theend", TheEndROMs},
    {"amidar", AmidarROMs},
    {"turtles", TurtlesROMs},
    {"frogger", FroggerROMs},
    {"phoenix", PhoenixROMs},
    {"pleiads", PleiadsROMs},
    {"bagman", BagmanROMs},
    {"dkong", DonkeyKongROMs}
};
