/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.geom.transform;

import com.sun.javafx.geom.Point2D;
import com.sun.javafx.geom.transform.Affine3D;
import com.sun.javafx.geom.transform.AffineBase;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.geom.transform.NoninvertibleTransformException;

public class Affine2D
extends AffineBase {
    private static final long BASE_HASH;

    private Affine2D(double mxx, double myx, double mxy, double myy, double mxt, double myt, int state) {
        this.mxx = mxx;
        this.myx = myx;
        this.mxy = mxy;
        this.myy = myy;
        this.mxt = mxt;
        this.myt = myt;
        this.state = state;
        this.type = -1;
    }

    public Affine2D() {
        this.myy = 1.0;
        this.mxx = 1.0;
    }

    public Affine2D(BaseTransform Tx) {
        this.setTransform(Tx);
    }

    public Affine2D(float mxx, float myx, float mxy, float myy, float mxt, float myt) {
        this.mxx = mxx;
        this.myx = myx;
        this.mxy = mxy;
        this.myy = myy;
        this.mxt = mxt;
        this.myt = myt;
        this.updateState2D();
    }

    public Affine2D(double mxx, double myx, double mxy, double myy, double mxt, double myt) {
        this.mxx = mxx;
        this.myx = myx;
        this.mxy = mxy;
        this.myy = myy;
        this.mxt = mxt;
        this.myt = myt;
        this.updateState2D();
    }

    @Override
    public BaseTransform.Degree getDegree() {
        return BaseTransform.Degree.AFFINE_2D;
    }

    @Override
    protected void reset3Delements() {
    }

    public void rotate(double theta, double anchorx, double anchory) {
        this.translate(anchorx, anchory);
        this.rotate(theta);
        this.translate(-anchorx, -anchory);
    }

    public void rotate(double vecx, double vecy) {
        if (vecy == 0.0) {
            if (vecx < 0.0) {
                this.rotate180();
            }
        } else if (vecx == 0.0) {
            if (vecy > 0.0) {
                this.rotate90();
            } else {
                this.rotate270();
            }
        } else {
            double len = Math.sqrt(vecx * vecx + vecy * vecy);
            double sin = vecy / len;
            double cos = vecx / len;
            double M0 = this.mxx;
            double M1 = this.mxy;
            this.mxx = cos * M0 + sin * M1;
            this.mxy = -sin * M0 + cos * M1;
            M0 = this.myx;
            M1 = this.myy;
            this.myx = cos * M0 + sin * M1;
            this.myy = -sin * M0 + cos * M1;
            this.updateState2D();
        }
    }

    public void rotate(double vecx, double vecy, double anchorx, double anchory) {
        this.translate(anchorx, anchory);
        this.rotate(vecx, vecy);
        this.translate(-anchorx, -anchory);
    }

    public void quadrantRotate(int numquadrants) {
        switch (numquadrants & 3) {
            case 0: {
                break;
            }
            case 1: {
                this.rotate90();
                break;
            }
            case 2: {
                this.rotate180();
                break;
            }
            case 3: {
                this.rotate270();
            }
        }
    }

    public void quadrantRotate(int numquadrants, double anchorx, double anchory) {
        switch (numquadrants & 3) {
            case 0: {
                return;
            }
            case 1: {
                this.mxt += anchorx * (this.mxx - this.mxy) + anchory * (this.mxy + this.mxx);
                this.myt += anchorx * (this.myx - this.myy) + anchory * (this.myy + this.myx);
                this.rotate90();
                break;
            }
            case 2: {
                this.mxt += anchorx * (this.mxx + this.mxx) + anchory * (this.mxy + this.mxy);
                this.myt += anchorx * (this.myx + this.myx) + anchory * (this.myy + this.myy);
                this.rotate180();
                break;
            }
            case 3: {
                this.mxt += anchorx * (this.mxx + this.mxy) + anchory * (this.mxy - this.mxx);
                this.myt += anchorx * (this.myx + this.myy) + anchory * (this.myy - this.myx);
                this.rotate270();
            }
        }
        if (this.mxt == 0.0 && this.myt == 0.0) {
            this.state &= 0xFFFFFFFE;
            if (this.type != -1) {
                this.type &= 0xFFFFFFFE;
            }
        } else {
            this.state |= 1;
            this.type |= 1;
        }
    }

    public void setToTranslation(double tx, double ty) {
        this.mxx = 1.0;
        this.myx = 0.0;
        this.mxy = 0.0;
        this.myy = 1.0;
        this.mxt = tx;
        this.myt = ty;
        if (tx != 0.0 || ty != 0.0) {
            this.state = 1;
            this.type = 1;
        } else {
            this.state = 0;
            this.type = 0;
        }
    }

    public void setToRotation(double theta) {
        double cos;
        double sin = Math.sin(theta);
        if (sin == 1.0 || sin == -1.0) {
            cos = 0.0;
            this.state = 4;
            this.type = 8;
        } else {
            cos = Math.cos(theta);
            if (cos == -1.0) {
                sin = 0.0;
                this.state = 2;
                this.type = 8;
            } else if (cos == 1.0) {
                sin = 0.0;
                this.state = 0;
                this.type = 0;
            } else {
                this.state = 6;
                this.type = 16;
            }
        }
        this.mxx = cos;
        this.myx = sin;
        this.mxy = -sin;
        this.myy = cos;
        this.mxt = 0.0;
        this.myt = 0.0;
    }

    public void setToRotation(double theta, double anchorx, double anchory) {
        this.setToRotation(theta);
        double sin = this.myx;
        double oneMinusCos = 1.0 - this.mxx;
        this.mxt = anchorx * oneMinusCos + anchory * sin;
        this.myt = anchory * oneMinusCos - anchorx * sin;
        if (this.mxt != 0.0 || this.myt != 0.0) {
            this.state |= 1;
            this.type |= 1;
        }
    }

    public void setToRotation(double vecx, double vecy) {
        double cos;
        double sin;
        if (vecy == 0.0) {
            sin = 0.0;
            if (vecx < 0.0) {
                cos = -1.0;
                this.state = 2;
                this.type = 8;
            } else {
                cos = 1.0;
                this.state = 0;
                this.type = 0;
            }
        } else if (vecx == 0.0) {
            cos = 0.0;
            sin = vecy > 0.0 ? 1.0 : -1.0;
            this.state = 4;
            this.type = 8;
        } else {
            double len = Math.sqrt(vecx * vecx + vecy * vecy);
            cos = vecx / len;
            sin = vecy / len;
            this.state = 6;
            this.type = 16;
        }
        this.mxx = cos;
        this.myx = sin;
        this.mxy = -sin;
        this.myy = cos;
        this.mxt = 0.0;
        this.myt = 0.0;
    }

    public void setToRotation(double vecx, double vecy, double anchorx, double anchory) {
        this.setToRotation(vecx, vecy);
        double sin = this.myx;
        double oneMinusCos = 1.0 - this.mxx;
        this.mxt = anchorx * oneMinusCos + anchory * sin;
        this.myt = anchory * oneMinusCos - anchorx * sin;
        if (this.mxt != 0.0 || this.myt != 0.0) {
            this.state |= 1;
            this.type |= 1;
        }
    }

    public void setToQuadrantRotation(int numquadrants) {
        switch (numquadrants & 3) {
            case 0: {
                this.mxx = 1.0;
                this.myx = 0.0;
                this.mxy = 0.0;
                this.myy = 1.0;
                this.mxt = 0.0;
                this.myt = 0.0;
                this.state = 0;
                this.type = 0;
                break;
            }
            case 1: {
                this.mxx = 0.0;
                this.myx = 1.0;
                this.mxy = -1.0;
                this.myy = 0.0;
                this.mxt = 0.0;
                this.myt = 0.0;
                this.state = 4;
                this.type = 8;
                break;
            }
            case 2: {
                this.mxx = -1.0;
                this.myx = 0.0;
                this.mxy = 0.0;
                this.myy = -1.0;
                this.mxt = 0.0;
                this.myt = 0.0;
                this.state = 2;
                this.type = 8;
                break;
            }
            case 3: {
                this.mxx = 0.0;
                this.myx = -1.0;
                this.mxy = 1.0;
                this.myy = 0.0;
                this.mxt = 0.0;
                this.myt = 0.0;
                this.state = 4;
                this.type = 8;
            }
        }
    }

    public void setToQuadrantRotation(int numquadrants, double anchorx, double anchory) {
        switch (numquadrants & 3) {
            case 0: {
                this.mxx = 1.0;
                this.myx = 0.0;
                this.mxy = 0.0;
                this.myy = 1.0;
                this.mxt = 0.0;
                this.myt = 0.0;
                this.state = 0;
                this.type = 0;
                break;
            }
            case 1: {
                this.mxx = 0.0;
                this.myx = 1.0;
                this.mxy = -1.0;
                this.myy = 0.0;
                this.mxt = anchorx + anchory;
                this.myt = anchory - anchorx;
                if (this.mxt == 0.0 && this.myt == 0.0) {
                    this.state = 4;
                    this.type = 8;
                    break;
                }
                this.state = 5;
                this.type = 9;
                break;
            }
            case 2: {
                this.mxx = -1.0;
                this.myx = 0.0;
                this.mxy = 0.0;
                this.myy = -1.0;
                this.mxt = anchorx + anchorx;
                this.myt = anchory + anchory;
                if (this.mxt == 0.0 && this.myt == 0.0) {
                    this.state = 2;
                    this.type = 8;
                    break;
                }
                this.state = 3;
                this.type = 9;
                break;
            }
            case 3: {
                this.mxx = 0.0;
                this.myx = -1.0;
                this.mxy = 1.0;
                this.myy = 0.0;
                this.mxt = anchorx - anchory;
                this.myt = anchory + anchorx;
                if (this.mxt == 0.0 && this.myt == 0.0) {
                    this.state = 4;
                    this.type = 8;
                    break;
                }
                this.state = 5;
                this.type = 9;
            }
        }
    }

    public void setToScale(double sx, double sy) {
        this.mxx = sx;
        this.myx = 0.0;
        this.mxy = 0.0;
        this.myy = sy;
        this.mxt = 0.0;
        this.myt = 0.0;
        if (sx != 1.0 || sy != 1.0) {
            this.state = 2;
            this.type = -1;
        } else {
            this.state = 0;
            this.type = 0;
        }
    }

    @Override
    public void setTransform(BaseTransform Tx) {
        switch (Tx.getDegree()) {
            case IDENTITY: {
                this.setToIdentity();
                break;
            }
            case TRANSLATE_2D: {
                this.setToTranslation(Tx.getMxt(), Tx.getMyt());
                break;
            }
            default: {
                if (Tx.getType() > 127) {
                    System.out.println(Tx + " is " + Tx.getType());
                    System.out.print("  " + Tx.getMxx());
                    System.out.print(", " + Tx.getMxy());
                    System.out.print(", " + Tx.getMxz());
                    System.out.print(", " + Tx.getMxt());
                    System.out.println();
                    System.out.print("  " + Tx.getMyx());
                    System.out.print(", " + Tx.getMyy());
                    System.out.print(", " + Tx.getMyz());
                    System.out.print(", " + Tx.getMyt());
                    System.out.println();
                    System.out.print("  " + Tx.getMzx());
                    System.out.print(", " + Tx.getMzy());
                    System.out.print(", " + Tx.getMzz());
                    System.out.print(", " + Tx.getMzt());
                    System.out.println();
                    Affine2D.degreeError(BaseTransform.Degree.AFFINE_2D);
                }
            }
            case AFFINE_2D: {
                this.mxx = Tx.getMxx();
                this.myx = Tx.getMyx();
                this.mxy = Tx.getMxy();
                this.myy = Tx.getMyy();
                this.mxt = Tx.getMxt();
                this.myt = Tx.getMyt();
                if (Tx instanceof AffineBase) {
                    this.state = ((AffineBase)Tx).state;
                    this.type = ((AffineBase)Tx).type;
                    break;
                }
                this.updateState2D();
            }
        }
    }

    public void preConcatenate(BaseTransform Tx) {
        switch (Tx.getDegree()) {
            case IDENTITY: {
                return;
            }
            case TRANSLATE_2D: {
                this.translate(Tx.getMxt(), Tx.getMyt());
                return;
            }
            case AFFINE_2D: {
                break;
            }
            default: {
                Affine2D.degreeError(BaseTransform.Degree.AFFINE_2D);
            }
        }
        int mystate = this.state;
        Affine2D at = (Affine2D)Tx;
        int txstate = at.state;
        switch (txstate << 4 | mystate) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return;
            }
            case 16: 
            case 18: 
            case 20: 
            case 22: {
                this.mxt = at.mxt;
                this.myt = at.myt;
                this.state = mystate | 1;
                this.type |= 1;
                return;
            }
            case 17: 
            case 19: 
            case 21: 
            case 23: {
                this.mxt += at.mxt;
                this.myt += at.myt;
                return;
            }
            case 32: 
            case 33: {
                this.state = mystate | 2;
            }
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                double Txx = at.mxx;
                double Tyy = at.myy;
                if ((mystate & 4) != 0) {
                    this.mxy *= Txx;
                    this.myx *= Tyy;
                    if ((mystate & 2) != 0) {
                        this.mxx *= Txx;
                        this.myy *= Tyy;
                    }
                } else {
                    this.mxx *= Txx;
                    this.myy *= Tyy;
                }
                if ((mystate & 1) != 0) {
                    this.mxt *= Txx;
                    this.myt *= Tyy;
                }
                this.type = -1;
                return;
            }
            case 68: 
            case 69: {
                mystate |= 2;
            }
            case 64: 
            case 65: 
            case 66: 
            case 67: {
                this.state = mystate ^ 4;
            }
            case 70: 
            case 71: {
                double Txy = at.mxy;
                double Tyx = at.myx;
                double M0 = this.mxx;
                this.mxx = this.myx * Txy;
                this.myx = M0 * Tyx;
                M0 = this.mxy;
                this.mxy = this.myy * Txy;
                this.myy = M0 * Tyx;
                M0 = this.mxt;
                this.mxt = this.myt * Txy;
                this.myt = M0 * Tyx;
                this.type = -1;
                return;
            }
        }
        double Txx = at.mxx;
        double Txy = at.mxy;
        double Txt = at.mxt;
        double Tyx = at.myx;
        double Tyy = at.myy;
        double Tyt = at.myt;
        switch (mystate) {
            default: {
                Affine2D.stateError();
            }
            case 7: {
                double M0 = this.mxt;
                double M1 = this.myt;
                Txt += M0 * Txx + M1 * Txy;
                Tyt += M0 * Tyx + M1 * Tyy;
            }
            case 6: {
                this.mxt = Txt;
                this.myt = Tyt;
                double M0 = this.mxx;
                double M1 = this.myx;
                this.mxx = M0 * Txx + M1 * Txy;
                this.myx = M0 * Tyx + M1 * Tyy;
                M0 = this.mxy;
                M1 = this.myy;
                this.mxy = M0 * Txx + M1 * Txy;
                this.myy = M0 * Tyx + M1 * Tyy;
                break;
            }
            case 5: {
                double M0 = this.mxt;
                double M1 = this.myt;
                Txt += M0 * Txx + M1 * Txy;
                Tyt += M0 * Tyx + M1 * Tyy;
            }
            case 4: {
                this.mxt = Txt;
                this.myt = Tyt;
                double M0 = this.myx;
                this.mxx = M0 * Txy;
                this.myx = M0 * Tyy;
                M0 = this.mxy;
                this.mxy = M0 * Txx;
                this.myy = M0 * Tyx;
                break;
            }
            case 3: {
                double M0 = this.mxt;
                double M1 = this.myt;
                Txt += M0 * Txx + M1 * Txy;
                Tyt += M0 * Tyx + M1 * Tyy;
            }
            case 2: {
                this.mxt = Txt;
                this.myt = Tyt;
                double M0 = this.mxx;
                this.mxx = M0 * Txx;
                this.myx = M0 * Tyx;
                M0 = this.myy;
                this.mxy = M0 * Txy;
                this.myy = M0 * Tyy;
                break;
            }
            case 1: {
                double M0 = this.mxt;
                double M1 = this.myt;
                Txt += M0 * Txx + M1 * Txy;
                Tyt += M0 * Tyx + M1 * Tyy;
            }
            case 0: {
                this.mxt = Txt;
                this.myt = Tyt;
                this.mxx = Txx;
                this.myx = Tyx;
                this.mxy = Txy;
                this.myy = Tyy;
                this.state = mystate | txstate;
                this.type = -1;
                return;
            }
        }
        this.updateState2D();
    }

    @Override
    public Affine2D createInverse() throws NoninvertibleTransformException {
        switch (this.state) {
            default: {
                Affine2D.stateError();
            }
            case 7: {
                double det = this.mxx * this.myy - this.mxy * this.myx;
                if (det == 0.0 || Math.abs(det) <= Double.MIN_VALUE) {
                    throw new NoninvertibleTransformException("Determinant is " + det);
                }
                return new Affine2D(this.myy / det, -this.myx / det, -this.mxy / det, this.mxx / det, (this.mxy * this.myt - this.myy * this.mxt) / det, (this.myx * this.mxt - this.mxx * this.myt) / det, 7);
            }
            case 6: {
                double det = this.mxx * this.myy - this.mxy * this.myx;
                if (det == 0.0 || Math.abs(det) <= Double.MIN_VALUE) {
                    throw new NoninvertibleTransformException("Determinant is " + det);
                }
                return new Affine2D(this.myy / det, -this.myx / det, -this.mxy / det, this.mxx / det, 0.0, 0.0, 6);
            }
            case 5: {
                if (this.mxy == 0.0 || this.myx == 0.0) {
                    throw new NoninvertibleTransformException("Determinant is 0");
                }
                return new Affine2D(0.0, 1.0 / this.mxy, 1.0 / this.myx, 0.0, -this.myt / this.myx, -this.mxt / this.mxy, 5);
            }
            case 4: {
                if (this.mxy == 0.0 || this.myx == 0.0) {
                    throw new NoninvertibleTransformException("Determinant is 0");
                }
                return new Affine2D(0.0, 1.0 / this.mxy, 1.0 / this.myx, 0.0, 0.0, 0.0, 4);
            }
            case 3: {
                if (this.mxx == 0.0 || this.myy == 0.0) {
                    throw new NoninvertibleTransformException("Determinant is 0");
                }
                return new Affine2D(1.0 / this.mxx, 0.0, 0.0, 1.0 / this.myy, -this.mxt / this.mxx, -this.myt / this.myy, 3);
            }
            case 2: {
                if (this.mxx == 0.0 || this.myy == 0.0) {
                    throw new NoninvertibleTransformException("Determinant is 0");
                }
                return new Affine2D(1.0 / this.mxx, 0.0, 0.0, 1.0 / this.myy, 0.0, 0.0, 2);
            }
            case 1: {
                return new Affine2D(1.0, 0.0, 0.0, 1.0, -this.mxt, -this.myt, 1);
            }
            case 0: 
        }
        return new Affine2D();
    }

    public void transform(Point2D[] ptSrc, int srcOff, Point2D[] ptDst, int dstOff, int numPts) {
        int mystate = this.state;
        block10: while (--numPts >= 0) {
            Point2D dst;
            Point2D src = ptSrc[srcOff++];
            double x = src.x;
            double y = src.y;
            if ((dst = ptDst[dstOff++]) == null) {
                ptDst[dstOff - 1] = dst = new Point2D();
            }
            switch (mystate) {
                default: {
                    Affine2D.stateError();
                }
                case 7: {
                    dst.setLocation((float)(x * this.mxx + y * this.mxy + this.mxt), (float)(x * this.myx + y * this.myy + this.myt));
                    continue block10;
                }
                case 6: {
                    dst.setLocation((float)(x * this.mxx + y * this.mxy), (float)(x * this.myx + y * this.myy));
                    continue block10;
                }
                case 5: {
                    dst.setLocation((float)(y * this.mxy + this.mxt), (float)(x * this.myx + this.myt));
                    continue block10;
                }
                case 4: {
                    dst.setLocation((float)(y * this.mxy), (float)(x * this.myx));
                    continue block10;
                }
                case 3: {
                    dst.setLocation((float)(x * this.mxx + this.mxt), (float)(y * this.myy + this.myt));
                    continue block10;
                }
                case 2: {
                    dst.setLocation((float)(x * this.mxx), (float)(y * this.myy));
                    continue block10;
                }
                case 1: {
                    dst.setLocation((float)(x + this.mxt), (float)(y + this.myt));
                    continue block10;
                }
                case 0: 
            }
            dst.setLocation((float)x, (float)y);
        }
    }

    public Point2D deltaTransform(Point2D ptSrc, Point2D ptDst) {
        if (ptDst == null) {
            ptDst = new Point2D();
        }
        double x = ptSrc.x;
        double y = ptSrc.y;
        switch (this.state) {
            default: {
                Affine2D.stateError();
            }
            case 6: 
            case 7: {
                ptDst.setLocation((float)(x * this.mxx + y * this.mxy), (float)(x * this.myx + y * this.myy));
                return ptDst;
            }
            case 4: 
            case 5: {
                ptDst.setLocation((float)(y * this.mxy), (float)(x * this.myx));
                return ptDst;
            }
            case 2: 
            case 3: {
                ptDst.setLocation((float)(x * this.mxx), (float)(y * this.myy));
                return ptDst;
            }
            case 0: 
            case 1: 
        }
        ptDst.setLocation((float)x, (float)y);
        return ptDst;
    }

    private static double _matround(double matval) {
        return Math.rint(matval * 1.0E15) / 1.0E15;
    }

    @Override
    public String toString() {
        return "Affine2D[[" + Affine2D._matround(this.mxx) + ", " + Affine2D._matround(this.mxy) + ", " + Affine2D._matround(this.mxt) + "], [" + Affine2D._matround(this.myx) + ", " + Affine2D._matround(this.myy) + ", " + Affine2D._matround(this.myt) + "]]";
    }

    @Override
    public boolean is2D() {
        return true;
    }

    @Override
    public void restoreTransform(double mxx, double myx, double mxy, double myy, double mxt, double myt) {
        this.setTransform(mxx, myx, mxy, myy, mxt, myt);
    }

    @Override
    public void restoreTransform(double mxx, double mxy, double mxz, double mxt, double myx, double myy, double myz, double myt, double mzx, double mzy, double mzz, double mzt) {
        if (mxz != 0.0 || myz != 0.0 || mzx != 0.0 || mzy != 0.0 || mzz != 1.0 || mzt != 0.0) {
            Affine2D.degreeError(BaseTransform.Degree.AFFINE_2D);
        }
        this.setTransform(mxx, myx, mxy, myy, mxt, myt);
    }

    @Override
    public BaseTransform deriveWithTranslation(double mxt, double myt) {
        this.translate(mxt, myt);
        return this;
    }

    @Override
    public BaseTransform deriveWithTranslation(double mxt, double myt, double mzt) {
        if (mzt == 0.0) {
            this.translate(mxt, myt);
            return this;
        }
        Affine3D a = new Affine3D(this);
        a.translate(mxt, myt, mzt);
        return a;
    }

    @Override
    public BaseTransform deriveWithScale(double mxx, double myy, double mzz) {
        if (mzz == 1.0) {
            this.scale(mxx, myy);
            return this;
        }
        Affine3D a = new Affine3D(this);
        a.scale(mxx, myy, mzz);
        return a;
    }

    @Override
    public BaseTransform deriveWithRotation(double theta, double axisX, double axisY, double axisZ) {
        if (theta == 0.0) {
            return this;
        }
        if (Affine2D.almostZero(axisX) && Affine2D.almostZero(axisY)) {
            if (axisZ > 0.0) {
                this.rotate(theta);
            } else if (axisZ < 0.0) {
                this.rotate(-theta);
            }
            return this;
        }
        Affine3D a = new Affine3D(this);
        a.rotate(theta, axisX, axisY, axisZ);
        return a;
    }

    @Override
    public BaseTransform deriveWithPreTranslation(double mxt, double myt) {
        this.mxt += mxt;
        this.myt += myt;
        if (this.mxt != 0.0 || this.myt != 0.0) {
            this.state |= 1;
            this.type |= 1;
        } else {
            this.state &= 0xFFFFFFFE;
            if (this.type != -1) {
                this.type &= 0xFFFFFFFE;
            }
        }
        return this;
    }

    @Override
    public BaseTransform deriveWithConcatenation(double mxx, double myx, double mxy, double myy, double mxt, double myt) {
        BaseTransform tmpTx = Affine2D.getInstance(mxx, myx, mxy, myy, mxt, myt);
        this.concatenate(tmpTx);
        return this;
    }

    @Override
    public BaseTransform deriveWithConcatenation(double mxx, double mxy, double mxz, double mxt, double myx, double myy, double myz, double myt, double mzx, double mzy, double mzz, double mzt) {
        if (mxz == 0.0 && myz == 0.0 && mzx == 0.0 && mzy == 0.0 && mzz == 1.0 && mzt == 0.0) {
            this.concatenate(mxx, mxy, mxt, myx, myy, myt);
            return this;
        }
        Affine3D t3d = new Affine3D(this);
        t3d.concatenate(mxx, mxy, mxz, mxt, myx, myy, myz, myt, mzx, mzy, mzz, mzt);
        return t3d;
    }

    @Override
    public BaseTransform deriveWithConcatenation(BaseTransform tx) {
        if (tx.is2D()) {
            this.concatenate(tx);
            return this;
        }
        Affine3D t3d = new Affine3D(this);
        t3d.concatenate(tx);
        return t3d;
    }

    @Override
    public BaseTransform deriveWithPreConcatenation(BaseTransform tx) {
        if (tx.is2D()) {
            this.preConcatenate(tx);
            return this;
        }
        Affine3D t3d = new Affine3D(this);
        t3d.preConcatenate(tx);
        return t3d;
    }

    @Override
    public BaseTransform deriveWithNewTransform(BaseTransform tx) {
        if (tx.is2D()) {
            this.setTransform(tx);
            return this;
        }
        return Affine2D.getInstance(tx);
    }

    @Override
    public BaseTransform copy() {
        return new Affine2D(this);
    }

    @Override
    public int hashCode() {
        if (this.isIdentity()) {
            return 0;
        }
        long bits = BASE_HASH;
        bits = bits * 31L + Double.doubleToLongBits(this.getMyy());
        bits = bits * 31L + Double.doubleToLongBits(this.getMyx());
        bits = bits * 31L + Double.doubleToLongBits(this.getMxy());
        bits = bits * 31L + Double.doubleToLongBits(this.getMxx());
        bits = bits * 31L + Double.doubleToLongBits(0.0);
        bits = bits * 31L + Double.doubleToLongBits(this.getMyt());
        bits = bits * 31L + Double.doubleToLongBits(this.getMxt());
        return (int)bits ^ (int)(bits >> 32);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof BaseTransform) {
            BaseTransform a = (BaseTransform)obj;
            return a.getType() <= 127 && a.getMxx() == this.mxx && a.getMxy() == this.mxy && a.getMxt() == this.mxt && a.getMyx() == this.myx && a.getMyy() == this.myy && a.getMyt() == this.myt;
        }
        return false;
    }

    static {
        long bits = 0L;
        bits = bits * 31L + Double.doubleToLongBits(IDENTITY_TRANSFORM.getMzz());
        bits = bits * 31L + Double.doubleToLongBits(IDENTITY_TRANSFORM.getMzy());
        bits = bits * 31L + Double.doubleToLongBits(IDENTITY_TRANSFORM.getMzx());
        bits = bits * 31L + Double.doubleToLongBits(IDENTITY_TRANSFORM.getMyz());
        BASE_HASH = bits = bits * 31L + Double.doubleToLongBits(IDENTITY_TRANSFORM.getMxz());
    }
}

