/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.javafx.callback;

import java.util.List;
import java.util.stream.Collectors;
import javafx.collections.ObservableList;
import javafx.stage.FileChooser;

final class FileChoosers {
    private FileChoosers() {
    }

    static void setExtensionFilters(FileChooser fileChooser, String filterDescription, List<String> extensions) {
        ObservableList extensionFilters = fileChooser.getExtensionFilters();
        if (!extensions.isEmpty()) {
            FileChooser.ExtensionFilter filter = new FileChooser.ExtensionFilter(filterDescription, FileChoosers.withPrefix(extensions));
            extensionFilters.add((Object)filter);
            fileChooser.setSelectedExtensionFilter(filter);
        }
        FileChooser.ExtensionFilter allFilesFilter = new FileChooser.ExtensionFilter("All files", new String[]{"*.*"});
        extensionFilters.add((Object)allFilesFilter);
    }

    private static List<String> withPrefix(List<String> extensions) {
        return extensions.stream().map(e -> "*." + e).collect(Collectors.toList());
    }
}

