/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.javafx.internal.menu;

import com.teamdev.jxbrowser.browser.internal.callback.ShowDropdownCallback;
import com.teamdev.jxbrowser.ui.Point;
import com.teamdev.jxbrowser.ui.Rect;
import com.teamdev.jxbrowser.ui.internal.DropdownItem;
import com.teamdev.jxbrowser.ui.internal.Geometry;
import com.teamdev.jxbrowser.view.javafx.BrowserView;
import com.teamdev.jxbrowser.view.javafx.internal.HiDpi;
import java.util.List;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.CustomMenuItem;
import javafx.scene.control.Label;

public final class Dropdown {
    private final BrowserView parent;
    private final ContextMenu contextMenu;

    public Dropdown(BrowserView parent, List<DropdownItem> items, ShowDropdownCallback.Action action) {
        this.parent = parent;
        this.contextMenu = new ContextMenu();
        this.contextMenu.setAutoHide(true);
        this.contextMenu.setOnHidden(event -> {
            if (!action.isClosed()) {
                action.cancel();
            }
            parent.setMouseTransparent(false);
        });
        items.forEach(item -> this.addItem(this.contextMenu, (DropdownItem)item, action));
    }

    public void show(Rect bounds, double scaleFactor) {
        Platform.runLater(() -> {
            this.parent.setMouseTransparent(true);
            Point2D locationOnScreen = this.locationOnScreen(bounds, scaleFactor);
            this.contextMenu.show((Node)this.parent, locationOnScreen.getX(), locationOnScreen.getY());
        });
    }

    private Point2D locationOnScreen(Rect bounds, double scaleFactor) {
        Point origin = bounds.origin();
        Point location = Point.of((int)origin.x(), (int)(origin.y() + bounds.height()));
        if (HiDpi.isPlatformDpiAware(scaleFactor)) {
            location = Geometry.scaleDown((Point)location, (double)scaleFactor);
        }
        return this.parent.localToScreen(location.x(), location.y());
    }

    private void addItem(ContextMenu menu, DropdownItem item, ShowDropdownCallback.Action action) {
        ObservableList menuItems = menu.getItems();
        if (item.isOptgroup()) {
            CustomMenuItem menuItem = new CustomMenuItem((Node)new Label(item.label()));
            menuItem.setDisable(true);
            menuItems.add((Object)menuItem);
        } else {
            CheckMenuItem menuItem = new CheckMenuItem(item.label());
            menuItem.setSelected(item.isChecked());
            menuItem.setOnAction(event -> {
                if (!action.isClosed()) {
                    action.select(item);
                }
            });
            menuItem.setDisable(!item.isEnabled());
            menuItems.add((Object)menuItem);
        }
    }
}

