/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.javafx.internal.menu;

import com.teamdev.jxbrowser.browser.callback.internal.ShowSuggestionsCallback;
import com.teamdev.jxbrowser.browser.internal.BrowserImpl;
import com.teamdev.jxbrowser.internal.rpc.BrowserId;
import com.teamdev.jxbrowser.internal.rpc.Suggestion;
import com.teamdev.jxbrowser.suggestions.SuggestionsPopupType;
import com.teamdev.jxbrowser.ui.Point;
import com.teamdev.jxbrowser.ui.internal.Geometry;
import com.teamdev.jxbrowser.view.javafx.BrowserView;
import com.teamdev.jxbrowser.view.javafx.internal.HiDpi;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;

public final class SuggestionsPopup {
    private static final Map<BrowserId, SuggestionsPopup> OPEN_POPUPS = new ConcurrentHashMap<BrowserId, SuggestionsPopup>();
    private final ShowSuggestionsCallback.Params params;
    private final ShowSuggestionsCallback.Action callback;
    private final BrowserId browserId;
    private final BrowserView parent;
    private final ContextMenu suggestionsPopup;

    static Optional<SuggestionsPopup> fromBrowser(BrowserId id) {
        return Optional.ofNullable(OPEN_POPUPS.get(id));
    }

    public SuggestionsPopup(BrowserView parent, ShowSuggestionsCallback.Params params, ShowSuggestionsCallback.Action callback) {
        this.parent = parent;
        this.params = params;
        this.callback = callback;
        this.browserId = ((BrowserImpl)parent.getBrowser()).id();
        this.suggestionsPopup = new ContextMenu();
    }

    private void addSuggestions(List<Suggestion> suggestions) {
        for (Suggestion suggestion : suggestions) {
            MenuItem suggestionItem = this.createSuggestionItem(this.params, suggestion);
            this.suggestionsPopup.getItems().add(suggestion.getIndex(), (Object)suggestionItem);
            suggestionItem.setOnAction(e -> this.callback.accept(suggestion));
        }
    }

    private MenuItem createSuggestionItem(ShowSuggestionsCallback.Params params, Suggestion suggestion) {
        MenuItem suggestionItem = new MenuItem();
        String text = params.popupType() == SuggestionsPopupType.PASSWORDS ? String.format("%s\n%s", suggestion.getValue(), suggestion.getHiddenPassword()) : (params.popupType() == SuggestionsPopupType.ADDRESSES ? String.format("%s\n%s", suggestion.getValue(), suggestion.getAddressOrFullname()) : suggestion.getValue());
        Label label = new Label(text);
        suggestionItem.setGraphic((Node)label);
        return suggestionItem;
    }

    private Point popupLocation() {
        com.teamdev.jxbrowser.ui.internal.rpc.Point screenSpaceLocation = this.params.location();
        double scaleFactor = this.params.scaleFactor();
        if (HiDpi.isPlatformDpiAware(scaleFactor)) {
            return screenSpaceLocation;
        }
        return Geometry.scaleUp((Point)screenSpaceLocation, (double)scaleFactor);
    }

    public void show() {
        this.suggestionsPopup.setAutoHide(true);
        this.suggestionsPopup.setOnHidden(event -> {
            if (!this.callback.isClosed()) {
                this.callback.cancel();
            }
            OPEN_POPUPS.remove(this.browserId);
        });
        this.addSuggestions(this.params.suggestions());
        Point location = this.popupLocation();
        Platform.runLater(() -> {
            this.suggestionsPopup.show((Node)this.parent, (double)location.x(), (double)location.y());
            OPEN_POPUPS.put(this.browserId, this);
        });
    }

    void updateSuggestions(List<Suggestion> updatedSuggestions) {
        Platform.runLater(() -> {
            this.suggestionsPopup.getItems().removeAll((Collection)this.suggestionsPopup.getItems());
            this.addSuggestions(updatedSuggestions);
        });
    }

    void hide() {
        Platform.runLater(() -> ((ContextMenu)this.suggestionsPopup).hide());
    }
}

