/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.javafx.internal.window;

import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import com.teamdev.jxbrowser.internal.SystemProperties;
import com.teamdev.jxbrowser.internal.ToolkitLibrary;
import com.teamdev.jxbrowser.os.Environment;
import com.teamdev.jxbrowser.view.javafx.internal.window.BeaconWindow;
import com.teamdev.jxbrowser.view.javafx.internal.window.FxPanel;
import com.teamdev.jxbrowser.view.javafx.internal.window.reflection.PlatformWindow;
import java.util.Optional;
import javafx.stage.Window;

public final class NativeAwareWindow {
    private final Window window;
    private Long nativeId;

    public static NativeAwareWindow newInstance(Window window) {
        Preconditions.checkNotNull((Object)window);
        return new NativeAwareWindow(window);
    }

    private NativeAwareWindow(Window window) {
        this.window = window;
        this.nativeId = null;
    }

    public Window toolkitWindow() {
        return this.window;
    }

    public void focusNatively() {
        Preconditions.checkState((boolean)Environment.isWindows());
        if (this.window.isShowing() && this.window.isFocused()) {
            ToolkitLibrary.instance().focusHWND(this.nativeId());
        }
    }

    public long nativeId() {
        return this.findNativeId().orElseThrow(() -> new IllegalStateException("Failed to get native widget ID"));
    }

    public Optional<Long> findNativeId() {
        if (this.nativeId == null) {
            this.discoverNativeId().ifPresent(id -> {
                this.nativeId = id;
            });
        }
        return Optional.ofNullable(this.nativeId);
    }

    private Optional<Long> discoverNativeId() {
        Preconditions.checkState((boolean)this.window.isShowing(), (Object)"Window must be shown");
        Optional<Long> awtWindowHandle = FxPanel.findFor(this.window).flatMap(FxPanel::awtWindowId);
        if (awtWindowHandle.isPresent()) {
            return awtWindowHandle;
        }
        if (this.isScalingSupportLimited() || SystemProperties.hasProperty((String)"jxbrowser.javafx.legacy.handle")) {
            return this.getHandleFromInternalApi();
        }
        return BeaconWindow.findOwnerId(this.window);
    }

    private Optional<Long> getHandleFromInternalApi() {
        Optional<PlatformWindow> platformWindow = PlatformWindow.from(this.window);
        if (Environment.isMac()) {
            return platformWindow.flatMap(PlatformWindow::getNativeView);
        }
        if (Environment.isWindows() && Environment.isJre8()) {
            return platformWindow.flatMap(PlatformWindow::getNativeHandle);
        }
        return platformWindow.flatMap(PlatformWindow::getNativeWindow);
    }

    private boolean isScalingSupportLimited() {
        return Environment.isJre8();
    }
}

