/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.javafx.internal.window.reflection;

import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import com.teamdev.jxbrowser.internal.reflect.AccessibleObjects;
import com.teamdev.jxbrowser.internal.reflect.Classes;
import com.teamdev.jxbrowser.internal.reflect.Fields;
import com.teamdev.jxbrowser.internal.reflect.Methods;
import com.teamdev.jxbrowser.os.Environment;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Optional;
import javafx.stage.Window;

public final class TkStage {
    private static final String TK_STAGE_FQN = "com.sun.javafx.tk.TKStage";
    private static final String EMBEDDED_STAGE_FQN = "com.sun.javafx.tk.quantum.EmbeddedStage";
    private static final String WINDOW_HELPER = "com.sun.javafx.stage.WindowHelper";
    private final Object tkStage;

    public static TkStage from(Window window) {
        if (Environment.isJre8()) {
            Method implGetPeer = Methods.getMethod(Window.class, (String)"impl_getPeer", (Class[])new Class[0]);
            return new TkStage(Methods.invoke((Object)window, (Method)implGetPeer, (Object[])new Object[0]));
        }
        Method getPeer = Methods.getMethod((String)WINDOW_HELPER, (String)"getPeer", (Class[])new Class[]{Window.class});
        return new TkStage(Methods.invokeStatic((Method)getPeer, (Object[])new Object[]{window}));
    }

    private TkStage(Object tkStage) {
        this.tkStage = tkStage;
    }

    long getRawHandle() {
        Preconditions.checkState((!Environment.isJre8() ? 1 : 0) != 0);
        Method getRawHandle = Methods.getMethod((String)TK_STAGE_FQN, (String)"getRawHandle", (Class[])new Class[0]);
        return (Long)Methods.invoke((Object)this.tkStage, (Method)getRawHandle, (Object[])new Object[0]);
    }

    Optional<Object> getPlatformWindow() {
        Preconditions.checkState((boolean)Environment.isJre8());
        Method getPlatformWindow = Methods.getMethod(this.tkStage.getClass(), (String)"getPlatformWindow", (Class[])new Class[0]);
        AccessibleObjects.makeAccessible((AccessibleObject)getPlatformWindow);
        return Optional.ofNullable(Methods.invoke((Object)this.tkStage, (Method)getPlatformWindow, (Object[])new Object[0]));
    }

    public boolean isEmbedded() {
        Class embeddedStageClass = Classes.forName((String)EMBEDDED_STAGE_FQN);
        return embeddedStageClass.isInstance(this.tkStage);
    }

    public Object getHost() {
        if (Environment.isJre8()) {
            Method getHost = Methods.getMethod((String)EMBEDDED_STAGE_FQN, (String)"getHost", (Class[])new Class[0]);
            return Methods.invoke((Object)this.tkStage, (Method)getHost, (Object[])new Object[0]);
        }
        Field hostField = Fields.declaredField((String)EMBEDDED_STAGE_FQN, (String)"host");
        AccessibleObjects.makeAccessible((AccessibleObject)hostField);
        return Fields.value((Object)this.tkStage, (Field)hostField);
    }
}

