/*
 * Decompiled with CFR 0.152.
 */
package org.romstation.application;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import javafx.fxml.FXML;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.stage.DirectoryChooser;
import javafx.stage.FileChooser;
import javafx.util.StringConverter;
import javafx.util.converter.IntegerStringConverter;
import javax.persistence.EntityManager;
import org.romstation.application.RomStation;
import org.romstation.application.b;
import org.romstation.application.database.entity.Developer;
import org.romstation.application.database.entity.Game;
import org.romstation.application.database.entity.GameFile;
import org.romstation.application.database.entity.Genre;
import org.romstation.application.database.entity.I18n;
import org.romstation.application.database.entity.Image;
import org.romstation.application.database.entity.Language;
import org.romstation.application.database.entity.Link;
import org.romstation.application.database.entity.Publisher;
import org.romstation.application.database.entity.Series;
import org.romstation.application.database.entity.System;
import org.romstation.application.database.entity.Tag;
import org.romstation.application.database.entity.Translation;
import org.romstation.application.view.control.ApplicationFXMLDialog;
import org.romstation.application.view.control.DeveloperComboBox;
import org.romstation.application.view.control.PathField;
import org.romstation.application.view.control.PublisherComboBox;
import org.romstation.application.view.control.SystemComboBox;
import org.romstation.application.view.controller.GameFilesPaneController;
import org.romstation.application.view.controller.GenresPaneController;
import org.romstation.application.view.controller.LanguagesPaneController;
import org.romstation.application.view.controller.LinksPaneController;
import org.romstation.application.view.controller.MetasPaneController;
import org.romstation.application.view.controller.SeriesPaneController;
import org.romstation.application.view.controller.TagsPaneController;
import org.romstation.application.view.controller.TranslationsPaneController;

public class aZ
extends ApplicationFXMLDialog<Game> {
    private final Game a;
    private TextFormatter<Integer> b;
    private TextFormatter<Integer> c;
    @FXML
    private ScrollPane scrollPane;
    @FXML
    private TextField titleTextField;
    @FXML
    private SystemComboBox systemComboBox;
    @FXML
    private TextField playersTextField;
    @FXML
    private TextField yearTextField;
    @FXML
    private DeveloperComboBox developerComboBox;
    @FXML
    private PublisherComboBox publisherComboBox;
    @FXML
    private PathField graphicPathField;
    @FXML
    private PathField gameDirectoryPathField;
    @FXML
    private GenresPaneController genresController;
    @FXML
    private LanguagesPaneController languagesController;
    @FXML
    private TranslationsPaneController descriptionController;
    @FXML
    private SeriesPaneController seriesController;
    @FXML
    private TagsPaneController tagsController;
    @FXML
    private LinksPaneController linksController;
    @FXML
    private MetasPaneController metasController;
    @FXML
    private GameFilesPaneController gameFilesController;
    @FXML
    private ResourceBundle resources;

    public aZ(Game game) {
        this.a = game;
        this.load(((Object)((Object)this)).getClass().getResource("/fxml/dialog/editor/game/gameEditorDialog.fxml"));
    }

    @FXML
    private void initialize() {
        EntityManager entityManager = org.romstation.application.b.c();
        this.titleTextField.setText(this.a.getTitle());
        this.systemComboBox.getComboBox().getItems().addAll((Collection)entityManager.createNamedQuery("System.findAll", System.class).getResultList());
        this.systemComboBox.getComboBox().getSelectionModel().select((Object)this.a.getSystem());
        this.b = new TextFormatter((StringConverter)new IntegerStringConverter(), (Object)this.a.getPlayers());
        this.playersTextField.setTextFormatter(this.b);
        this.c = new TextFormatter((StringConverter)new IntegerStringConverter(), (Object)this.a.getYear());
        this.yearTextField.setTextFormatter(this.c);
        this.developerComboBox.getComboBox().getItems().addAll((Collection)entityManager.createNamedQuery("Developer.findAll", Developer.class).getResultList());
        this.developerComboBox.getComboBox().getSelectionModel().select((Object)this.a.getDeveloper());
        this.publisherComboBox.getComboBox().getItems().addAll((Collection)entityManager.createNamedQuery("Publisher.findAll", Publisher.class).getResultList());
        this.publisherComboBox.getComboBox().getSelectionModel().select((Object)this.a.getPublisher());
        if (this.a.getGraphic() != null) {
            this.graphicPathField.setPath(this.a.getGraphic().getPath());
        }
        this.gameDirectoryPathField.setPath(this.a.getDirectory());
        this.gameDirectoryPathField.setDisable(this.a.isManaged());
        this.genresController.a().getItems().setAll(this.a.getGenres());
        this.languagesController.a().getItems().setAll(this.a.getLanguages());
        this.descriptionController.a(true);
        this.seriesController.a().getItems().setAll(this.a.getSeries());
        this.tagsController.a().getItems().setAll(this.a.getTags());
        this.linksController.a().getItems().setAll(this.a.getLinks());
        this.metasController.a().getItems().setAll(this.a.getMetas().entrySet());
        entityManager.close();
        this.setResizable(true);
    }

    @FXML
    private void selectGraphicPath() {
        Path defaultPath;
        FileChooser fileChooser = new FileChooser();
        if (this.graphicPathField.getPath() != null && Files.exists(defaultPath = Paths.get(this.graphicPathField.getPath(), new String[0]), new LinkOption[0])) {
            fileChooser.setInitialDirectory(defaultPath.getParent().toFile());
            fileChooser.setInitialFileName(defaultPath.toString());
        }
        fileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter(this.resources.getString("gameEditorDialog.image.extensionFilters"), new String[]{"*.bmp", "*.gif", "*.png", "*.jpg"}));
        File path = fileChooser.showOpenDialog(this.scrollPane.getScene().getWindow());
        if (path != null) {
            this.graphicPathField.setPath(path.getPath());
        }
    }

    @FXML
    private void selectGameDirectory() {
        File directoryPath;
        Path defaultPath;
        String path;
        DirectoryChooser directoryChooser = new DirectoryChooser();
        String string = path = this.gameDirectoryPathField.getPath() != null ? this.gameDirectoryPathField.getPath() : this.a.getDirectory();
        if (path != null && Files.exists(defaultPath = Paths.get(path, new String[0]), new LinkOption[0])) {
            directoryChooser.setInitialDirectory(defaultPath.toFile());
        }
        if ((directoryPath = directoryChooser.showDialog(this.scrollPane.getScene().getWindow())) != null) {
            this.gameDirectoryPathField.setPath(directoryPath.toString());
        }
    }

    @Override
    protected Object controllerFactory(Class<?> classType) {
        if (classType == ((Object)((Object)this)).getClass()) {
            return this;
        }
        try {
            if (classType == GameFilesPaneController.class) {
                return classType.getDeclaredConstructor(Game.class).newInstance(this.a);
            }
            if (classType == TranslationsPaneController.class) {
                I18n i18n = this.a.getDescription() == null ? new I18n() : this.a.getDescription();
                return classType.getDeclaredConstructor(I18n.class).newInstance(i18n);
            }
            return classType.newInstance();
        }
        catch (Exception exception) {
            RomStation.b().log(Level.SEVERE, exception.getMessage(), exception);
            return null;
        }
    }

    private void a() {
        this.a.setTitle(this.titleTextField.getText());
        this.a.setSystem((System)this.systemComboBox.getComboBox().getValue());
        this.a.setPlayers((Integer)this.b.getValue());
        this.a.setYear((Integer)this.c.getValue());
        this.a.setDeveloper((Developer)this.developerComboBox.getComboBox().getValue());
        this.a.setPublisher((Publisher)this.publisherComboBox.getComboBox().getValue());
        this.a.setFiles((List<GameFile>)this.gameFilesController.a().getItems());
        this.a.setGenres((List<Genre>)this.genresController.a().getItems());
        this.a.setLanguages((List<Language>)this.languagesController.a().getItems());
        this.a.setLinks((List<Link>)this.linksController.a().getItems());
        this.a.setSeries((List<Series>)this.seriesController.a().getItems());
        this.a.setTags((List<Tag>)this.tagsController.a().getItems());
        if (this.graphicPathField.getPath() == null || this.graphicPathField.getPath().isEmpty()) {
            this.a.setGraphic(null);
        } else {
            this.a.setGraphic(new Image(this.graphicPathField.getPath()));
        }
        this.a.setDirectory(this.gameDirectoryPathField.getPath());
        if (this.descriptionController.d().getItems().isEmpty()) {
            this.a.setDescription(null);
        } else {
            this.a.setDescription(this.descriptionController.a());
            this.a.getDescription().setTranslations((List<Translation>)this.descriptionController.d().getItems());
        }
        this.a.setMetas(this.metasController.b());
    }

    protected Game a(ButtonType buttonType) {
        if (buttonType == ButtonType.OK) {
            this.a();
            return this.a;
        }
        return null;
    }

    @Override
    protected /* synthetic */ Object resultConverter(ButtonType buttonType) {
        return this.a(buttonType);
    }
}

