/*
 * Decompiled with CFR 0.152.
 */
package org.romstation.application;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.logging.Level;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.ButtonType;
import javafx.scene.control.DialogPane;
import javafx.scene.control.TextField;
import javafx.stage.FileChooser;
import org.romstation.application.RomStation;
import org.romstation.application.database.entity.Emulator;
import org.romstation.application.database.entity.EmulatorFile;
import org.romstation.application.database.entity.EmulatorProfile;
import org.romstation.application.database.entity.System;
import org.romstation.application.view.control.ApplicationFXMLDialog;
import org.romstation.application.view.control.PathField;
import org.romstation.application.view.controller.SystemsPaneController;

public class ao
extends ApplicationFXMLDialog<EmulatorFile> {
    private final Emulator a;
    @FXML
    private DialogPane root;
    @FXML
    private TextField nameTextField;
    @FXML
    private PathField pathField;
    @FXML
    private TextField parametersTextField;
    @FXML
    private SystemsPaneController systemsController;

    public ao(Emulator emulator) {
        this.a = emulator;
        this.load(((Object)((Object)this)).getClass().getResource("/fxml/dialog/emulatorFileImportDialog.fxml"));
    }

    @FXML
    private void initialize() {
        this.pathField.getTextField().setEditable(false);
        this.root.lookupButton(ButtonType.OK).disableProperty().bind((ObservableValue)this.nameTextField.textProperty().isEmpty().or((ObservableBooleanValue)this.pathField.getTextField().textProperty().isEmpty()));
    }

    @FXML
    private void selectPath(ActionEvent actionEvent) {
        File path;
        Path defaultPath;
        FileChooser fileChooser = new FileChooser();
        if (this.pathField.getPath() != null && Files.exists(defaultPath = Paths.get(this.pathField.getPath(), new String[0]), new LinkOption[0])) {
            fileChooser.setInitialDirectory(defaultPath.getParent().toFile());
            fileChooser.setInitialFileName(defaultPath.toString());
        }
        if ((path = fileChooser.showOpenDialog(this.getDialogPane().getScene().getWindow())) != null) {
            this.pathField.setPath(path.toString());
        }
    }

    @Override
    protected Object controllerFactory(Class<?> classType) {
        if (classType == ((Object)((Object)this)).getClass()) {
            return this;
        }
        try {
            return classType.newInstance();
        }
        catch (Exception exception) {
            RomStation.b().log(Level.SEVERE, exception.getMessage(), exception);
            return null;
        }
    }

    protected EmulatorFile a(ButtonType buttonType) {
        if (buttonType == ButtonType.OK) {
            EmulatorFile emulatorFile = new EmulatorFile();
            emulatorFile.setEmulator(this.a);
            emulatorFile.setName(this.nameTextField.getText());
            emulatorFile.setDirectory(Paths.get(this.pathField.getPath(), new String[0]).getParent().toString());
            EmulatorProfile defaultProfile = new EmulatorProfile();
            defaultProfile.setEmulatorFile(emulatorFile);
            defaultProfile.setName(emulatorFile.getName());
            defaultProfile.setPath(this.pathField.getPath());
            if (this.systemsController.a().getItems().isEmpty()) {
                defaultProfile.setParameters(this.parametersTextField.getText());
            }
            defaultProfile.setWorkingDirectory("${emulator.file.directory}");
            emulatorFile.getProfiles().add(defaultProfile);
            this.systemsController.a().getItems().forEach(system -> {
                EmulatorProfile systemProfile = new EmulatorProfile();
                systemProfile.setEmulatorFile(emulatorFile);
                systemProfile.setName(system.getName());
                systemProfile.getSystems().add((System)system);
                systemProfile.setPath(this.pathField.getPath());
                systemProfile.setParameters(this.parametersTextField.getText());
                systemProfile.setWorkingDirectory("${emulator.file.directory}");
                emulatorFile.getProfiles().add(systemProfile);
            });
            return emulatorFile;
        }
        return null;
    }

    @Override
    protected /* synthetic */ Object resultConverter(ButtonType buttonType) {
        return this.a(buttonType);
    }
}

