/*
 * Decompiled with CFR 0.152.
 */
package org.romstation.application;

import com.google.common.eventbus.Subscribe;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.stream.Collectors;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.Alert;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javax.persistence.EntityManager;
import org.romstation.application.RomStation;
import org.romstation.application.b;
import org.romstation.application.bL;
import org.romstation.application.bW;
import org.romstation.application.database.entity.Locale;
import org.romstation.application.io.a;
import org.romstation.application.view.control.ApplicationAlert;
import org.romstation.application.view.controller.ApplicationView;

public class bI {
    @FXML
    private ComboBox<Locale> localeComboBox;
    @FXML
    private ComboBox<String> themeComboBox;
    @FXML
    private ComboBox<ApplicationView> startScreenComboBox;
    @FXML
    private CheckBox confirmExitCheckBox;
    @FXML
    private ResourceBundle resources;

    @FXML
    private void initialize() {
        bL.a.register((Object)this);
        EntityManager entityManager = b.c();
        List locales = entityManager.createNamedQuery("Locale.findAllOrdered", Locale.class).setParameter("tag", (Object)RomStation.c().getProperty("application.locale")).getResultList();
        entityManager.close();
        this.localeComboBox.getItems().addAll((Collection)locales);
        Locale defaultLocale = locales.stream().filter(locale -> locale.getTag().equals(RomStation.c().getProperty("application.locale"))).findFirst().orElse((Locale)locales.get(0));
        this.localeComboBox.setValue((Object)defaultLocale);
        try {
            List themes = Files.list(Paths.get("themes", new String[0])).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).map(path -> path.getFileName().toString()).collect(Collectors.toList());
            this.themeComboBox.getItems().addAll(themes);
        }
        catch (IOException exception) {
            RomStation.b().log(Level.WARNING, exception.getMessage(), exception);
        }
        this.themeComboBox.setValue((Object)RomStation.c().getProperty("application.theme"));
        this.startScreenComboBox.getItems().addAll((Object[])new ApplicationView[]{ApplicationView.BROWSER, ApplicationView.LIBRARY, ApplicationView.EMULATORS, ApplicationView.DATABASE});
        this.startScreenComboBox.setValue((Object)ApplicationView.valueOf(RomStation.c().getProperty("application.startScreen")));
        this.confirmExitCheckBox.setSelected(Boolean.parseBoolean(RomStation.c().getProperty("application.confirmExit")));
    }

    @Subscribe
    private void a(bW event) {
        RomStation.c().setProperty("application.locale", ((Locale)this.localeComboBox.getValue()).getTag());
        RomStation.c().setProperty("application.theme", (String)this.themeComboBox.getValue());
        RomStation.c().setProperty("application.startScreen", ((ApplicationView)((Object)this.startScreenComboBox.getValue())).name());
        RomStation.c().setProperty("application.confirmExit", String.valueOf(this.confirmExitCheckBox.isSelected()));
    }

    @FXML
    private void clearApplicationCache(ActionEvent actionEvent) {
        try {
            a.a(Paths.get("cache", new String[0]));
        }
        catch (IOException exception) {
            RomStation.b().log(Level.WARNING, exception.getMessage(), exception);
        }
        ApplicationAlert alert = new ApplicationAlert(Alert.AlertType.INFORMATION);
        alert.setHeaderText(this.resources.getString("settings.dialog.header"));
        alert.setContentText(this.resources.getString("settings.dialog.application.cache.clear.alert"));
        alert.showAndWait();
    }
}

