/*
 * Decompiled with CFR 0.152.
 */
package org.romstation.application.database.entity;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.CascadeType;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToOne;
import javax.persistence.MapKeyColumn;
import javax.persistence.OneToMany;
import javax.persistence.PostPersist;
import javax.persistence.PostRemove;
import javax.persistence.PostUpdate;
import javax.persistence.PrePersist;
import javax.persistence.PreRemove;
import javax.persistence.PreUpdate;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.jruby.Ruby;
import org.jruby.RubyObject;
import org.jruby.javasupport.JavaUtil;
import org.romstation.application.N;
import org.romstation.application.RomStation;
import org.romstation.application.database.entity.EmulatorFile;
import org.romstation.application.database.entity.Script;
import org.romstation.application.database.entity.System;
import org.romstation.application.database.entity.a;

@Entity
@Table(name="EMULATOR_PROFILE")
@Access(value=AccessType.PROPERTY)
public class EmulatorProfile
extends a {
    private String a;
    private String b;
    private String c;
    private String d;
    private EmulatorFile e;
    private List<System> f = new LinkedList<System>();
    private List<Script> g = new LinkedList<Script>();
    private Map<String, String> h = new HashMap<String, String>();

    public EmulatorProfile() {
    }

    public EmulatorProfile(EmulatorProfile entity) {
        this.a = entity.getName();
        this.e = entity.getEmulatorFile();
        this.d = entity.getParameters();
        this.c = entity.getWorkingDirectory();
        this.b = entity.getPath();
        this.f.addAll(entity.getSystems());
        this.h.putAll(entity.getMetas());
        this.g.addAll(entity.getScripts());
    }

    @Override
    @Id
    @SequenceGenerator(name="EMULATOR_PROFILE_GENERATOR", sequenceName="EMULATOR_PROFILE_SEQUENCE", allocationSize=1)
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="EMULATOR_PROFILE_GENERATOR")
    public Integer getId() {
        return super.getId();
    }

    public String getName() {
        return this.a;
    }

    public void setName(String name) {
        this.a = name;
    }

    public String getPath() {
        return this.b;
    }

    public void setPath(String path) {
        this.b = path;
    }

    @Column(name="WORKING_DIRECTORY")
    public String getWorkingDirectory() {
        return this.c;
    }

    public void setWorkingDirectory(String workingDirectory) {
        this.c = workingDirectory;
    }

    public String getParameters() {
        return this.d;
    }

    public void setParameters(String parameters) {
        this.d = parameters;
    }

    @ManyToOne(cascade={CascadeType.PERSIST, CascadeType.MERGE})
    @JoinColumn(name="EMULATOR_FILE_ID")
    public EmulatorFile getEmulatorFile() {
        return this.e;
    }

    public void setEmulatorFile(EmulatorFile emulatorFile) {
        this.e = emulatorFile;
    }

    @OneToMany(cascade={CascadeType.PERSIST, CascadeType.MERGE})
    @JoinTable(joinColumns={@JoinColumn(name="EMULATOR_PROFILE_ID")}, inverseJoinColumns={@JoinColumn(name="SYSTEM_ID")})
    public List<System> getSystems() {
        return this.f;
    }

    public void setSystems(List<System> systems) {
        this.f = systems;
    }

    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true)
    @JoinTable(joinColumns={@JoinColumn(name="EMULATOR_PROFILE_ID")}, inverseJoinColumns={@JoinColumn(name="SCRIPT_ID")})
    public List<Script> getScripts() {
        return this.g;
    }

    public void setScripts(List<Script> scripts) {
        this.g = scripts;
    }

    @ElementCollection
    @MapKeyColumn(name="\"KEY\"")
    @Column(name="VALUE", length=32672)
    @CollectionTable(name="EMULATOR_PROFILE_META", joinColumns={@JoinColumn(name="EMULATOR_PROFILE_ID")})
    public Map<String, String> getMetas() {
        return this.h;
    }

    public void setMetas(Map<String, String> meta) {
        this.h = meta;
    }

    @PrePersist
    private void prePersist() {
        for (Script script : this.getScripts()) {
            try {
                RubyObject rubyObject = N.a(script);
                if (!rubyObject.respondsTo("on_pre_persist")) continue;
                rubyObject.callMethod("on_pre_persist", JavaUtil.convertJavaToRuby((Ruby)rubyObject.getRuntime(), (Object)this));
            }
            catch (Exception exception) {
                RomStation.b().log(Level.WARNING, exception.getMessage(), exception);
            }
        }
        if (N.a().database.emulator_profile.on_pre_persist != null) {
            N.a().database.emulator_profile.on_pre_persist.accept(this);
        }
    }

    @PostPersist
    private void postPersist() {
        for (Script script : this.getScripts()) {
            try {
                RubyObject rubyObject = N.a(script);
                if (!rubyObject.respondsTo("on_post_persist")) continue;
                rubyObject.callMethod("on_post_persist", JavaUtil.convertJavaToRuby((Ruby)rubyObject.getRuntime(), (Object)this));
            }
            catch (Exception exception) {
                RomStation.b().log(Level.WARNING, exception.getMessage(), exception);
            }
        }
        if (N.a().database.emulator_profile.on_post_persist != null) {
            N.a().database.emulator_profile.on_post_persist.accept(this);
        }
    }

    @PreUpdate
    private void preUpdate() {
        for (Script script : this.getScripts()) {
            try {
                RubyObject rubyObject = N.a(script);
                if (!rubyObject.respondsTo("on_pre_update")) continue;
                rubyObject.callMethod("on_pre_update", JavaUtil.convertJavaToRuby((Ruby)rubyObject.getRuntime(), (Object)this));
            }
            catch (Exception exception) {
                RomStation.b().log(Level.WARNING, exception.getMessage(), exception);
            }
        }
        if (N.a().database.emulator_profile.on_pre_update != null) {
            N.a().database.emulator_profile.on_pre_update.accept(this);
        }
    }

    @PostUpdate
    private void postUpdate() {
        for (Script script : this.getScripts()) {
            try {
                RubyObject rubyObject = N.a(script);
                if (!rubyObject.respondsTo("on_post_update")) continue;
                rubyObject.callMethod("on_post_update", JavaUtil.convertJavaToRuby((Ruby)rubyObject.getRuntime(), (Object)this));
            }
            catch (Exception exception) {
                RomStation.b().log(Level.WARNING, exception.getMessage(), exception);
            }
        }
        if (N.a().database.emulator_profile.on_post_update != null) {
            N.a().database.emulator_profile.on_post_update.accept(this);
        }
    }

    @PreRemove
    private void preRemove() {
        for (Script script : this.getScripts()) {
            try {
                RubyObject rubyObject = N.a(script);
                if (!rubyObject.respondsTo("on_pre_remove")) continue;
                rubyObject.callMethod("on_pre_remove", JavaUtil.convertJavaToRuby((Ruby)rubyObject.getRuntime(), (Object)this));
            }
            catch (Exception exception) {
                RomStation.b().log(Level.WARNING, exception.getMessage(), exception);
            }
        }
        if (N.a().database.emulator_profile.on_pre_remove != null) {
            N.a().database.emulator_profile.on_pre_remove.accept(this);
        }
    }

    @PostRemove
    private void postRemove() {
        for (Script script : this.getScripts()) {
            try {
                RubyObject rubyObject = N.a(script);
                if (!rubyObject.respondsTo("on_post_remove")) continue;
                rubyObject.callMethod("on_post_remove", JavaUtil.convertJavaToRuby((Ruby)rubyObject.getRuntime(), (Object)this));
            }
            catch (Exception exception) {
                RomStation.b().log(Level.WARNING, exception.getMessage(), exception);
            }
        }
        if (N.a().database.emulator_profile.on_post_remove != null) {
            N.a().database.emulator_profile.on_post_remove.accept(this);
        }
    }

    public String toString() {
        return "[" + this.getId() + "] " + this.a;
    }
}

