/*
 * Decompiled with CFR 0.152.
 */
package org.romstation.application.netplay;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.net.MalformedURLException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Base64;
import java.util.List;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.stream.StreamSupport;
import javafx.application.Platform;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.stage.Modality;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import org.romstation.application.C;
import org.romstation.application.D;
import org.romstation.application.E;
import org.romstation.application.K;
import org.romstation.application.L;
import org.romstation.application.RomStation;
import org.romstation.application.ag;
import org.romstation.application.an;
import org.romstation.application.ar;
import org.romstation.application.at;
import org.romstation.application.av;
import org.romstation.application.bG;
import org.romstation.application.bg;
import org.romstation.application.bj;
import org.romstation.application.bl;
import org.romstation.application.bm;
import org.romstation.application.bv;
import org.romstation.application.cS;
import org.romstation.application.cU;
import org.romstation.application.database.entity.EmulatorFile;
import org.romstation.application.database.entity.GameFile;
import org.romstation.application.netplay.AlreadyConnectedException;
import org.romstation.application.netplay.a;
import org.romstation.application.netplay.c;
import org.romstation.application.network.InvalidServerResponseException;
import org.romstation.application.network.NetworkOfflineException;
import org.romstation.application.network.ServerResponseException;
import org.romstation.application.network.d;
import org.romstation.application.network.f;
import org.romstation.application.network.g;
import org.romstation.application.task.EmulatorFileDownloadContextException;
import org.romstation.application.task.e;
import org.romstation.application.task.h;
import org.romstation.application.task.i;
import org.romstation.application.task.o;
import org.romstation.application.task.p;
import org.romstation.application.task.u;
import org.romstation.application.task.w;
import org.romstation.application.view.control.ApplicationAlert;
import org.romstation.application.view.control.ServerErrorAlert;
import org.romstation.application.view.controller.RomStationController;
import org.romstation.application.vpn.tap.TAPDriverInstallException;

public class b {
    private static final ReadOnlyBooleanWrapper a = new ReadOnlyBooleanWrapper();
    private static final ReadOnlyStringWrapper b = new ReadOnlyStringWrapper();

    public static ReadOnlyBooleanProperty a() {
        return a.getReadOnlyProperty();
    }

    public static boolean b() {
        return a.get();
    }

    public static ReadOnlyStringWrapper c() {
        return b;
    }

    public static String d() {
        return b.get();
    }

    private static Optional<d> a(bv type) {
        return org.romstation.application.netplay.b.a(0, null, type, 0);
    }

    private static Optional<d> a(GameFile gameFile, bv type) {
        return org.romstation.application.netplay.b.a((int)gameFile.getRid(), gameFile.getGame().getTitle(), type, 0);
    }

    private static Optional<d> a(int gameFileId, String title, bv type, int masterLobbyID) {
        bg createServerDialog = new bg(gameFileId, title, type, masterLobbyID);
        Optional serverConfig = createServerDialog.showAndWait();
        if (serverConfig.isPresent()) {
            e task = new e((c)serverConfig.get());
            av<d> taskDialog = new av<d>(task);
            new Thread((Runnable)((Object)task)).start();
            return taskDialog.showAndWait();
        }
        return Optional.empty();
    }

    public static void e() {
        try {
            org.romstation.application.netplay.b.m();
            org.romstation.application.netplay.b.l();
            org.romstation.application.netplay.b.a(bv.MANUAL).ifPresent(serverResponse -> {
                JsonObject lobby = serverResponse.b().getAsJsonObject("lobby");
                int lobbyID = lobby.get("id").getAsInt();
                String password = lobby.get("password").isJsonNull() ? null : lobby.get("password").getAsString();
                org.romstation.application.netplay.b.a(lobbyID, password);
            });
        }
        catch (UnsupportedOperationException exception) {
            org.romstation.application.netplay.b.o();
        }
        catch (AlreadyConnectedException exception) {
            org.romstation.application.netplay.b.n();
        }
    }

    public static void f() {
        try {
            org.romstation.application.netplay.b.l();
            bl gameChoiceDialog = new bl(bv.CLOUD);
            gameChoiceDialog.showAndWait().ifPresent(gameId -> {
                try {
                    JsonObject game = org.romstation.application.netplay.b.c((int)gameId);
                    org.romstation.application.netplay.b.a(game, true).ifPresent(gameFile -> org.romstation.application.netplay.b.a(gameFile.get("file_id").getAsInt(), game.get("title").getAsString(), bv.CLOUD, 0).ifPresent(serverResponse -> {
                        JsonObject lobby = serverResponse.b().getAsJsonObject("lobby");
                        int lobbyID = lobby.get("id").getAsInt();
                        String password = lobby.get("password").isJsonNull() ? null : lobby.get("password").getAsString();
                        org.romstation.application.netplay.b.a(lobbyID, password);
                    }));
                }
                catch (MalformedURLException | InvalidServerResponseException exception) {
                    RomStation.b().log(Level.SEVERE, exception.getMessage(), exception);
                }
                catch (ServerResponseException exception) {
                    RomStation.b().log(Level.SEVERE, exception.getMessage(), exception);
                    ServerErrorAlert alert = new ServerErrorAlert(exception);
                    alert.showAndWait();
                }
                catch (NetworkOfflineException exception) {
                    RomStation.b().log(Level.WARNING, exception.getMessage(), exception);
                }
            });
        }
        catch (AlreadyConnectedException exception) {
            org.romstation.application.netplay.b.n();
        }
    }

    public static void a(int gameId, int gameFileId) {
        try {
            org.romstation.application.netplay.b.l();
            try {
                JsonObject game = org.romstation.application.netplay.b.c(gameId);
                org.romstation.application.netplay.b.a(game, gameFileId).ifPresent(gameFile -> org.romstation.application.netplay.b.a(gameFile.get("file_id").getAsInt(), game.get("title").getAsString(), bv.CLOUD, 0).ifPresent(serverResponse -> {
                    JsonObject lobby = serverResponse.b().getAsJsonObject("lobby");
                    int lobbyID = lobby.get("id").getAsInt();
                    String password = lobby.get("password").isJsonNull() ? null : lobby.get("password").getAsString();
                    org.romstation.application.netplay.b.a(lobbyID, password);
                }));
            }
            catch (MalformedURLException | InvalidServerResponseException exception) {
                RomStation.b().log(Level.SEVERE, exception.getMessage(), exception);
            }
            catch (ServerResponseException exception) {
                RomStation.b().log(Level.SEVERE, exception.getMessage(), exception);
                ServerErrorAlert alert = new ServerErrorAlert(exception);
                alert.showAndWait();
            }
            catch (NetworkOfflineException exception) {
                RomStation.b().log(Level.WARNING, exception.getMessage(), exception);
            }
        }
        catch (AlreadyConnectedException exception) {
            org.romstation.application.netplay.b.n();
        }
    }

    public static void g() {
        try {
            org.romstation.application.netplay.b.m();
            org.romstation.application.netplay.b.l();
            bl dialog = new bl(bv.AUTOMATIC);
            dialog.showAndWait().ifPresent(gameID -> org.romstation.application.netplay.b.a((int)gameID, b::a));
        }
        catch (UnsupportedOperationException exception) {
            org.romstation.application.netplay.b.o();
        }
        catch (AlreadyConnectedException exception) {
            org.romstation.application.netplay.b.n();
        }
    }

    private static void a(GameFile gameFile) {
        try {
            org.romstation.application.netplay.b.l();
            Optional<EmulatorFile> entity = org.romstation.application.netplay.b.h(gameFile.getGame().getSystem().getRid());
            entity.ifPresent(emulatorFile -> org.romstation.application.netplay.b.a(gameFile, bv.AUTOMATIC).ifPresent(serverResponse -> {
                JsonObject lobby = serverResponse.b().getAsJsonObject("lobby");
                int lobbyID = lobby.get("id").getAsInt();
                String password = lobby.get("password").isJsonNull() ? null : lobby.get("password").getAsString();
                org.romstation.application.netplay.b.a(lobbyID, password, gameFile, emulatorFile);
            }));
        }
        catch (AlreadyConnectedException exception) {
            org.romstation.application.netplay.b.n();
        }
    }

    public static void h() {
        bj dialog = new bj();
        dialog.showAndWait().ifPresent(id -> {
            org.romstation.application.task.d task = new org.romstation.application.task.d((int)id);
            av<d> taskDialog = new av<d>(task);
            new Thread((Runnable)((Object)task)).start();
            taskDialog.showAndWait().ifPresent(serverResponse -> RomStationController.a.post((Object)new cS(org.romstation.application.network.b.b() + serverResponse.b().getAsJsonObject("server").get("url").getAsString())));
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void a(int lobbyID) {
        try {
            String password;
            org.romstation.application.netplay.b.l();
            f urlBuilder = new f(org.romstation.application.network.b.b() + "/romstation/scripts/multiplayer/get_lobby_infos.php");
            urlBuilder.a().a("v", 229);
            g urlQuery = new g().a("auth", ag.a().f()).a("lobby_id", lobbyID).a("os", E.c().a()).a("arch", E.d().a());
            org.romstation.application.network.a httpRequest = new org.romstation.application.network.a(urlBuilder.b());
            d serverResponse = httpRequest.a(urlQuery);
            JsonObject lobby = serverResponse.b().getAsJsonObject("lobby");
            if (lobby.get("password").getAsBoolean()) {
                at dialog = new at(RomStation.d().getString("netplayServerPasswordAlert.header"));
                Optional result = dialog.showAndWait();
                if (!result.isPresent()) return;
                org.romstation.application.netplay.b.c(lobbyID, (String)result.get());
                password = (String)result.get();
            } else {
                password = null;
            }
            switch (bv.a(lobby.get("type").getAsInt())) {
                case MANUAL: {
                    org.romstation.application.netplay.b.m();
                    org.romstation.application.netplay.b.a(lobby, password);
                    return;
                }
                case CLOUD: {
                    org.romstation.application.netplay.b.b(lobby, password);
                    return;
                }
                case AUTOMATIC: 
                case AUTOMATIC_VPN: {
                    org.romstation.application.netplay.b.m();
                    org.romstation.application.netplay.b.c(lobby, password);
                }
            }
            return;
        }
        catch (MalformedURLException | InvalidServerResponseException exception) {
            RomStation.b().log(Level.SEVERE, exception.getMessage(), exception);
            return;
        }
        catch (ServerResponseException exception) {
            RomStation.b().log(Level.SEVERE, exception.getMessage(), exception);
            ServerErrorAlert alert = new ServerErrorAlert(exception);
            alert.showAndWait();
            return;
        }
        catch (NetworkOfflineException exception) {
            RomStation.b().log(Level.WARNING, exception.getMessage(), exception);
            return;
        }
        catch (UnsupportedOperationException exception) {
            org.romstation.application.netplay.b.o();
            return;
        }
        catch (AlreadyConnectedException exception) {
            org.romstation.application.netplay.b.n();
        }
    }

    private static void a(JsonObject lobby, String password) {
        org.romstation.application.netplay.b.a(lobby.get("id").getAsInt(), password);
    }

    private static void b(JsonObject lobby, String password) {
        try {
            org.romstation.application.netplay.b.l();
            int lobbyID = lobby.get("id").getAsInt();
            if (lobby.get("linked").getAsBoolean()) {
                org.romstation.application.netplay.b.a(lobby.get("game_file_id").getAsInt(), null, bv.CLOUD, lobbyID).ifPresent(serverResponse -> org.romstation.application.netplay.b.a(lobbyID, password));
            } else {
                org.romstation.application.netplay.b.a(lobby.get("id").getAsInt(), password);
            }
        }
        catch (AlreadyConnectedException exception) {
            org.romstation.application.netplay.b.n();
        }
    }

    private static void c(JsonObject lobby, String password) {
        org.romstation.application.netplay.b.a(lobby.get("game_id").getAsInt(), lobby.get("game_file_id").getAsInt(), (GameFile gameFile) -> org.romstation.application.netplay.b.a(lobby, password, gameFile));
    }

    private static void a(JsonObject lobby, String password, GameFile gameFile) {
        try {
            org.romstation.application.netplay.b.l();
            Optional<EmulatorFile> entity = org.romstation.application.netplay.b.h(gameFile.getGame().getSystem().getRid());
            entity.ifPresent(emulatorFile -> org.romstation.application.netplay.b.a(lobby.get("id").getAsInt(), password, gameFile, emulatorFile));
        }
        catch (AlreadyConnectedException exception) {
            org.romstation.application.netplay.b.n();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void a(int id, boolean hasPassword) {
        try {
            String password;
            org.romstation.application.netplay.b.l();
            f urlBuilder = new f(org.romstation.application.network.b.b() + "/romstation/scripts/multiplayer/get_dedicated_infos.php");
            urlBuilder.a().a("v", 229);
            g urlQuery = new g().a("auth", ag.a().f()).a("server_id", id).a("os", E.c().a()).a("arch", E.d().a());
            org.romstation.application.network.a httpRequest = new org.romstation.application.network.a(urlBuilder.b());
            d serverResponse = httpRequest.a(urlQuery);
            JsonObject dedicatedServer = serverResponse.b().getAsJsonObject("dedicated");
            if (dedicatedServer.get("password").getAsBoolean()) {
                at dialog = new at(RomStation.d().getString("netplayServerPasswordAlert.header"));
                Optional result = dialog.showAndWait();
                if (!result.isPresent()) return;
                org.romstation.application.netplay.b.a(id, (String)result.get(), true);
                password = (String)result.get();
            } else {
                password = null;
            }
            if (dedicatedServer.get("game_file_id").getAsInt() == 0) {
                org.romstation.application.netplay.b.d(dedicatedServer, password);
                return;
            } else {
                org.romstation.application.netplay.b.m();
                org.romstation.application.netplay.b.a(dedicatedServer.get("game_id").getAsInt(), dedicatedServer.get("game_file_id").getAsInt(), (GameFile gameFile) -> org.romstation.application.netplay.b.b(dedicatedServer, password, gameFile));
            }
            return;
        }
        catch (MalformedURLException | InvalidServerResponseException exception) {
            RomStation.b().log(Level.SEVERE, exception.getMessage(), exception);
            return;
        }
        catch (ServerResponseException exception) {
            RomStation.b().log(Level.SEVERE, exception.getMessage(), exception);
            ServerErrorAlert alert = new ServerErrorAlert(exception);
            alert.showAndWait();
            return;
        }
        catch (NetworkOfflineException exception) {
            RomStation.b().log(Level.WARNING, exception.getMessage(), exception);
            return;
        }
        catch (UnsupportedOperationException exception) {
            org.romstation.application.netplay.b.o();
            return;
        }
        catch (AlreadyConnectedException exception) {
            org.romstation.application.netplay.b.n();
        }
    }

    private static void d(JsonObject dedicatedServer, String password) {
        org.romstation.application.netplay.b.a(dedicatedServer, password, null, null);
    }

    private static void b(JsonObject dedicatedServer, String password, GameFile gameFile) {
        try {
            org.romstation.application.netplay.b.l();
            Optional<EmulatorFile> entity = org.romstation.application.netplay.b.h(gameFile.getGame().getSystem().getRid());
            entity.ifPresent(emulatorFile -> org.romstation.application.netplay.b.a(dedicatedServer, password, gameFile, emulatorFile));
        }
        catch (AlreadyConnectedException exception) {
            org.romstation.application.netplay.b.n();
        }
    }

    private static void a(JsonObject dedicatedServer, String password, GameFile gameFile, EmulatorFile emulatorFile) {
        w task = new w(dedicatedServer.get("id").getAsInt(), password);
        av<d> dialog = new av<d>(task);
        new Thread((Runnable)((Object)task)).start();
        dialog.showAndWait().ifPresent(serverResponse -> {
            JsonObject lobby = serverResponse.b().getAsJsonObject("lobby");
            org.romstation.application.netplay.b.a(lobby.get("id").getAsInt(), password, gameFile, emulatorFile);
        });
    }

    private static void a(int lobbyID, String password) {
        org.romstation.application.netplay.b.a(lobbyID, password, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void a(int lobbyID, String password, GameFile gameFile, EmulatorFile emulatorFile) {
        boolean success = false;
        a credential = null;
        try {
            credential = org.romstation.application.netplay.b.b(lobbyID, password).orElse(null);
            if (credential != null) {
                org.romstation.application.netplay.b.a(lobbyID, credential, gameFile, emulatorFile);
                success = true;
            }
        }
        catch (IOException | InvalidServerResponseException exception) {
            RomStation.b().log(Level.SEVERE, exception.getMessage(), exception);
        }
        catch (TAPDriverInstallException exception) {
            RomStation.b().log(Level.SEVERE, exception.getMessage(), exception);
            Platform.runLater(() -> {
                ApplicationAlert alert = new ApplicationAlert(RomStation.d().getString("tapDeviceInstallErrorAlert.header"), RomStation.d().getString("tapDeviceInstallErrorAlert.content"), Alert.AlertType.ERROR);
                alert.showAndWait();
            });
        }
        catch (ServerResponseException exception) {
            RomStation.b().log(Level.SEVERE, exception.getMessage(), exception);
            Platform.runLater(() -> {
                ServerErrorAlert alert = new ServerErrorAlert(exception);
                alert.showAndWait();
            });
        }
        catch (NetworkOfflineException exception) {
            RomStation.b().log(Level.WARNING, exception.getMessage(), exception);
        }
        finally {
            if (!success) {
                org.romstation.application.netplay.b.b(lobbyID);
                if (credential != null && credential.b() != null && credential.b().e()) {
                    try {
                        credential.b().f();
                    }
                    catch (IOException exception) {
                        RomStation.b().log(Level.SEVERE, exception.getMessage(), exception);
                    }
                }
            }
        }
    }

    private static Optional<a> b(int lobbyID, String password) throws IOException, TAPDriverInstallException {
        u task = new u(lobbyID, password);
        av<d> taskDialog = new av<d>(task);
        new Thread((Runnable)((Object)task)).start();
        d serverResponse = taskDialog.showAndWait().orElse(null);
        if (serverResponse != null) {
            JsonObject credential = serverResponse.b().getAsJsonObject("credential");
            if (credential.get("vpn").getAsBoolean()) {
                String guid = org.romstation.application.netplay.b.i().orElse(null);
                if (guid == null) {
                    ApplicationAlert alert = new ApplicationAlert(RomStation.d().getString("tapDeviceInstallAlert.header"), RomStation.d().getString("tapDeviceInstallAlert.content"), Alert.AlertType.CONFIRMATION);
                    Optional result = alert.showAndWait();
                    if (result.isPresent() && result.get() == ButtonType.OK) {
                        L device = org.romstation.application.vpn.tap.a.a();
                        guid = org.romstation.application.vpn.tap.a.a(device.a());
                        RomStation.c().setProperty("tapDevice.id", device.a());
                        RomStation.c().setProperty("tapDevice.guid", guid);
                    } else {
                        return Optional.empty();
                    }
                }
                Path certPath = Files.createTempFile("romstation-ca", ".crt", new FileAttribute[0]);
                Files.write(certPath, Base64.getDecoder().decode(credential.get("cert").getAsString().getBytes()), new OpenOption[0]);
                Path passPath = Files.createTempFile("romstation-ca-pass", null, new FileAttribute[0]);
                Files.write(passPath, (credential.get("login").getAsString() + "\n" + credential.get("password").getAsString()).getBytes(), new OpenOption[0]);
                org.romstation.application.task.C connectionTask = new org.romstation.application.task.C(certPath, passPath, guid);
                av<org.romstation.application.vpn.a> dialog = new av<org.romstation.application.vpn.a>(connectionTask);
                new Thread((Runnable)((Object)connectionTask)).start();
                Optional result = dialog.showAndWait();
                if (result.isPresent()) {
                    if (!org.romstation.application.netplay.b.j()) {
                        org.romstation.application.netplay.b.k();
                    }
                    return Optional.of(new a(credential.get("id").getAsInt(), (org.romstation.application.vpn.a)result.get()));
                }
                return Optional.empty();
            }
            return Optional.of(new a(credential.get("id").getAsInt()));
        }
        return Optional.empty();
    }

    private static void a(int lobbyID, a credential) throws MalformedURLException, ServerResponseException, NetworkOfflineException, InvalidServerResponseException {
        org.romstation.application.netplay.b.a(lobbyID, credential, null, null);
    }

    private static void a(int lobbyID, a credential, GameFile gameFile, EmulatorFile emulatorFile) throws MalformedURLException, ServerResponseException, NetworkOfflineException, InvalidServerResponseException {
        org.romstation.application.network.a httpRequest;
        d serverResponse;
        f urlBuilder = new f(org.romstation.application.network.b.b() + "/romstation/scripts/multiplayer/join_lobby.php");
        urlBuilder.a().a("v", 229);
        g urlQuery = new g().a("auth", ag.a().f()).a("lobby_id", lobbyID).a("credential_id", credential.a());
        if (credential.b() != null) {
            urlQuery.a("ip_vpn", credential.b().a());
        }
        if (gameFile != null) {
            urlQuery.a("gfid", gameFile.getRid());
        }
        if (emulatorFile != null) {
            urlQuery.a("efid", emulatorFile.getRid());
        }
        if ((serverResponse = (httpRequest = new org.romstation.application.network.a(urlBuilder.b())).a(urlQuery)).b().has("redirect_url")) {
            RomStationController.a.post((Object)new cS(org.romstation.application.network.b.b() + serverResponse.b().get("redirect_url").getAsString()));
        }
        JsonObject lobby = serverResponse.b().getAsJsonObject("lobby");
        b.set(lobby.get("host_ip").getAsString());
        bG dialog = new bG(credential, lobby);
        dialog.initModality(Modality.NONE);
        dialog.showingProperty().addListener((observableValue, previousValue, value) -> a.set(value.booleanValue()));
        dialog.show();
    }

    private static void b(int lobbyID) {
        try {
            f urlBuilder = new f(org.romstation.application.network.b.b() + "/romstation/scripts/multiplayer/quit.php");
            urlBuilder.a().a("v", 229);
            g urlQuery = new g().a("auth", ag.a().f()).a("lobby_id", lobbyID);
            org.romstation.application.network.a httpRequest = new org.romstation.application.network.a(urlBuilder.b());
            httpRequest.a(urlQuery);
        }
        catch (NetworkOfflineException exception) {
            RomStation.b().log(Level.WARNING, exception.getMessage(), exception);
        }
        catch (MalformedURLException | InvalidServerResponseException | ServerResponseException exception) {
            RomStation.b().log(Level.SEVERE, exception.getMessage(), exception);
        }
    }

    private static void c(int lobbyID, String password) throws MalformedURLException, ServerResponseException, NetworkOfflineException, InvalidServerResponseException {
        org.romstation.application.netplay.b.a(lobbyID, password, false);
    }

    private static void a(int lobbyID, String password, boolean isDedicatedServer) throws MalformedURLException, ServerResponseException, NetworkOfflineException, InvalidServerResponseException {
        f urlBuilder = new f(org.romstation.application.network.b.b() + "/romstation/scripts/multiplayer/check_password.php");
        urlBuilder.a().a("v", 229);
        g postQuery = new g().a("auth", ag.a().f()).a("id", lobbyID).a("password", password).a("dedicated_server", isDedicatedServer ? 1 : 0);
        org.romstation.application.network.a httpRequest = new org.romstation.application.network.a(urlBuilder.b());
        httpRequest.a(postQuery);
    }

    private static JsonObject c(int gameID) throws MalformedURLException, ServerResponseException, NetworkOfflineException, InvalidServerResponseException {
        f urlBuilder = new f(org.romstation.application.network.b.b() + "/romstation/scripts/game/get_infos.php");
        urlBuilder.a().a("v", 229).a("os", E.c().a()).a("gid", gameID);
        org.romstation.application.network.a request = new org.romstation.application.network.a(urlBuilder.b());
        return request.b().b().getAsJsonObject("game");
    }

    private static Optional<JsonObject> a(JsonObject game) {
        return org.romstation.application.netplay.b.a(game, false);
    }

    private static Optional<JsonObject> a(JsonObject game, boolean cloud) {
        JsonObject[] files = (JsonObject[])StreamSupport.stream(game.getAsJsonArray("files").spliterator(), false).map(JsonElement::getAsJsonObject).filter(jsonObject -> jsonObject.get("status").getAsInt() == 1).filter(jsonObject -> {
            if (cloud) {
                return jsonObject.get("cloud").getAsInt() == 1 && jsonObject.get("cloud_state").getAsInt() == 4;
            }
            if (E.e() == C.X86) {
                return jsonObject.get("x64_only").getAsInt() == 0;
            }
            return true;
        }).toArray(JsonObject[]::new);
        switch (files.length) {
            case 0: {
                return Optional.empty();
            }
            case 1: {
                return Optional.of(files[0]);
            }
        }
        return new bm(files).showAndWait();
    }

    private static Optional<JsonObject> a(JsonObject game, int gameFileID) {
        switch (game.getAsJsonArray("files").size()) {
            case 0: {
                return Optional.empty();
            }
            case 1: {
                return Optional.of(game.getAsJsonArray("files").get(0).getAsJsonObject());
            }
        }
        return StreamSupport.stream(game.getAsJsonArray("files").spliterator(), false).map(JsonElement::getAsJsonObject).filter(object -> object.get("file_id").getAsInt() == gameFileID).findAny();
    }

    private static GameFile d(int gameFileID) {
        try (EntityManager entityManager = org.romstation.application.b.c();){
            GameFile gameFile = (GameFile)entityManager.createNamedQuery("GameFile.findByRID", GameFile.class).setParameter("rid", (Object)gameFileID).getSingleResult();
            return gameFile;
        }
    }

    private static void a(JsonObject game, JsonObject gameFile, Consumer<GameFile> onFinish) {
        if (cU.a().isEmpty()) {
            p task = new p(new o(game, gameFile));
            ar dialog = new ar(task);
            dialog.resultProperty().addListener((observableValue, previousValue, value) -> onFinish.accept((GameFile)value));
            dialog.a(true);
            dialog.initModality(Modality.NONE);
            new Thread((Runnable)((Object)task)).start();
            dialog.show();
        } else {
            cU.b();
        }
    }

    private static void a(int gameID, Consumer<GameFile> consumer) {
        try {
            JsonObject game = org.romstation.application.netplay.b.c(gameID);
            org.romstation.application.netplay.b.a(game).ifPresent(gameFile -> {
                try {
                    consumer.accept(org.romstation.application.netplay.b.d(gameFile.get("file_id").getAsInt()));
                }
                catch (NoResultException exception) {
                    org.romstation.application.netplay.b.a(game, gameFile, consumer);
                }
            });
        }
        catch (MalformedURLException | InvalidServerResponseException exception) {
            RomStation.b().log(Level.SEVERE, exception.getMessage(), exception);
        }
        catch (ServerResponseException exception) {
            RomStation.b().log(Level.SEVERE, exception.getMessage(), exception);
            ServerErrorAlert alert = new ServerErrorAlert(exception);
            alert.showAndWait();
        }
        catch (NetworkOfflineException exception) {
            RomStation.b().log(Level.WARNING, exception.getMessage(), exception);
        }
    }

    private static void a(int gameID, int gameFileID, Consumer<GameFile> consumer) {
        try {
            consumer.accept(org.romstation.application.netplay.b.d(gameFileID));
        }
        catch (NoResultException noResultException) {
            try {
                JsonObject game = org.romstation.application.netplay.b.c(gameID);
                org.romstation.application.netplay.b.a(game, gameFileID).ifPresent(gameFile -> org.romstation.application.netplay.b.a(game, gameFile, consumer));
            }
            catch (MalformedURLException | InvalidServerResponseException exception) {
                RomStation.b().log(Level.SEVERE, exception.getMessage(), exception);
            }
            catch (ServerResponseException exception) {
                RomStation.b().log(Level.SEVERE, exception.getMessage(), exception);
                ServerErrorAlert alert = new ServerErrorAlert(exception);
                alert.showAndWait();
            }
            catch (NetworkOfflineException exception) {
                RomStation.b().log(Level.WARNING, exception.getMessage(), exception);
            }
        }
    }

    private static int e(int systemID) throws MalformedURLException, ServerResponseException, NetworkOfflineException, InvalidServerResponseException {
        f urlBuilder = new f(org.romstation.application.network.b.b() + "/romstation/scripts/multiplayer/get_emulator.php");
        urlBuilder.a().a("v", 229);
        g postQuery = new g().a("auth", ag.a().f()).a("arch", E.d().a()).a("os", E.c().a()).a("console_id", systemID);
        org.romstation.application.network.a httpRequest = new org.romstation.application.network.a(urlBuilder.b());
        return httpRequest.a(postQuery).b().get("emulator_file_id").getAsInt();
    }

    private static EmulatorFile f(int emulatorFileID) {
        try (EntityManager entityManager = org.romstation.application.b.c();){
            EmulatorFile emulatorFile = (EmulatorFile)entityManager.createNamedQuery("EmulatorFile.findByRID", EmulatorFile.class).setParameter("rid", (Object)emulatorFileID).getSingleResult();
            return emulatorFile;
        }
    }

    private static Optional<EmulatorFile> g(int id) throws NetworkOfflineException, EmulatorFileDownloadContextException {
        i task = new i(new h(id));
        an dialog = new an(task);
        new Thread((Runnable)((Object)task)).start();
        return dialog.showAndWait();
    }

    private static Optional<EmulatorFile> h(int systemID) {
        try {
            int emulatorFileID = org.romstation.application.netplay.b.e(systemID);
            try {
                return Optional.of(org.romstation.application.netplay.b.f(emulatorFileID));
            }
            catch (NoResultException exception) {
                return org.romstation.application.netplay.b.g(emulatorFileID);
            }
        }
        catch (MalformedURLException | InvalidServerResponseException | EmulatorFileDownloadContextException exception) {
            RomStation.b().log(Level.SEVERE, exception.getMessage(), exception);
        }
        catch (ServerResponseException exception) {
            RomStation.b().log(Level.SEVERE, exception.getMessage(), exception);
            ServerErrorAlert alert = new ServerErrorAlert(exception);
            alert.showAndWait();
        }
        catch (NetworkOfflineException exception) {
            RomStation.b().log(Level.WARNING, exception.getMessage(), exception);
        }
        return Optional.empty();
    }

    private static Optional<String> i() {
        List<L> devices;
        String tapDeviceID = RomStation.c().getProperty("tapDevice.id");
        String tapDeviceGUID = RomStation.c().getProperty("tapDevice.guid");
        if (tapDeviceGUID != null && tapDeviceID != null && tapDeviceID.startsWith("ROOT\\NET\\") && !(devices = K.a("@" + tapDeviceID)).isEmpty()) {
            return Optional.of(tapDeviceGUID);
        }
        return Optional.empty();
    }

    private static boolean j() {
        ProcessBuilder processBuilder = new ProcessBuilder("openvpn/check_firewall_rules.bat");
        processBuilder.inheritIO();
        try {
            return processBuilder.start().waitFor() == 0;
        }
        catch (IOException | InterruptedException exception) {
            RomStation.b().log(Level.SEVERE, exception.getMessage(), exception);
            return false;
        }
    }

    private static void k() {
        ProcessBuilder processBuilder = new ProcessBuilder("elevate.exe", "-c", "-w", Paths.get("openvpn", "add_firewall_rules.bat").toAbsolutePath().toString());
        processBuilder.inheritIO();
        try {
            Process process = processBuilder.start();
            process.waitFor();
        }
        catch (IOException | InterruptedException exception) {
            RomStation.b().log(Level.SEVERE, exception.getMessage(), exception);
        }
    }

    private static void l() throws AlreadyConnectedException {
        if (org.romstation.application.netplay.b.b()) {
            throw new AlreadyConnectedException();
        }
    }

    private static void m() throws UnsupportedOperationException {
        if (E.c() != D.WINDOWS) {
            throw new UnsupportedOperationException();
        }
    }

    private static void n() {
        ResourceBundle i18n = RomStation.d();
        ApplicationAlert alert = new ApplicationAlert(i18n.getString("netplayAlreadyConnectedAlert.header"), i18n.getString("netplayAlreadyConnectedAlert.content"), Alert.AlertType.ERROR);
        alert.showAndWait();
    }

    private static void o() {
        ResourceBundle i18n = RomStation.d();
        ApplicationAlert alert = new ApplicationAlert(i18n.getString("featureNotYetAvailableAlert.header"), i18n.getString("featureNotYetAvailableAlert.content"), Alert.AlertType.ERROR);
        alert.showAndWait();
    }
}

