/*
 * Decompiled with CFR 0.152.
 */
package org.romstation.application.view.control;

import java.io.IOException;
import java.util.LinkedList;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.logging.Level;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.control.ComboBox;
import javafx.scene.control.MenuButton;
import javafx.scene.control.MenuItem;
import javafx.scene.layout.HBox;
import org.romstation.application.RomStation;
import org.romstation.application.aR;
import org.romstation.application.database.entity.Publisher;

public class PublisherComboBox
extends HBox {
    @FXML
    private ComboBox<Publisher> comboBox;
    @FXML
    private MenuButton menuButton;
    @FXML
    private MenuItem editMenuItem;
    @FXML
    private MenuItem clearMenuItem;
    @FXML
    private ResourceBundle resources;

    public PublisherComboBox() {
        try {
            FXMLLoader fxmlLoader = new FXMLLoader();
            fxmlLoader.setLocation(((Object)((Object)this)).getClass().getResource("/fxml/control/publisherComboBox.fxml"));
            fxmlLoader.setResources(RomStation.d());
            fxmlLoader.setRoot((Object)this);
            fxmlLoader.setController((Object)this);
            fxmlLoader.load();
        }
        catch (IOException exception) {
            RomStation.b().log(Level.SEVERE, exception.getMessage(), exception);
        }
    }

    public ComboBox<Publisher> getComboBox() {
        return this.comboBox;
    }

    @FXML
    private void initialize() {
        this.editMenuItem.disableProperty().bind((ObservableValue)this.comboBox.valueProperty().isNull());
        this.clearMenuItem.disableProperty().bind((ObservableValue)this.comboBox.valueProperty().isNull());
    }

    @FXML
    private void create() {
        aR dialog = new aR(new Publisher());
        Optional optional = dialog.showAndWait();
        optional.ifPresent(publisher -> {
            this.comboBox.getItems().add(publisher);
            this.comboBox.setValue(publisher);
        });
    }

    @FXML
    private void edit() {
        aR dialog = new aR((Publisher)this.comboBox.getSelectionModel().getSelectedItem());
        Optional optional = dialog.showAndWait();
        optional.ifPresent(publisher -> {
            this.comboBox.getItems().setAll(new LinkedList(this.comboBox.getItems()));
            this.comboBox.getSelectionModel().select(publisher);
        });
    }

    @FXML
    private void clear() {
        this.comboBox.getSelectionModel().clearSelection();
    }
}

