/*
 * Decompiled with CFR 0.152.
 */
package org.romstation.application.view.control.cell.entity;

import java.net.URI;
import java.util.List;
import javafx.scene.Node;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.HBox;
import javafx.util.Callback;
import org.romstation.application.ah;
import org.romstation.application.database.entity.Language;

public class LanguagesTableCell<S>
extends TableCell<S, List<Language>> {
    private static final ah<URI, Image> a = new ah(32);
    private HBox b = new HBox();

    public LanguagesTableCell() {
        this.getStyleClass().add((Object)"languages");
        this.b.getStyleClass().add((Object)"container");
    }

    protected void a(List<Language> languages, boolean empty) {
        super.updateItem(languages, empty);
        if (empty) {
            this.setGraphic(null);
        } else {
            this.b.getChildren().clear();
            languages.forEach(language -> {
                Node node = this.a((Language)language);
                if (node != null) {
                    this.b.getChildren().add((Object)node);
                }
            });
            this.setGraphic((Node)this.b);
        }
    }

    private Node a(Language language) {
        if (language.getGraphic() == null) {
            return null;
        }
        Image image = a.computeIfAbsent(language.getGraphic().getURI(), value -> new Image(value.toString(), true));
        ImageView imageView = new ImageView(image);
        imageView.getStyleClass().add((Object)"language");
        Tooltip tooltip = new Tooltip(language.getName().getDefaultString());
        Tooltip.install((Node)imageView, (Tooltip)tooltip);
        return imageView;
    }

    protected /* synthetic */ void updateItem(Object object, boolean bl2) {
        this.a((List)object, bl2);
    }

    public static class Factory<S>
    implements Callback<TableColumn<S, List<Language>>, LanguagesTableCell<S>> {
        public LanguagesTableCell<S> a(TableColumn<S, List<Language>> param) {
            return new LanguagesTableCell();
        }

        public /* synthetic */ Object call(Object object) {
            return this.a((TableColumn)object);
        }
    }
}

