/*
 * Decompiled with CFR 0.152.
 */
package org.romstation.application.view.controller;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.ListView;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SelectionMode;
import javax.persistence.EntityManager;
import org.romstation.application.aJ;
import org.romstation.application.aU;
import org.romstation.application.b;
import org.romstation.application.database.entity.System;

public class SystemsPaneController {
    private final ObservableList<System> a = FXCollections.observableList(new LinkedList());
    @FXML
    private MenuItem createMenuItem;
    @FXML
    private MenuItem selectMenuItem;
    @FXML
    private Button removeButton;
    @FXML
    private Button editButton;
    @FXML
    private ListView<System> listView;
    @FXML
    private ResourceBundle resources;

    public SystemsPaneController() {
        EntityManager entityManager = b.c();
        this.a.setAll((Collection)entityManager.createNamedQuery("System.findAll", System.class).getResultList());
        entityManager.close();
    }

    public ListView<System> a() {
        return this.listView;
    }

    private List<System> b() {
        return this.a.stream().filter(system -> !this.listView.getItems().contains(system)).collect(Collectors.toList());
    }

    @FXML
    private void initialize() {
        this.selectMenuItem.disableProperty().bind((ObservableValue)Bindings.size((ObservableList)this.listView.getItems()).isEqualTo((ObservableNumberValue)Bindings.size(this.a)));
        this.removeButton.disableProperty().bind((ObservableValue)Bindings.size((ObservableList)this.listView.getSelectionModel().getSelectedItems()).isEqualTo(0));
        this.editButton.disableProperty().bind((ObservableValue)Bindings.size((ObservableList)this.listView.getSelectionModel().getSelectedItems()).isNotEqualTo(1));
        this.listView.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
    }

    @FXML
    private void create(ActionEvent event) {
        aU dialog = new aU(new System());
        Optional optional = dialog.showAndWait();
        optional.ifPresent(system -> this.listView.getItems().add(system));
    }

    @FXML
    private void select(ActionEvent event) {
        aJ dialog = new aJ(this.b());
        dialog.c().getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        Optional optional = dialog.showAndWait();
        optional.ifPresent(items -> this.listView.getItems().addAll((Collection)items));
    }

    @FXML
    private void edit(ActionEvent event) {
        aU dialog = new aU((System)this.listView.getSelectionModel().getSelectedItem());
        Optional optional = dialog.showAndWait();
        optional.ifPresent(system -> this.listView.refresh());
    }

    @FXML
    private void remove(ActionEvent event) {
        this.listView.getItems().removeAll((Collection)this.listView.getSelectionModel().getSelectedItems());
    }
}

