/*
 * Decompiled with CFR 0.152.
 */
package org.romstation.application.view.controller.library.grid;

import com.google.common.eventbus.Subscribe;
import java.util.Comparator;
import java.util.List;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Slider;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.ToggleGroup;
import javafx.util.Callback;
import org.controlsfx.control.GridView;
import org.romstation.application.RomStation;
import org.romstation.application.cE;
import org.romstation.application.cf;
import org.romstation.application.database.entity.Game;
import org.romstation.application.view.controller.RomStationController;
import org.romstation.application.view.controller.library.LibraryController;
import org.romstation.application.view.controller.library.grid.LibraryGridViewGameGridCell;
import org.romstation.application.view.controller.library.grid.LibraryGridViewSortField;
import org.romstation.application.view.controller.library.grid.LibraryGridViewSortOrder;

public class LibraryGridViewController {
    @FXML
    private ComboBox<LibraryGridViewSortField> sortFieldComboBox;
    @FXML
    private ToggleGroup sortToggleGroup;
    @FXML
    private ToggleButton sortAscToggleButton;
    @FXML
    private ToggleButton sortDescToggleButton;
    @FXML
    private Slider zoomSlider;
    @FXML
    private GridView<Game> gridView;
    private final double a = 256.0;
    private final double b = 256.0;

    @FXML
    private void initialize() {
        RomStationController.a.register((Object)this);
        this.sortFieldComboBox.getItems().addAll((Object[])LibraryGridViewSortField.values());
        this.sortFieldComboBox.getSelectionModel().select((Object)LibraryGridViewSortField.valueOf(RomStation.c().getProperty("library.gridView.sort.field")));
        this.sortFieldComboBox.valueProperty().addListener((observable, oldValue, newValue) -> this.c());
        switch (LibraryGridViewSortOrder.valueOf(RomStation.c().getProperty("library.gridView.sort.order"))) {
            case ASCENDING: {
                this.sortToggleGroup.selectToggle((Toggle)this.sortAscToggleButton);
                break;
            }
            case DESCENDING: {
                this.sortToggleGroup.selectToggle((Toggle)this.sortDescToggleButton);
            }
        }
        this.sortToggleGroup.selectedToggleProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue == null) {
                this.sortToggleGroup.selectToggle(oldValue);
            } else {
                this.c();
            }
        });
        this.zoomSlider.setValue(Double.parseDouble(RomStation.c().getProperty("library.gridView.zoom")));
        this.gridView.cellWidthProperty().bind((ObservableValue)this.zoomSlider.valueProperty().multiply(256.0));
        this.gridView.cellHeightProperty().bind((ObservableValue)this.zoomSlider.valueProperty().multiply(256.0));
        this.gridView.setCellFactory((Callback)new LibraryGridViewGameGridCell.Factory(LibraryController.a()));
        this.c();
    }

    @Subscribe
    private void a(cE event) {
        List<Game> games = event.a();
        games.sort(this.b());
        this.gridView.getItems().setAll(games);
    }

    @Subscribe
    private void a(cf event) {
        RomStation.c().setProperty("library.gridView.sort.field", ((LibraryGridViewSortField)((Object)this.sortFieldComboBox.getValue())).name());
        RomStation.c().setProperty("library.gridView.sort.order", this.a().name());
        RomStation.c().setProperty("library.gridView.zoom", String.valueOf(this.zoomSlider.getValue()));
    }

    private LibraryGridViewSortOrder a() {
        return this.sortAscToggleButton.isSelected() ? LibraryGridViewSortOrder.ASCENDING : LibraryGridViewSortOrder.DESCENDING;
    }

    private Comparator<Game> b() {
        return this.a((LibraryGridViewSortField)((Object)this.sortFieldComboBox.getValue()), this.a());
    }

    private Comparator<Game> a(LibraryGridViewSortField field, LibraryGridViewSortOrder order) {
        Comparator<Game> comparator;
        switch (field) {
            case ID: {
                comparator = Comparator.comparing(Game::getId, Comparator.nullsFirst(Integer::compareTo));
                break;
            }
            case TITLE: {
                comparator = Comparator.comparing(Game::getTitle, Comparator.nullsFirst(String::compareToIgnoreCase));
                break;
            }
            case SYSTEM: {
                comparator = Comparator.comparing(game -> game.getSystem() != null ? game.getSystem().getName() : null, Comparator.nullsFirst(String::compareToIgnoreCase));
                break;
            }
            case PLAYERS: {
                comparator = Comparator.comparing(Game::getPlayers, Comparator.nullsFirst(Integer::compareTo));
                break;
            }
            case YEAR: {
                comparator = Comparator.comparing(Game::getYear, Comparator.nullsFirst(Integer::compareTo));
                break;
            }
            case DEVELOPER: {
                comparator = Comparator.comparing(game -> game.getDeveloper() != null ? game.getDeveloper().getName() : null, Comparator.nullsFirst(String::compareToIgnoreCase));
                break;
            }
            case PUBLISHER: {
                comparator = Comparator.comparing(game -> game.getPublisher() != null ? game.getPublisher().getName() : null, Comparator.nullsFirst(String::compareToIgnoreCase));
                break;
            }
            case FILES: {
                comparator = Comparator.comparingInt(o2 -> o2.getFiles().size());
                break;
            }
            case LAST_USE: {
                comparator = Comparator.comparing(Game::getLastUse, Comparator.nullsFirst(Long::compareTo));
                break;
            }
            case PLAYED: {
                comparator = Comparator.comparing(Game::getPlayed, Comparator.nullsFirst(Long::compareTo));
                break;
            }
            default: {
                return null;
            }
        }
        return order == LibraryGridViewSortOrder.ASCENDING ? comparator : comparator.reversed();
    }

    private void c() {
        this.gridView.getItems().sort(this.b());
    }
}

