/*
 * Decompiled with CFR 0.152.
 */
package org.romstation.application;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.file.AccessDeniedException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import javafx.application.Application;
import javafx.fxml.FXMLLoader;
import javafx.scene.control.Alert;
import javafx.stage.Stage;
import org.freedesktop.gstreamer.Gst;
import org.jruby.Ruby;
import org.jruby.RubyObject;
import org.romstation.application.ApplicationAlreadyRunningException;
import org.romstation.application.B;
import org.romstation.application.E;
import org.romstation.application.N;
import org.romstation.application.a;
import org.romstation.application.ap;
import org.romstation.application.b;
import org.romstation.application.ce;
import org.romstation.application.cf;
import org.romstation.application.view.control.ApplicationAlert;
import org.romstation.application.view.controller.RomStationController;

public class RomStation
extends Application {
    public static final int a = 229;
    public static final String b = "2.9.2";
    private static final Logger c = Logger.getLogger("global");
    private static Properties d;
    private static ResourceBundle e;
    private static RomStation f;
    private Thread g;
    private FileLock h;
    private Exception i;
    private RomStationController j;
    private final List<RubyObject> k = new LinkedList<RubyObject>();

    public static void main(String[] args) {
        RomStation.launch((String[])args);
    }

    public RomStation() {
        f = this;
    }

    public static synchronized RomStation a() {
        return f;
    }

    public static Logger b() {
        return c;
    }

    public static Properties c() {
        return d;
    }

    public static ResourceBundle d() {
        return e;
    }

    public static String e() {
        return Paths.get("themes", d.getProperty("application.theme"), "theme.css").toUri().toString();
    }

    public void init() {
        try {
            this.g();
            this.g = new Thread(this::f);
            Runtime.getRuntime().addShutdownHook(this.g);
            d = this.a(Paths.get("config/romstation.properties", new String[0]));
            Locale.setDefault(Locale.forLanguageTag(d.getProperty("application.locale")));
            e = this.a(Paths.get("i18n", new String[0]), Locale.getDefault());
            Path currentDirectory = Paths.get("", new String[0]).toAbsolutePath();
            if (!Files.isWritable(currentDirectory)) {
                throw new AccessDeniedException(currentDirectory.toString());
            }
            Path applicationUserDataPath = Files.createDirectories(E.b(), new FileAttribute[0]);
            RandomAccessFile randomAccessFile = new RandomAccessFile(applicationUserDataPath.resolve("romstation.lck").toFile(), "rw");
            FileChannel fileChannel = randomAccessFile.getChannel();
            this.h = fileChannel.tryLock();
            if (this.h == null) {
                throw new ApplicationAlreadyRunningException();
            }
            this.h();
            ExecutorService executorService = Executors.newCachedThreadPool();
            Future<?> scriptsFuture = executorService.submit(this::i);
            Future<Boolean> databaseFuture = executorService.submit(b::a);
            Future<?> browserFuture = executorService.submit(a::a);
            Future<Boolean> viewFuture = executorService.submit(this::j);
            executorService.shutdown();
            scriptsFuture.get();
            databaseFuture.get();
            browserFuture.get();
            viewFuture.get();
            this.l();
        }
        catch (Exception exception) {
            this.i = exception;
        }
    }

    public void start(Stage stage) {
        try {
            if (this.i != null) {
                throw this.i;
            }
            this.m();
            RomStationController.a.post((Object)new ce());
            this.j.a(stage);
            stage.show();
        }
        catch (Exception exception) {
            this.a(exception);
            System.exit(0);
        }
    }

    public void stop() {
        try {
            this.n();
            RomStationController.a.post((Object)new cf());
            this.b(Paths.get("config/romstation.properties", new String[0]));
        }
        catch (Exception exception) {
            this.a(exception);
        }
        finally {
            Runtime.getRuntime().removeShutdownHook(this.g);
            this.f();
        }
    }

    private void f() {
        if (Ruby.isGlobalRuntimeReady()) {
            Ruby.getGlobalRuntime().tearDown();
        }
        if (org.romstation.application.a.c()) {
            org.romstation.application.a.d();
        }
        if (org.romstation.application.b.b()) {
            org.romstation.application.b.d();
        }
        if (B.a()) {
            Gst.deinit();
        }
        if (this.h != null) {
            try {
                this.h.acquiredBy().close();
            }
            catch (IOException exception) {
                exception.printStackTrace();
            }
        }
    }

    private void a(Exception exception) {
        c.log(Level.SEVERE, exception.getMessage(), exception);
        if (e != null) {
            if (exception instanceof ApplicationAlreadyRunningException) {
                ApplicationAlert alert = new ApplicationAlert(e.getString("applicationAlreadyRunningAlert.header"), e.getString("applicationAlreadyRunningAlert.content"), Alert.AlertType.ERROR);
                alert.showAndWait();
            } else if (exception instanceof AccessDeniedException) {
                ApplicationAlert alert = new ApplicationAlert(e.getString("writePermissionErrorAlert.header"), e.getString("writePermissionErrorAlert.content"), Alert.AlertType.ERROR);
                alert.showAndWait();
            } else {
                ap exceptionDialog = new ap(exception);
                exceptionDialog.showAndWait();
            }
        }
    }

    private Properties a(Path path) throws IOException {
        Properties properties;
        block14: {
            Properties defaults = new Properties();
            defaults.load(((Object)((Object)this)).getClass().getResourceAsStream("/config/romstation.properties"));
            properties = new Properties(defaults);
            try (InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);){
                properties.load(inputStream);
            }
            catch (Exception exception) {
                RomStation.b().log(Level.WARNING, exception.getMessage(), exception);
                if (!Locale.getDefault().getLanguage().equals("fr")) break block14;
                properties.setProperty("application.locale", "fr");
            }
        }
        return properties;
    }

    private void b(Path path) throws IOException {
        Files.createDirectories(path.getParent(), new FileAttribute[0]);
        try (OutputStream outputStream = Files.newOutputStream(path, new OpenOption[0]);){
            d.store(outputStream, null);
        }
    }

    private ResourceBundle a(Path path, Locale locale) throws MalformedURLException, MissingResourceException {
        URL[] urls = new URL[]{path.toUri().toURL()};
        URLClassLoader loader = new URLClassLoader(urls);
        return ResourceBundle.getBundle("romstation", locale, loader);
    }

    private void g() {
        try {
            FileHandler fileHandler = new FileHandler("romstation.log");
            fileHandler.setFormatter(new SimpleFormatter());
            c.addHandler(fileHandler);
            c.setLevel(Level.WARNING);
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
    }

    private void h() {
        switch (E.c()) {
            case WINDOWS: {
                try {
                    Files.move(Paths.get("../_Updater.exe", new String[0]), Paths.get("../Updater.exe", new String[0]), StandardCopyOption.REPLACE_EXISTING);
                }
                catch (NoSuchFileException noSuchFileException) {
                }
                catch (IOException exception) {
                    RomStation.b().log(Level.SEVERE, exception.getMessage(), exception);
                }
                try {
                    Files.move(Paths.get("_Updater.jar", new String[0]), Paths.get("Updater.jar", new String[0]), StandardCopyOption.REPLACE_EXISTING);
                }
                catch (NoSuchFileException exception) {
                }
                catch (IOException exception) {
                    RomStation.b().log(Level.SEVERE, exception.getMessage(), exception);
                }
                break;
            }
            case MAC_OS: {
                try {
                    Files.move(Paths.get("Updater.app/Contents/MacOS/_Updater", new String[0]), Paths.get("Updater.app/Contents/MacOS/Updater", new String[0]), StandardCopyOption.REPLACE_EXISTING);
                }
                catch (NoSuchFileException exception) {
                }
                catch (IOException exception) {
                    RomStation.b().log(Level.SEVERE, exception.getMessage(), exception);
                }
                try {
                    Files.move(Paths.get("Updater.app/Contents/Java/_Updater.jar", new String[0]), Paths.get("Updater.app/Contents/Java/Updater.jar", new String[0]), StandardCopyOption.REPLACE_EXISTING);
                    break;
                }
                catch (NoSuchFileException exception) {
                    break;
                }
                catch (IOException exception) {
                    RomStation.b().log(Level.SEVERE, exception.getMessage(), exception);
                }
            }
        }
    }

    private void i() {
        try {
            Files.find(Paths.get("scripts", new String[0]), 2, (path, basicFileAttributes) -> path.endsWith("init.rb"), new FileVisitOption[0]).forEach(path -> {
                try {
                    this.k.add(N.a(path));
                }
                catch (Exception exception) {
                    RomStation.b().log(Level.WARNING, exception.getMessage(), exception);
                }
            });
        }
        catch (IOException exception) {
            RomStation.b().log(Level.WARNING, exception.getMessage(), exception);
        }
        this.k();
    }

    private boolean j() throws IOException {
        FXMLLoader fxmlLoader = new FXMLLoader();
        fxmlLoader.setLocation(((Object)((Object)this)).getClass().getResource("/fxml/romstation.fxml"));
        fxmlLoader.setResources(e);
        fxmlLoader.load();
        this.j = (RomStationController)fxmlLoader.getController();
        return true;
    }

    private void k() {
        this.k.forEach(rubyObject -> {
            if (rubyObject.respondsTo("on_init")) {
                rubyObject.callMethod("on_init");
            }
        });
        if (N.a().runtime.on_init != null) {
            N.a().runtime.on_init.run();
        }
    }

    private void l() {
        this.k.forEach(rubyObject -> {
            if (rubyObject.respondsTo("on_ready")) {
                rubyObject.callMethod("on_ready");
            }
        });
        if (N.a().runtime.on_ready != null) {
            N.a().runtime.on_ready.run();
        }
    }

    private void m() {
        this.k.forEach(rubyObject -> {
            if (rubyObject.respondsTo("on_start")) {
                rubyObject.callMethod("on_start");
            }
        });
        if (N.a().runtime.on_start != null) {
            N.a().runtime.on_start.run();
        }
    }

    private void n() {
        this.k.forEach(rubyObject -> {
            if (rubyObject.respondsTo("on_stop")) {
                rubyObject.callMethod("on_stop");
            }
        });
        if (N.a().runtime.on_stop != null) {
            N.a().runtime.on_stop.run();
        }
    }
}

