/*
 * Decompiled with CFR 0.152.
 */
package org.romstation.application;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.text.MessageFormat;
import java.time.Instant;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.StreamSupport;
import javafx.concurrent.Task;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import org.romstation.application.RomStation;
import org.romstation.application.X;
import org.romstation.application.Z;
import org.romstation.application.b;
import org.romstation.application.database.entity.Emulator;
import org.romstation.application.database.entity.EmulatorFile;
import org.romstation.application.database.entity.EmulatorProfile;
import org.romstation.application.database.entity.Image;
import org.romstation.application.database.entity.Link;
import org.romstation.application.database.entity.System;
import org.romstation.application.task.a;

public class Y
extends Task<List<Emulator>> {
    private final List<X> a;
    private final List<Emulator> b = new LinkedList<Emulator>();
    private Pattern c = Pattern.compile("/[^/]+\\)");
    private Pattern d = Pattern.compile("%(?<cmd>\\w+)%");
    private Pattern e = Pattern.compile("(?<key>-{1,2}\\w+)=\"(?<value>[^\"]*)\"");
    private EntityManager f;
    private JsonArray g;
    private JsonArray h;
    private JsonArray i;

    public Y(List<X> emulators) {
        this.a = emulators;
    }

    protected void scheduled() {
        this.updateTitle(RomStation.d().getString("legacyEmulatorImporterTask.title"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<Emulator> a() throws Exception {
        this.f = org.romstation.application.b.c();
        try {
            for (X legacyEmulator : this.a) {
                this.updateMessage(MessageFormat.format(RomStation.d().getString("legacyEmulatorImporterTask.message"), legacyEmulator.getName()));
                if (this.isCancelled()) {
                    break;
                }
                Emulator emulator = this.a(legacyEmulator);
                EmulatorFile emulatorFile = this.a(emulator, legacyEmulator);
                if (!legacyEmulator.getProfiles().isEmpty()) {
                    emulatorFile.getProfiles().add(this.a(emulatorFile, legacyEmulator.getProfiles().get(0)));
                    for (Z legacyEmulatorProfile : legacyEmulator.getProfiles()) {
                        emulatorFile.getProfiles().add(this.b(emulatorFile, legacyEmulatorProfile));
                    }
                }
                emulator.getFiles().add(emulatorFile);
                this.f.getTransaction().begin();
                this.f.persist((Object)emulator);
                this.f.getTransaction().commit();
                this.b.add(emulator);
                this.updateValue(this.b);
                this.updateProgress(this.b.size(), this.a.size());
            }
        }
        finally {
            this.f.close();
        }
        return this.b;
    }

    private Emulator a(X legacyEmulator) throws IOException {
        Optional<JsonElement> optional;
        if (this.g == null) {
            try (InputStreamReader reader = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("/importer/legacy/emulators.json"));){
                JsonParser jsonParser = new JsonParser();
                this.g = jsonParser.parse((Reader)reader).getAsJsonArray();
            }
        }
        if ((optional = StreamSupport.stream(this.g.spliterator(), false).filter(jsonElement -> {
            for (JsonElement alias : jsonElement.getAsJsonObject().get("aliases").getAsJsonArray()) {
                if (!alias.getAsString().equals(legacyEmulator.getName())) continue;
                return true;
            }
            return false;
        }).findAny()).isPresent()) {
            JsonObject jsonObject = optional.get().getAsJsonObject();
            try {
                return (Emulator)this.f.createQuery("select emulator from Emulator emulator where emulator.rid = :rid", Emulator.class).setParameter("rid", (Object)jsonObject.get("id").getAsInt()).getSingleResult();
            }
            catch (NoResultException e2) {
                Emulator emulator = new Emulator();
                emulator.setRid(jsonObject.get("id").getAsInt());
                emulator.setName(jsonObject.get("name").getAsString());
                for (JsonElement jsonElement2 : jsonObject.getAsJsonArray("links")) {
                    JsonObject jsonLinkObject = jsonElement2.getAsJsonObject();
                    emulator.getLinks().add(new Link(jsonLinkObject.get("name").getAsString(), jsonLinkObject.get("location").getAsString(), jsonLinkObject.get("external").getAsBoolean()));
                }
                Path path = Paths.get(RomStation.c().getProperty("path.emulators"), "downloads", emulator.getName());
                Files.createDirectories(path, new FileAttribute[0]);
                emulator.setDirectory(path.toString());
                emulator.setManaged(true);
                return emulator;
            }
        }
        try {
            return (Emulator)this.f.createQuery("select emulator from Emulator emulator where emulator.name like :name", Emulator.class).setParameter("name", (Object)legacyEmulator.getName()).setMaxResults(1).getSingleResult();
        }
        catch (NoResultException e3) {
            Emulator emulator = new Emulator();
            emulator.setName(legacyEmulator.getName());
            emulator.setDirectory(Files.createDirectories(Paths.get(RomStation.c().getProperty("path.emulators"), "legacy", legacyEmulator.getName()), new FileAttribute[0]).toString());
            emulator.setManaged(true);
            return emulator;
        }
    }

    private EmulatorFile a(Emulator emulator, X legacyEmulator) throws IOException {
        JsonObject jsonObject = this.b(legacyEmulator);
        EmulatorFile emulatorFile = new EmulatorFile();
        emulatorFile.setEmulator(emulator);
        emulatorFile.getMetas().put("legacy", "{\"name\": \"" + legacyEmulator.getName() + "\"}");
        if (jsonObject != null) {
            emulatorFile.setRid(jsonObject.get("id").getAsInt());
            emulatorFile.setName(jsonObject.get("name").getAsString());
        } else {
            emulatorFile.setName(legacyEmulator.getName() + " (RomStation 1.0)");
        }
        Path source = legacyEmulator.getDirectory();
        Path target = Paths.get(emulator.getDirectory(), "files", String.format("%s - %d", emulatorFile.getName(), Instant.now().getEpochSecond()));
        Files.createDirectories(target, new FileAttribute[0]);
        Files.move(source, target, StandardCopyOption.REPLACE_EXISTING);
        emulatorFile.setDirectory(target.toString());
        emulatorFile.setManaged(true);
        return emulatorFile;
    }

    private EmulatorProfile a(EmulatorFile emulatorFile, Z legacyEmulatorProfile) {
        EmulatorProfile emulatorProfile = new EmulatorProfile();
        emulatorProfile.setName(emulatorFile.getEmulator().getName());
        emulatorProfile.setPath(Paths.get(emulatorFile.getDirectory(), new String[0]).resolve(legacyEmulatorProfile.c()).toString());
        emulatorProfile.setWorkingDirectory("${emulator.file.directory}");
        emulatorProfile.setEmulatorFile(emulatorFile);
        return emulatorProfile;
    }

    private EmulatorProfile b(EmulatorFile emulatorFile, Z legacyEmulatorProfile) throws IOException {
        EmulatorProfile emulatorProfile = new EmulatorProfile();
        emulatorProfile.setName(legacyEmulatorProfile.b());
        emulatorProfile.setPath(Paths.get(emulatorFile.getDirectory(), new String[0]).resolve(legacyEmulatorProfile.c()).toString());
        emulatorProfile.setWorkingDirectory("${emulator.file.directory}");
        emulatorProfile.setEmulatorFile(emulatorFile);
        emulatorProfile.getSystems().add(this.a(legacyEmulatorProfile.b()));
        if (legacyEmulatorProfile.e() != null) {
            String parameters = legacyEmulatorProfile.e();
            parameters = this.b(parameters);
            parameters = this.c(parameters);
            Matcher matcher = this.c.matcher(parameters);
            JsonObject jsonObject = new JsonObject();
            JsonArray jsonArray = new JsonArray();
            jsonObject.add("commands", (JsonElement)jsonArray);
            while (matcher.find()) {
                String group;
                switch (group = matcher.group()) {
                    case "/unzip()": 
                    case "/unrar()": {
                        String meta = emulatorProfile.getMetas().getOrDefault("unpack", "{\"formats\": [], \"extensions\": [\".iso\", \".cso\", \".pbp\", \".elf\", \".prx\", \".cue\", \".ccd\", \".toc\", \".m3u\", \".mdf\", \".nrg\", \".bin\", \".img\", \".dol\", \".gcm\", \".tgc\", \".wbfs\", \".ciso\", \".gcz\", \".wad\", \".dff\", \".chd\", \".gdi\", \".cdr\", \".cdi\", \".nds\", \".sub\", \".mds\", \".ecm\", \".gba\"]}");
                        JsonParser parser = new JsonParser();
                        JsonObject metaJson = parser.parse(meta).getAsJsonObject();
                        metaJson.getAsJsonArray("formats").add(group.equals("/unzip()") ? ".zip" : ".rar");
                        emulatorProfile.getMetas().put("unpack", metaJson.toString());
                        break;
                    }
                    default: {
                        jsonArray.add(group);
                    }
                }
                parameters = matcher.replaceFirst("").trim();
                matcher.reset(parameters);
            }
            emulatorProfile.setParameters(parameters);
            emulatorProfile.getMetas().put("legacy", jsonObject.toString());
        }
        return emulatorProfile;
    }

    private System a(String value) throws IOException {
        Optional<JsonElement> optional;
        if (this.h == null) {
            try (InputStreamReader reader = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("/importer/legacy/systems.json"));){
                JsonParser jsonParser = new JsonParser();
                this.h = jsonParser.parse((Reader)reader).getAsJsonArray();
            }
        }
        if ((optional = StreamSupport.stream(this.h.spliterator(), false).filter(jsonElement -> {
            for (JsonElement alias : jsonElement.getAsJsonObject().get("aliases").getAsJsonArray()) {
                if (!alias.getAsString().equals(value)) continue;
                return true;
            }
            return false;
        }).findAny()).isPresent()) {
            JsonObject jsonObject = optional.get().getAsJsonObject();
            try {
                return (System)this.f.createQuery("select system from System system where system.rid = :rid", System.class).setParameter("rid", (Object)jsonObject.get("id").getAsInt()).getSingleResult();
            }
            catch (NoResultException e2) {
                return new System(jsonObject.get("id").getAsInt(), jsonObject.get("name").getAsString(), new Image(jsonObject.get("graphic").getAsString()));
            }
        }
        try {
            return (System)this.f.createQuery("select system from System system where system.name like :name", System.class).setParameter("name", (Object)value).setMaxResults(1).getSingleResult();
        }
        catch (NoResultException e3) {
            return new System(null, value, null);
        }
    }

    private JsonObject b(X emulator) throws IOException {
        if (this.i == null) {
            try (InputStreamReader reader = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("/importer/legacy/emulators_files.json"));){
                JsonParser jsonParser = new JsonParser();
                this.i = jsonParser.parse((Reader)reader).getAsJsonArray();
            }
        }
        for (Z emulatorProfile : emulator.getProfiles()) {
            try {
                a task = new a(Paths.get(emulatorProfile.d(), new String[0]));
                task.run();
                String crc32 = (String)task.get();
                for (JsonElement jsonElement : this.i) {
                    JsonObject jsonObject = jsonElement.getAsJsonObject();
                    if (!jsonObject.get("crc32").getAsString().equals(crc32)) continue;
                    return jsonObject;
                }
            }
            catch (InterruptedException | ExecutionException exception) {
                RomStation.b().log(Level.SEVERE, exception.getMessage(), exception);
            }
        }
        return null;
    }

    private String b(String parameters) {
        Matcher matcher = this.d.matcher(parameters);
        while (matcher.find()) {
            parameters = parameters.replace(matcher.group(), "${" + matcher.group("cmd").toLowerCase() + "}");
        }
        return parameters;
    }

    private String c(String parameters) {
        Matcher matcher = this.e.matcher(parameters);
        while (matcher.find()) {
            parameters = parameters.replace(matcher.group(), "\"" + matcher.group("key") + "=" + matcher.group("value") + "\"");
        }
        return parameters;
    }

    protected /* synthetic */ Object call() throws Exception {
        return this.a();
    }
}

