/*
 * Decompiled with CFR 0.152.
 */
package org.romstation.application;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DialogPane;
import javafx.scene.control.ListView;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.control.Tooltip;
import javafx.stage.FileChooser;
import javafx.util.StringConverter;
import javafx.util.converter.IntegerStringConverter;
import javax.persistence.EntityManager;
import org.romstation.application.aC;
import org.romstation.application.aD;
import org.romstation.application.aI;
import org.romstation.application.aL;
import org.romstation.application.aT;
import org.romstation.application.database.entity.Genre;
import org.romstation.application.database.entity.I18n;
import org.romstation.application.database.entity.Image;
import org.romstation.application.database.entity.Language;
import org.romstation.application.database.entity.Locale;
import org.romstation.application.database.entity.Series;
import org.romstation.application.database.entity.System;
import org.romstation.application.database.entity.Translation;
import org.romstation.application.network.b;
import org.romstation.application.view.control.ApplicationAlert;
import org.romstation.application.view.control.ApplicationFXMLDialog;
import org.romstation.application.view.control.PathField;

public class bQ
extends ApplicationFXMLDialog<JsonObject> {
    private final JsonObject a;
    private final Path b;
    private Map<String, Locale> c;
    private List<System> d;
    private List<Language> e;
    private List<Genre> f;
    private List<Series> g;
    private List<Series> h;
    @FXML
    private DialogPane dialogPane;
    @FXML
    private TextField titleTextField;
    @FXML
    private ComboBox<System> systemComboBox;
    @FXML
    private TextField playersTextField;
    @FXML
    private TextField yearTextField;
    @FXML
    private ComboBox<String> developersComboBox;
    @FXML
    private ComboBox<String> publishersComboBox;
    @FXML
    private PathField imagePathField;
    @FXML
    private TextArea descriptionTextAreaEN;
    @FXML
    private TextArea descriptionTextAreaFR;
    @FXML
    private TextArea tipsTextAreaEN;
    @FXML
    private TextArea tipsTextAreaFR;
    @FXML
    private TextField fileNameTextField;
    @FXML
    private TextField filePathTextField;
    @FXML
    private PathField fileTargetPathField;
    @FXML
    private TextField fileParametersTextField;
    @FXML
    private CheckBox demoCheckBox;
    @FXML
    private CheckBox fangameCheckBox;
    @FXML
    private CheckBox fantradCheckBox;
    @FXML
    private CheckBox hackromCheckBox;
    @FXML
    private CheckBox homebrewCheckBox;
    @FXML
    private ListView<Language> languagesListView;
    @FXML
    private Button removeLanguageButton;
    @FXML
    private ListView<Genre> genresListView;
    @FXML
    private Button removeGenreButton;
    @FXML
    private ListView<Series> seriesListView;
    @FXML
    private Button removeSeriesButton;

    public bQ(JsonObject uploadJsonObject, Path archive) {
        this.a = uploadJsonObject;
        this.b = archive;
        this.load(((Object)((Object)this)).getClass().getResource("/fxml/dialog/upload/gameUploadFormDialog.fxml"));
    }

    @FXML
    private void initialize() {
        this.systemComboBox.getSelectionModel().selectedItemProperty().addListener((observableValue, oldValue, newValue) -> {
            boolean isTargetRequired = this.b();
            this.fileTargetPathField.setDisable(!isTargetRequired);
            this.fileParametersTextField.setDisable(!isTargetRequired);
        });
        EntityManager entityManager = org.romstation.application.b.c();
        this.c = this.a(entityManager);
        this.d = this.a(this.a.getAsJsonObject("form").getAsJsonArray("systems"));
        this.e = this.a(this.a.getAsJsonObject("form").getAsJsonArray("languages"), this.c);
        this.f = this.b(this.a.getAsJsonObject("form").getAsJsonArray("genres"), this.c);
        this.g = this.b(entityManager);
        this.h = this.b(this.a.getAsJsonObject("form").getAsJsonArray("series"));
        this.systemComboBox.getItems().setAll(this.d);
        this.systemComboBox.getSelectionModel().selectFirst();
        this.playersTextField.setTextFormatter(new TextFormatter((StringConverter)new IntegerStringConverter()));
        this.yearTextField.setTextFormatter(new TextFormatter((StringConverter)new IntegerStringConverter()));
        List developers = entityManager.createQuery("SELECT developer.name FROM Developer developer ORDER BY developer.name ASC", String.class).getResultList();
        this.developersComboBox.getItems().setAll((Collection)developers);
        List publishers = entityManager.createQuery("SELECT publisher.name FROM Publisher publisher ORDER BY publisher.name ASC", String.class).getResultList();
        this.publishersComboBox.getItems().setAll((Collection)publishers);
        Tooltip tooltip = new Tooltip();
        tooltip.textProperty().bind((ObservableValue)this.imagePathField.pathProperty());
        Tooltip.install((Node)this.imagePathField.getTextField(), (Tooltip)tooltip);
        this.imagePathField.getTextField().setEditable(false);
        this.filePathTextField.setText(this.b.toString());
        this.fileTargetPathField.getTextField().setEditable(false);
        this.removeLanguageButton.disableProperty().bind((ObservableValue)Bindings.size((ObservableList)this.languagesListView.getSelectionModel().getSelectedItems()).isEqualTo(0));
        this.languagesListView.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.removeGenreButton.disableProperty().bind((ObservableValue)Bindings.size((ObservableList)this.genresListView.getSelectionModel().getSelectedItems()).isEqualTo(0));
        this.genresListView.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.removeSeriesButton.disableProperty().bind((ObservableValue)Bindings.size((ObservableList)this.seriesListView.getSelectionModel().getSelectedItems()).isEqualTo(0));
        this.seriesListView.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        entityManager.close();
        if (this.a.get("resume") != null) {
            this.a(this.a.getAsJsonObject("resume"));
            this.systemComboBox.setDisable(true);
        }
        this.fileNameTextField.textProperty().bind((ObservableValue)this.titleTextField.textProperty());
        Button nextButton = (Button)this.dialogPane.lookupButton(ButtonType.OK);
        nextButton.addEventFilter(ActionEvent.ACTION, event -> {
            if (!this.a()) {
                event.consume();
            }
        });
        this.setResizable(true);
    }

    private void a(JsonObject resumeObject) {
        this.titleTextField.setText(resumeObject.get("title").getAsString());
        this.d.stream().filter(system -> system.getRid().equals(resumeObject.get("console_id").getAsInt())).findAny().ifPresent(system -> this.systemComboBox.getSelectionModel().select(system));
        this.playersTextField.setText(resumeObject.get("players").getAsString());
        this.yearTextField.setText(resumeObject.get("release_date").getAsString());
        this.developersComboBox.setValue((Object)resumeObject.get("developer").getAsString());
        this.publishersComboBox.setValue(resumeObject.get("publisher").isJsonNull() ? null : resumeObject.get("publisher").getAsString());
        this.descriptionTextAreaEN.setText(resumeObject.getAsJsonObject("description").get("en").getAsString());
        this.descriptionTextAreaFR.setText(resumeObject.getAsJsonObject("description").get("fr").getAsString());
        this.tipsTextAreaEN.setText(resumeObject.getAsJsonObject("tips").get("en").getAsString());
        this.tipsTextAreaFR.setText(resumeObject.getAsJsonObject("tips").get("fr").getAsString());
        this.fileNameTextField.setText(resumeObject.getAsJsonObject("file").get("name").getAsString());
        this.fileTargetPathField.setPath(resumeObject.getAsJsonObject("file").get("target").getAsString());
        this.fileParametersTextField.setText(resumeObject.getAsJsonObject("file").get("parameters").getAsString());
        this.demoCheckBox.setSelected(resumeObject.get("demo").getAsBoolean());
        this.fangameCheckBox.setSelected(resumeObject.get("fangame").getAsBoolean());
        this.fantradCheckBox.setSelected(resumeObject.get("fantrad").getAsBoolean());
        this.hackromCheckBox.setSelected(resumeObject.get("hack").getAsBoolean());
        this.homebrewCheckBox.setSelected(resumeObject.get("homebrew").getAsBoolean());
        resumeObject.getAsJsonArray("languages").forEach(element -> {
            int id = element.getAsJsonObject().get("id").getAsInt();
            this.e.stream().filter(language -> language.getRid().equals(id)).findAny().ifPresent(language -> this.languagesListView.getItems().add(language));
        });
        resumeObject.getAsJsonArray("genres").forEach(element -> {
            int id = element.getAsJsonObject().get("id").getAsInt();
            this.f.stream().filter(genre -> genre.getRid().equals(id)).findAny().ifPresent(genre -> this.genresListView.getItems().add(genre));
        });
        resumeObject.getAsJsonArray("series").forEach(element -> {
            int id = element.getAsJsonObject().get("id").getAsInt();
            this.h.stream().filter(series -> series.getRid().equals(id)).findAny().ifPresent(series -> this.seriesListView.getItems().add(series));
        });
    }

    private Map<String, Locale> a(EntityManager entityManager) {
        return entityManager.createNamedQuery("Locale.findAll", Locale.class).getResultList().stream().collect(Collectors.toMap(Locale::getTag, Function.identity()));
    }

    private List<System> a(JsonArray array) {
        LinkedList<System> items = new LinkedList<System>();
        array.forEach(jsonElement -> {
            JsonObject jsonObject = jsonElement.getAsJsonObject();
            System system = new System(jsonObject.get("id").getAsInt(), jsonObject.get("name").getAsString(), new Image(org.romstation.application.network.b.b() + jsonObject.get("image").getAsString(), true));
            items.add(system);
        });
        return items;
    }

    private List<Language> a(JsonArray array, Map<String, Locale> locales) {
        LinkedList<Language> items = new LinkedList<Language>();
        array.forEach(jsonElement -> {
            JsonObject jsonObject = jsonElement.getAsJsonObject();
            I18n name = new I18n();
            name.getTranslations().add(new Translation((Locale)locales.get("fr"), jsonObject.get("name_fr").getAsString(), name));
            name.getTranslations().add(new Translation((Locale)locales.get("en"), jsonObject.get("name_en").getAsString(), name));
            Image image = new Image(org.romstation.application.network.b.b() + jsonObject.get("image").getAsString(), true);
            Language language = new Language(jsonObject.get("id").getAsInt(), name, image);
            items.add(language);
        });
        return items;
    }

    private List<Genre> b(JsonArray array, Map<String, Locale> locales) {
        LinkedList<Genre> items = new LinkedList<Genre>();
        array.forEach(jsonElement -> {
            JsonObject jsonObject = jsonElement.getAsJsonObject();
            I18n name = new I18n();
            name.getTranslations().add(new Translation((Locale)locales.get("fr"), jsonObject.get("name_fr").getAsString(), name));
            name.getTranslations().add(new Translation((Locale)locales.get("en"), jsonObject.get("name_en").getAsString(), name));
            Genre genre = new Genre(jsonObject.get("id").getAsInt(), name);
            items.add(genre);
        });
        return items;
    }

    private List<Series> b(EntityManager entityManager) {
        return entityManager.createNamedQuery("Series.findAll", Series.class).getResultList();
    }

    private List<Series> b(JsonArray array) {
        LinkedList<Series> items = new LinkedList<Series>();
        array.forEach(jsonElement -> {
            JsonObject jsonObject = jsonElement.getAsJsonObject();
            Series series = new Series(jsonObject.get("id").getAsInt(), jsonObject.get("name").getAsString());
            items.add(series);
        });
        return items;
    }

    private boolean a() {
        if (this.titleTextField.getText().trim().isEmpty()) {
            new ApplicationAlert(this.getResources().getString("gameUploadFormDialog.validationError.header"), this.getResources().getString("gameUploadFormDialog.validationError.title"), Alert.AlertType.ERROR).showAndWait();
            return false;
        }
        if (this.playersTextField.getText().trim().isEmpty()) {
            new ApplicationAlert(this.getResources().getString("gameUploadFormDialog.validationError.header"), this.getResources().getString("gameUploadFormDialog.validationError.players"), Alert.AlertType.ERROR).showAndWait();
            return false;
        }
        if (this.yearTextField.getText().trim().isEmpty()) {
            new ApplicationAlert(this.getResources().getString("gameUploadFormDialog.validationError.header"), this.getResources().getString("gameUploadFormDialog.validationError.year"), Alert.AlertType.ERROR).showAndWait();
            return false;
        }
        if (this.developersComboBox.getValue() == null || ((String)this.developersComboBox.getValue()).trim().isEmpty()) {
            new ApplicationAlert(this.getResources().getString("gameUploadFormDialog.validationError.header"), this.getResources().getString("gameUploadFormDialog.validationError.developer"), Alert.AlertType.ERROR).showAndWait();
            return false;
        }
        if (this.imagePathField.getPath() == null) {
            new ApplicationAlert(this.getResources().getString("gameUploadFormDialog.validationError.header"), this.getResources().getString("gameUploadFormDialog.validationError.coverImage"), Alert.AlertType.ERROR).showAndWait();
            return false;
        }
        if (this.descriptionTextAreaEN.getText().trim().isEmpty() && this.descriptionTextAreaFR.getText().trim().isEmpty()) {
            new ApplicationAlert(this.getResources().getString("gameUploadFormDialog.validationError.header"), this.getResources().getString("gameUploadFormDialog.validationError.description"), Alert.AlertType.ERROR).showAndWait();
            return false;
        }
        if (this.fileNameTextField.getText().trim().isEmpty()) {
            new ApplicationAlert(this.getResources().getString("gameUploadFormDialog.validationError.header"), this.getResources().getString("gameUploadFormDialog.validationError.file.name"), Alert.AlertType.ERROR).showAndWait();
            return false;
        }
        if (this.b() && this.fileTargetPathField.getPath() == null) {
            new ApplicationAlert(this.getResources().getString("gameUploadFormDialog.validationError.header"), this.getResources().getString("gameUploadFormDialog.validationError.file.target"), Alert.AlertType.ERROR).showAndWait();
            return false;
        }
        if (this.languagesListView.getItems().isEmpty()) {
            new ApplicationAlert(this.getResources().getString("gameUploadFormDialog.validationError.header"), this.getResources().getString("gameUploadFormDialog.validationError.languages"), Alert.AlertType.ERROR).showAndWait();
            return false;
        }
        if (this.genresListView.getItems().isEmpty()) {
            new ApplicationAlert(this.getResources().getString("gameUploadFormDialog.validationError.header"), this.getResources().getString("gameUploadFormDialog.validationError.genres"), Alert.AlertType.ERROR).showAndWait();
            return false;
        }
        return true;
    }

    private boolean b() {
        int systemID = ((System)this.systemComboBox.getValue()).getRid();
        return systemID == 20 || systemID == 26 || systemID == 35 || systemID == 36;
    }

    @FXML
    private void selectImagePath(ActionEvent actionEvent) {
        File file;
        Path path;
        FileChooser fileChooser = new FileChooser();
        fileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter(this.getResources().getString("gameUploadFormDialog.coverImage.extensionFilter.description"), new String[]{"*.jpg", "*.png"}));
        if (this.imagePathField.getPath() != null && Files.exists(path = Paths.get(this.imagePathField.getPath(), new String[0]), new LinkOption[0])) {
            fileChooser.setInitialDirectory(path.getParent().toFile());
            fileChooser.setInitialFileName(path.toString());
        }
        if ((file = fileChooser.showOpenDialog(this.getDialogPane().getScene().getWindow())) != null) {
            if (this.a(file)) {
                this.imagePathField.setPath(file.toString());
            } else {
                new ApplicationAlert(this.getResources().getString("gameUploadFormDialog.coverImage.error.formatInvalid.header"), this.getResources().getString("gameUploadFormDialog.coverImage.error.formatInvalid.content"), Alert.AlertType.ERROR).showAndWait();
            }
        }
    }

    private boolean a(File file) {
        String contentType = URLConnection.guessContentTypeFromName(file.getName());
        if (contentType != null && (contentType.equals("image/jpeg") || contentType.equals("image/png"))) {
            javafx.scene.image.Image image = new javafx.scene.image.Image(file.toURI().toString());
            return !image.isError();
        }
        return false;
    }

    @FXML
    private void selectFileTarget(ActionEvent actionEvent) {
        aL zipEntryChoiceDialog = new aL(this.getResources().getString("gameUploadFormDialog.file.target.chooser.header"), Paths.get(this.filePathTextField.getText(), new String[0]));
        zipEntryChoiceDialog.showAndWait().ifPresent(path -> this.fileTargetPathField.setPath(path.toString()));
    }

    @FXML
    private void addLanguage() {
        List<Language> collection = this.e.stream().filter(language -> !this.languagesListView.getItems().contains(language)).collect(Collectors.toList());
        aD dialog = new aD(collection);
        dialog.c().getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        Optional optional = dialog.showAndWait();
        optional.ifPresent(items -> this.languagesListView.getItems().addAll((Collection)items));
    }

    @FXML
    private void removeLanguage() {
        this.languagesListView.getItems().removeAll((Collection)this.languagesListView.getSelectionModel().getSelectedItems());
    }

    @FXML
    private void addGenre() {
        List<Genre> collection = this.f.stream().filter(language -> !this.genresListView.getItems().contains(language)).collect(Collectors.toList());
        aC dialog = new aC(collection);
        dialog.c().getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        Optional optional = dialog.showAndWait();
        optional.ifPresent(items -> this.genresListView.getItems().addAll((Collection)items));
    }

    @FXML
    private void removeGenre() {
        this.genresListView.getItems().removeAll((Collection)this.genresListView.getSelectionModel().getSelectedItems());
    }

    @FXML
    private void createLocalSeries() {
        aT dialog = new aT(new Series());
        Optional optional = dialog.showAndWait();
        optional.ifPresent(arg_0 -> this.seriesListView.getItems().add(arg_0));
    }

    @FXML
    private void addLocalSeries() {
        List<Series> collection = this.g.stream().filter(series -> !this.seriesListView.getItems().contains(series)).collect(Collectors.toList());
        aI dialog = new aI(collection);
        dialog.c().getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        Optional optional = dialog.showAndWait();
        optional.ifPresent(items -> this.seriesListView.getItems().addAll((Collection)items));
    }

    @FXML
    private void addRemoteSeries() {
        List<Series> collection = this.h.stream().filter(language -> !this.seriesListView.getItems().contains(language)).collect(Collectors.toList());
        aI dialog = new aI(collection);
        dialog.c().getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        Optional optional = dialog.showAndWait();
        optional.ifPresent(items -> this.seriesListView.getItems().addAll((Collection)items));
    }

    @FXML
    private void removeSeries() {
        this.seriesListView.getItems().removeAll((Collection)this.seriesListView.getSelectionModel().getSelectedItems());
    }

    @Override
    protected Object controllerFactory(Class<?> classType) {
        return this;
    }

    protected JsonObject a(ButtonType buttonType) {
        if (buttonType == ButtonType.OK) {
            JsonObject object = new JsonObject();
            object.addProperty("title", this.titleTextField.getText());
            object.addProperty("system", (Number)((System)this.systemComboBox.getValue()).getRid());
            object.addProperty("players", (Number)Integer.parseInt(this.playersTextField.getText()));
            object.addProperty("year", (Number)Integer.parseInt(this.yearTextField.getText()));
            object.addProperty("developer", (String)this.developersComboBox.getValue());
            object.addProperty("publisher", (String)this.publishersComboBox.getValue());
            object.addProperty("image", this.imagePathField.getPath());
            JsonObject descriptionObject = new JsonObject();
            descriptionObject.addProperty("en", this.descriptionTextAreaEN.getText());
            descriptionObject.addProperty("fr", this.descriptionTextAreaFR.getText());
            object.add("description", (JsonElement)descriptionObject);
            JsonObject tipsObject = new JsonObject();
            tipsObject.addProperty("en", this.tipsTextAreaEN.getText());
            tipsObject.addProperty("fr", this.tipsTextAreaFR.getText());
            object.add("tips", (JsonElement)tipsObject);
            JsonObject fileObject = new JsonObject();
            fileObject.addProperty("name", this.fileNameTextField.getText());
            fileObject.addProperty("path", this.filePathTextField.getText());
            fileObject.addProperty("target", this.fileTargetPathField.getPath());
            fileObject.addProperty("parameters", this.fileParametersTextField.getText());
            object.add("file", (JsonElement)fileObject);
            JsonObject typeObject = new JsonObject();
            typeObject.addProperty("demo", Boolean.valueOf(this.demoCheckBox.isSelected()));
            typeObject.addProperty("fangame", Boolean.valueOf(this.fangameCheckBox.isSelected()));
            typeObject.addProperty("fantrad", Boolean.valueOf(this.fantradCheckBox.isSelected()));
            typeObject.addProperty("hackgame", Boolean.valueOf(this.hackromCheckBox.isSelected()));
            typeObject.addProperty("homebrew", Boolean.valueOf(this.homebrewCheckBox.isSelected()));
            object.add("type", (JsonElement)typeObject);
            JsonArray languagesArray = new JsonArray();
            this.languagesListView.getItems().forEach(language -> languagesArray.add((Number)language.getRid()));
            object.add("languages", (JsonElement)languagesArray);
            JsonArray genresArray = new JsonArray();
            this.genresListView.getItems().forEach(genre -> genresArray.add((Number)genre.getRid()));
            object.add("genres", (JsonElement)genresArray);
            JsonArray seriesArray = new JsonArray();
            this.seriesListView.getItems().forEach(series -> {
                JsonObject seriesObject = new JsonObject();
                seriesObject.addProperty("id", (Number)series.getRid());
                seriesObject.addProperty("name", series.getName());
                seriesArray.add((JsonElement)seriesObject);
            });
            object.add("series", (JsonElement)seriesArray);
            return object;
        }
        return null;
    }

    @Override
    protected /* synthetic */ Object resultConverter(ButtonType buttonType) {
        return this.a(buttonType);
    }
}

