/*
 * Decompiled with CFR 0.152.
 */
package org.romstation.application;

import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.logging.Level;
import javafx.animation.AnimationTimer;
import javafx.beans.binding.Bindings;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.DialogEvent;
import javafx.scene.control.DialogPane;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.SplitMenuButton;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.StackPane;
import org.romstation.application.RomStation;
import org.romstation.application.ax;
import org.romstation.application.bR;
import org.romstation.application.bS;
import org.romstation.application.bT;
import org.romstation.application.cY;
import org.romstation.application.cZ;
import org.romstation.application.db;
import org.romstation.application.dd;
import org.romstation.application.di;
import org.romstation.application.dj;
import org.romstation.application.dk;
import org.romstation.application.view.control.ApplicationAlert;
import org.romstation.application.view.control.ApplicationFXMLDialog;
import org.romstation.application.virtualcontroller.device.a;
import org.romstation.application.virtualcontroller.device.b;
import org.romstation.application.virtualcontroller.device.c;
import org.romstation.application.virtualcontroller.device.d;

public class bU
extends ApplicationFXMLDialog<db>
implements Initializable {
    private final cZ a;
    private c b;
    private AnimationTimer c;
    private final HashMap<dk, Integer> d = new HashMap();
    @FXML
    private DialogPane dialogPane;
    @FXML
    private ChoiceBox<a> devicesChoiceBox;
    @FXML
    private SplitMenuButton refreshDevicesSplitMenuButton;
    @FXML
    private CheckMenuItem showAllDevicesCheckMenuItem;
    @FXML
    private ChoiceBox<db> profilesChoiceBox;
    @FXML
    private MenuItem createProfileMenuItem;
    @FXML
    private MenuItem copyProfileMenuItem;
    @FXML
    private MenuItem renameProfileMenuItem;
    @FXML
    private MenuItem deleteProfileMenuItem;
    @FXML
    private Button configurationWizardButton;
    @FXML
    private Button bindInputButton;
    @FXML
    private Button unbindInputButton;
    @FXML
    private Button configureInputButton;
    @FXML
    private TableView<dk> inputsTableView;
    @FXML
    private TableColumn<dk, String> inputNameTableColumn;
    @FXML
    private TableColumn<dk, cY> inputBindingTableColumn;
    @FXML
    private TableColumn<dk, Double> inputStateTableColumn;
    @FXML
    private Label controllerNameLabel;
    @FXML
    private StackPane controllerStackPane;
    @FXML
    private ImageView controllerImageView;

    public bU(cZ config) {
        this.a = config;
        this.load(((Object)((Object)this)).getClass().getResource("/fxml/dialog/virtualcontroller/virtualControllerConfigurationDialog.fxml"));
        this.setOnCloseRequest(this::a);
        this.setResizable(true);
    }

    public void initialize(URL url, ResourceBundle resourceBundle) {
        this.devicesChoiceBox.valueProperty().addListener((observableValue, previous, current) -> {
            if (!this.profilesChoiceBox.getSelectionModel().isEmpty()) {
                ((db)this.profilesChoiceBox.getValue()).a((a)current);
            }
        });
        this.devicesChoiceBox.disableProperty().bind((ObservableValue)this.profilesChoiceBox.valueProperty().isNull());
        this.refreshDevicesSplitMenuButton.disableProperty().bind((ObservableValue)this.profilesChoiceBox.valueProperty().isNull());
        this.profilesChoiceBox.getItems().setAll(this.a.e());
        this.profilesChoiceBox.valueProperty().addListener((observableValue, previous, current) -> {
            if (current != null) {
                this.devicesChoiceBox.getSelectionModel().select((Object)current.b());
                this.inputsTableView.getItems().setAll(current.c());
            } else {
                this.devicesChoiceBox.getSelectionModel().clearSelection();
                this.inputsTableView.getItems().clear();
            }
        });
        this.profilesChoiceBox.getSelectionModel().select((Object)this.a.d());
        this.copyProfileMenuItem.disableProperty().bind((ObservableValue)this.profilesChoiceBox.valueProperty().isNull());
        this.renameProfileMenuItem.disableProperty().bind((ObservableValue)this.profilesChoiceBox.valueProperty().isNull());
        this.deleteProfileMenuItem.disableProperty().bind((ObservableValue)this.profilesChoiceBox.valueProperty().isNull());
        this.configurationWizardButton.disableProperty().bind((ObservableValue)this.profilesChoiceBox.valueProperty().isNull());
        this.bindInputButton.disableProperty().bind((ObservableValue)Bindings.size((ObservableList)this.inputsTableView.getSelectionModel().getSelectedItems()).isNotEqualTo(1));
        this.unbindInputButton.disableProperty().bind((ObservableValue)this.inputsTableView.getSelectionModel().selectedItemProperty().isNull());
        this.configureInputButton.disableProperty().bind((ObservableValue)Bindings.size((ObservableList)this.inputsTableView.getSelectionModel().getSelectedItems()).isNotEqualTo(1));
        this.inputsTableView.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.inputsTableView.setRowFactory(tableView -> {
            TableRow row = new TableRow();
            row.setOnMouseClicked(event -> {
                if (!row.isEmpty() && event.getClickCount() == 2) {
                    this.a((a)this.devicesChoiceBox.getValue(), (dk)row.getItem());
                }
            });
            return row;
        });
        this.inputNameTableColumn.setCellValueFactory(cell -> new SimpleObjectProperty((Object)((dk)cell.getValue()).d()));
        this.inputBindingTableColumn.setCellValueFactory(cell -> new SimpleObjectProperty((Object)((dk)cell.getValue()).e()));
        this.inputStateTableColumn.setCellValueFactory(cell -> {
            if (this.devicesChoiceBox.getSelectionModel().isEmpty()) {
                return new SimpleObjectProperty((Object)0.0);
            }
            return new SimpleObjectProperty((Object)((a)this.devicesChoiceBox.getValue()).a((dk)cell.getValue()));
        });
        this.controllerNameLabel.setText(this.a.a());
        if (this.a.b() != null) {
            this.controllerImageView.setImage(new Image(this.a.b()));
            this.controllerImageView.fitWidthProperty().bind((ObservableValue)this.controllerStackPane.widthProperty());
            this.controllerImageView.fitHeightProperty().bind((ObservableValue)this.controllerStackPane.heightProperty());
        }
        this.c = new AnimationTimer(){

            public void handle(long now) {
                bU.this.a(now);
            }
        };
        this.c.start();
        this.b = new c((Node)this.dialogPane);
        this.a();
    }

    private void a(long now) {
        a device;
        boolean refresh = false;
        if (this.getDialogPane().getScene().getWindow().isFocused() && (device = (a)this.devicesChoiceBox.getValue()) != null && device.c()) {
            for (dk input : this.inputsTableView.getItems()) {
                int value;
                Integer cache = this.d.put(input, value = (int)(device.a(input) * 100.0f));
                if (cache == null) {
                    refresh = true;
                    continue;
                }
                if (value == cache) continue;
                refresh = true;
            }
            if (refresh) {
                this.inputsTableView.refresh();
            }
        }
    }

    private void a(DialogEvent event) {
        this.c.stop();
    }

    private void a(a device, dk input) {
        bS dialog = new bS(device, input);
        dialog.showAndWait().ifPresent(binding -> {
            input.a((cY)binding);
            this.inputsTableView.refresh();
        });
    }

    @FXML
    private void refreshDevices(ActionEvent event) {
        this.a();
    }

    private void a() {
        a selectedItem = (a)this.devicesChoiceBox.getSelectionModel().getSelectedItem();
        this.devicesChoiceBox.getItems().clear();
        d keyboardMouseDevice = org.romstation.application.virtualcontroller.device.d.f();
        keyboardMouseDevice.a(this.b);
        this.devicesChoiceBox.getItems().add((Object)keyboardMouseDevice);
        if (this.showAllDevicesCheckMenuItem.isSelected()) {
            this.devicesChoiceBox.getItems().addAll(org.romstation.application.virtualcontroller.device.b.i());
        } else {
            this.devicesChoiceBox.getItems().addAll(org.romstation.application.virtualcontroller.device.b.h());
        }
        this.devicesChoiceBox.getSelectionModel().select((Object)selectedItem);
    }

    @FXML
    private void createProfile(ActionEvent event) {
        ax textInputDialog = new ax(this.getResources().getString("virtualControllerConfigurationDialog.profile.name.dialog.header"));
        textInputDialog.showAndWait().ifPresent(name -> {
            try {
                db profile = dd.a(this.a.c());
                profile.a((String)name);
                this.profilesChoiceBox.getItems().add((Object)profile);
                this.profilesChoiceBox.getSelectionModel().select((Object)profile);
            }
            catch (Exception exception) {
                RomStation.b().log(Level.SEVERE, "failed to create controller profile", exception);
            }
        });
    }

    @FXML
    private void copyProfile(ActionEvent event) {
        ax textInputDialog = new ax(this.getResources().getString("virtualControllerConfigurationDialog.profile.name.dialog.header"), ((db)this.profilesChoiceBox.getValue()).a());
        textInputDialog.showAndWait().ifPresent(name -> {
            try {
                db profile = dd.a((db)this.profilesChoiceBox.getValue());
                profile.a((String)name);
                this.profilesChoiceBox.getItems().add((Object)profile);
                this.profilesChoiceBox.getSelectionModel().select((Object)profile);
            }
            catch (Exception exception) {
                RomStation.b().log(Level.SEVERE, "failed to copy controller profile", exception);
            }
        });
    }

    @FXML
    private void renameProfile(ActionEvent event) {
        db profile = (db)this.profilesChoiceBox.getValue();
        int index = this.profilesChoiceBox.getSelectionModel().getSelectedIndex();
        ax textInputDialog = new ax(this.getResources().getString("virtualControllerConfigurationDialog.profile.name.dialog.header"), profile.a());
        textInputDialog.showAndWait().ifPresent(name -> {
            profile.a((String)name);
            this.profilesChoiceBox.getItems().remove(index);
            this.profilesChoiceBox.getItems().add(index, (Object)profile);
            this.profilesChoiceBox.getSelectionModel().select(index);
        });
    }

    @FXML
    private void deleteProfile(ActionEvent event) {
        db selectedItem = (db)this.profilesChoiceBox.getSelectionModel().getSelectedItem();
        ApplicationAlert alert = new ApplicationAlert(this.getResources().getString("virtualControllerConfigurationDialog.profile.delete.alert.header"), String.format(this.getResources().getString("virtualControllerConfigurationDialog.profile.delete.alert.content"), selectedItem), Alert.AlertType.CONFIRMATION);
        alert.showAndWait().ifPresent(buttonType -> {
            if (buttonType == ButtonType.OK) {
                this.profilesChoiceBox.getItems().remove((Object)selectedItem);
                if (this.profilesChoiceBox.getItems().isEmpty()) {
                    try {
                        db profile = dd.a(this.a.c());
                        this.profilesChoiceBox.getItems().add((Object)profile);
                        this.profilesChoiceBox.getSelectionModel().select((Object)profile);
                    }
                    catch (Exception exception) {
                        RomStation.b().log(Level.SEVERE, "failed to create controller profile", exception);
                    }
                } else {
                    this.profilesChoiceBox.getSelectionModel().selectNext();
                }
            }
        });
    }

    @FXML
    private void configurationWizard(ActionEvent event) {
        a device = (a)this.devicesChoiceBox.getValue();
        if (device != null) {
            int row = 0;
            for (dk input : this.inputsTableView.getItems()) {
                this.inputsTableView.getSelectionModel().clearAndSelect(row);
                bS dialog = new bS(device, input);
                Optional optional = dialog.showAndWait();
                if (!optional.isPresent()) break;
                input.a((cY)optional.get());
                this.inputsTableView.refresh();
                ++row;
            }
        }
    }

    @FXML
    private void bindInput(ActionEvent event) {
        this.a((a)this.devicesChoiceBox.getValue(), (dk)this.inputsTableView.getSelectionModel().getSelectedItem());
    }

    @FXML
    private void configureInput(ActionEvent event) {
        dk input = (dk)this.inputsTableView.getSelectionModel().getSelectedItem();
        if (input instanceof dj) {
            bT dialog = new bT((a)this.devicesChoiceBox.getValue(), (dj)input);
            dialog.showAndWait();
        } else if (input instanceof di) {
            bR dialog = new bR((a)this.devicesChoiceBox.getValue(), (di)input);
            dialog.showAndWait();
        }
        if (this.devicesChoiceBox.getValue() != null && this.devicesChoiceBox.getValue() instanceof d) {
            ((d)this.devicesChoiceBox.getValue()).a(this.b);
        }
        this.inputsTableView.refresh();
    }

    @FXML
    private void clearInputBinding(ActionEvent event) {
        for (dk selectedItem : this.inputsTableView.getSelectionModel().getSelectedItems()) {
            selectedItem.a((cY)null);
        }
        this.inputsTableView.refresh();
    }

    @FXML
    public void keyPressed(KeyEvent event) {
        if (!this.inputsTableView.getSelectionModel().isEmpty() && event.getCode() == KeyCode.DELETE) {
            for (dk selectedItem : this.inputsTableView.getSelectionModel().getSelectedItems()) {
                selectedItem.a((cY)null);
            }
            this.inputsTableView.refresh();
        }
    }

    @FXML
    public void keyReleased(KeyEvent event) {
        if (!this.inputsTableView.getSelectionModel().isEmpty() && event.getCode() == KeyCode.ENTER) {
            this.a((a)this.devicesChoiceBox.getValue(), (dk)this.inputsTableView.getSelectionModel().getSelectedItem());
        }
    }

    @Override
    protected Object controllerFactory(Class<?> classType) {
        return this;
    }

    protected db a(ButtonType buttonType) {
        this.a.b((db)this.profilesChoiceBox.getValue());
        this.a.e().clear();
        this.a.e().addAll((Collection<db>)this.profilesChoiceBox.getItems());
        return (db)this.profilesChoiceBox.getValue();
    }

    @Override
    protected /* synthetic */ Object resultConverter(ButtonType buttonType) {
        return this.a(buttonType);
    }
}

