/*
 * Decompiled with CFR 0.152.
 */
package org.romstation.application;

import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import com.google.gson.JsonObject;
import java.awt.Desktop;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.util.Calendar;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Properties;
import java.util.logging.Level;
import javafx.animation.AnimationTimer;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.embed.swing.SwingFXUtils;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.Label;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuButton;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TextField;
import javafx.scene.control.ToolBar;
import javafx.scene.effect.BoxBlur;
import javafx.scene.effect.ColorAdjust;
import javafx.scene.effect.Effect;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;
import javafx.scene.text.TextFlow;
import javafx.stage.Stage;
import javafx.util.Duration;
import javax.imageio.ImageIO;
import org.freedesktop.gstreamer.Bin;
import org.freedesktop.gstreamer.Bus;
import org.freedesktop.gstreamer.Element;
import org.freedesktop.gstreamer.ElementFactory;
import org.freedesktop.gstreamer.GstObject;
import org.freedesktop.gstreamer.Pad;
import org.freedesktop.gstreamer.Pipeline;
import org.freedesktop.gstreamer.message.Message;
import org.romstation.application.A;
import org.romstation.application.E;
import org.romstation.application.H;
import org.romstation.application.J;
import org.romstation.application.RomStation;
import org.romstation.application.bF;
import org.romstation.application.bH;
import org.romstation.application.bU;
import org.romstation.application.bh;
import org.romstation.application.by;
import org.romstation.application.cI;
import org.romstation.application.cJ;
import org.romstation.application.cK;
import org.romstation.application.cZ;
import org.romstation.application.da;
import org.romstation.application.db;
import org.romstation.application.dc;
import org.romstation.application.dd;
import org.romstation.application.network.b;
import org.romstation.application.virtualcontroller.device.c;
import org.romstation.application.virtualcontroller.device.d;

public class cX {
    private static final int a = 100;
    private static final int b = 1;
    private static final int c = 10;
    private static final int d = 10;
    private static final int e = 30;
    private final EventBus f;
    private final String g;
    private final Image h;
    private final JsonObject i;
    private Timeline j;
    private Timeline k;
    private cZ l;
    private dc m;
    private c n;
    private AnimationTimer o;
    private Timeline p;
    private Pipeline q;
    private A r;
    private final BooleanProperty s = new SimpleBooleanProperty();
    private boolean t;
    @FXML
    private Stage stage;
    @FXML
    private Scene scene;
    @FXML
    private BorderPane borderPane;
    @FXML
    private MenuBar menuBar;
    @FXML
    private MenuItem saveStateMenuItem;
    @FXML
    private MenuItem loadStateMenuItem;
    @FXML
    private MenuItem resetMenuItem;
    @FXML
    private Menu driveMenu;
    @FXML
    private MenuItem openDriveMenuItem;
    @FXML
    private MenuItem changeMediumMenuItem;
    @FXML
    private MenuItem closeDriveMenuItem;
    @FXML
    private MenuItem openDriveToolBarMenuItem;
    @FXML
    private MenuItem changeMediumToolBarMenuItem;
    @FXML
    private MenuItem closeDriveToolBarMenuItem;
    @FXML
    private CheckMenuItem fullscreenMenuItem;
    @FXML
    private CheckMenuItem stretchMenuItem;
    @FXML
    private CheckMenuItem preserveRatioMenuItem;
    @FXML
    private CheckMenuItem alwaysOnTopMenuItem;
    @FXML
    private CheckMenuItem muteMenuItem;
    @FXML
    private CheckMenuItem toolBarMenuItem;
    @FXML
    private CheckMenuItem playerMessagesMenuItem;
    @FXML
    private ToolBar toolBar;
    @FXML
    private Button saveStateButton;
    @FXML
    private Button loadStateButton;
    @FXML
    private Button resetButton;
    @FXML
    private MenuButton driveMenuButton;
    @FXML
    private Button controllerButton;
    @FXML
    private StackPane stackPane;
    @FXML
    private VBox osdMessagesVBox;
    @FXML
    private TextField chatTextField;
    @FXML
    private Label loadingLabel;
    @FXML
    private ImageView imageView;

    public cX(EventBus lobbyEventBus, String title, Image graphic, JsonObject json) throws IOException {
        this.f = lobbyEventBus;
        this.g = title;
        this.h = graphic;
        this.i = json;
        FXMLLoader fxmlLoader = new FXMLLoader();
        fxmlLoader.setLocation(this.getClass().getResource("/fxml/stage/cloudPlayer.fxml"));
        fxmlLoader.setResources(RomStation.d());
        fxmlLoader.setControllerFactory(type -> this);
        fxmlLoader.load();
    }

    public da a() {
        return this.m != null ? this.m.b() : null;
    }

    public void a(da credential) {
        if (this.m != null) {
            this.m.a(credential);
        }
    }

    public Stage b() {
        return this.stage;
    }

    public void c() {
        this.q.play();
        this.s.set(true);
    }

    public void d() {
        this.q.stop();
        this.r.b();
    }

    public void e() {
        this.d();
        this.c();
    }

    @FXML
    public void close() {
        this.stage.close();
    }

    @FXML
    private void stageHidden() {
        this.f.unregister((Object)this);
        this.o.stop();
        this.p.stop();
        this.k.stop();
        if (this.m != null) {
            this.m.f();
            if (this.m.c() != null) {
                this.m.c().d();
            }
            this.f();
        }
        this.q.stop();
        this.q.close();
        Properties settings = RomStation.c();
        settings.setProperty("cloudPlayer.video.stretch", String.valueOf(this.stretchMenuItem.isSelected()));
        settings.setProperty("cloudPlayer.video.preserveRatio", String.valueOf(this.preserveRatioMenuItem.isSelected()));
        settings.setProperty("cloudPlayer.video.alwaysOnTop", String.valueOf(this.alwaysOnTopMenuItem.isSelected()));
        settings.setProperty("cloudPlayer.audio.mute", String.valueOf(this.muteMenuItem.isSelected()));
        settings.setProperty("cloudPlayer.view.toolbar", String.valueOf(this.toolBarMenuItem.isSelected()));
        settings.setProperty("cloudPlayer.view.playerMessages", String.valueOf(this.playerMessagesMenuItem.isSelected()));
    }

    private void a(Bin bin, Bin subBin, Element element) {
        if ("GstRtpJitterBuffer".equals(element.getTypeName())) {
            element.set("post-drop-messages", (Object)true);
            element.set("drop-messages-interval", (Object)1000);
        }
    }

    private void a(Bus bus, Message message) {
        block0 : switch (message.getType()) {
            case ELEMENT: {
                if (message.getStructure() == null) break;
                switch (message.getStructure().getName()) {
                    case "GstRTSPSrcTimeout": {
                        Platform.runLater(this::e);
                        break block0;
                    }
                    case "drop-msg": {
                        switch (message.getStructure().getString("reason")) {
                            case "too-late": {
                                int latency;
                                int newLatency;
                                int latePackets = (Integer)message.getStructure().getValue("num-too-late");
                                RomStation.b().log(Level.INFO, String.format("[gstreamer] late packets: %d", latePackets));
                                if (!this.t || (newLatency = Math.min((latency = ((Integer)message.getSource().get("latency")).intValue()) + 10, 100)) == latency) break block0;
                                message.getSource().set("latency", (Object)newLatency);
                                RomStation.b().log(Level.INFO, String.format("[gstreamer] new latency: %d", newLatency));
                                break block0;
                            }
                            case "drop-on-latency": {
                                int droppedPackets = (Integer)message.getStructure().getValue("num-drop-on-latency");
                                RomStation.b().log(Level.INFO, String.format("[gstreamer] dropped packets: %d", droppedPackets));
                                break block0;
                            }
                        }
                    }
                }
            }
        }
    }

    private void a(GstObject source, int code, String message) {
        switch (code) {
            case 3: {
                Platform.runLater(() -> this.p.play());
            }
        }
    }

    private void a(long now) {
        Image frame = this.r.c();
        if (frame != null) {
            this.s.set(false);
            this.imageView.setImage(frame);
        }
        if (this.m != null) {
            try {
                this.m.e();
            }
            catch (IOException exception) {
                RomStation.b().log(Level.SEVERE, "failed to send inputs to the server", exception);
            }
        }
    }

    private cZ a(int id) throws IOException {
        try {
            return dd.a(Paths.get(String.format("controllers/%d/config.json", id), new String[0]));
        }
        catch (NoSuchFileException exception) {
            String source = String.format("%s/romstation/resources/cloud/controllers/%d", org.romstation.application.network.b.b(), this.i.getAsJsonObject("controller").get("id").getAsInt());
            cZ config = dd.a(new URL(String.format("%s/config.json", source)));
            Path target = Paths.get(String.format("controllers/%d/controller.png", id), new String[0]);
            if (!Files.isDirectory(target.getParent(), new LinkOption[0])) {
                Files.createDirectories(target.getParent(), new FileAttribute[0]);
            }
            try (InputStream inputStream = new URL(String.format("%s/controller.png", source)).openStream();){
                Files.copy(inputStream, target, StandardCopyOption.REPLACE_EXISTING);
                config.b(String.format("file:%s", target));
            }
            return config;
        }
    }

    private void f() {
        try {
            Path target = Paths.get(String.format("controllers/%d/config.json", this.i.getAsJsonObject("controller").get("id").getAsInt()), new String[0]);
            if (!Files.isDirectory(target.getParent(), new LinkOption[0])) {
                Files.createDirectories(target.getParent(), new FileAttribute[0]);
            }
            dd.a(target, this.l);
        }
        catch (IOException exception) {
            RomStation.b().log(Level.SEVERE, "failed to save virtual controller config", exception);
        }
    }

    private void a(db profile) {
        this.l.b(profile);
        this.m.a(profile);
        if (this.m.c() != null && this.m.c() instanceof d) {
            ((d)this.m.c()).a(this.n);
        }
        this.a(String.format(RomStation.d().getString("cloudPlayer.message.profileLoaded"), profile.a()));
    }

    private void g() {
        bh decoder;
        LinkedList<Object> videoElements = new LinkedList<Object>();
        LinkedList<Element> audioElements = new LinkedList<Element>();
        Element source = ElementFactory.make((String)"rtspsrc", (String)"source");
        source.set("location", (Object)this.i.getAsJsonObject("stream").get("uri").getAsString());
        source.set("latency", (Object)this.i.getAsJsonObject("stream").get("default-latency").getAsInt());
        source.set("do-retransmission", (Object)false);
        source.set("drop-on-latency", (Object)this.i.getAsJsonObject("stream").get("drop-on-latency").getAsBoolean());
        source.connect((element, pad) -> {
            if (pad.getName().startsWith("recv_rtp_src")) {
                switch (pad.getCurrentCaps().getStructure(0).getString("media")) {
                    case "video": {
                        Pad sinkPad;
                        Element videoDepay = this.q.getElementByName("video-depay");
                        if (videoDepay == null || (sinkPad = videoDepay.getStaticPad("sink")) == null || sinkPad.isLinked()) break;
                        pad.link(sinkPad);
                        break;
                    }
                    case "audio": {
                        Pad sinkPad;
                        Element audioDepay = this.q.getElementByName("audio-depay");
                        if (audioDepay == null || (sinkPad = audioDepay.getStaticPad("sink")) == null || sinkPad.isLinked()) break;
                        pad.link(sinkPad);
                    }
                }
            }
        });
        videoElements.add(ElementFactory.make((String)"rtph264depay", (String)"video-depay"));
        videoElements.add(ElementFactory.make((String)"h264parse", (String)"video-parse"));
        try {
            decoder = bh.a(Integer.parseInt(RomStation.c().getProperty("cloudPlayer.decoder")));
        }
        catch (Exception exception) {
            RomStation.b().log(Level.WARNING, "invalid video decoder requested", exception);
            decoder = bh.AUTO;
        }
        block3 : switch (E.c()) {
            case WINDOWS: {
                Element videoDecoder;
                if (decoder == bh.AUTO) {
                    decoder = bh.SOFTWARE;
                    try {
                        H d3dFeatureLevel = J.b();
                        RomStation.b().log(Level.INFO, String.format("%s detected", new Object[]{d3dFeatureLevel}));
                        if (d3dFeatureLevel.a() >= H.D3D_FEATURE_LEVEL_11_1.a()) {
                            RomStation.b().log(Level.INFO, "DirectX feature level is compatible with hardware decoder");
                            decoder = bh.HARDWARE;
                        } else {
                            RomStation.b().log(Level.WARNING, "DirectX 11.1 feature level is required to use hardware decoder");
                        }
                    }
                    catch (Exception exception) {
                        RomStation.b().log(Level.SEVERE, "failed to get DirectX feature level", exception);
                    }
                }
                switch (decoder) {
                    case HARDWARE: {
                        videoElements.add(ElementFactory.make((String)"d3d11h264dec", (String)"video-decoder"));
                        videoElements.add(ElementFactory.make((String)"d3d11colorconvert", (String)"video-convert"));
                        videoElements.add(ElementFactory.make((String)"d3d11download", null));
                        RomStation.b().log(Level.INFO, "hardware decoder configured");
                        break block3;
                    }
                    case SOFTWARE: {
                        videoDecoder = ElementFactory.make((String)"avdec_h264", (String)"video-decoder");
                        videoDecoder.set("direct-rendering", (Object)false);
                        videoDecoder.set("lowres", (Object)1);
                        videoDecoder.set("max-threads", (Object)0);
                        videoDecoder.set("thread-type", (Object)2);
                        videoElements.add(videoDecoder);
                        videoElements.add(ElementFactory.make((String)"videoconvert", (String)"video-convert"));
                        RomStation.b().log(Level.INFO, "software decoder configured");
                        break block3;
                    }
                }
                break;
            }
            case MAC_OS: {
                Element videoDecoder;
                switch (decoder) {
                    case HARDWARE: 
                    case AUTO: {
                        videoElements.add(ElementFactory.make((String)"vtdec", (String)"video-decoder"));
                        videoElements.add(ElementFactory.make((String)"videoconvert", (String)"video-convert"));
                        RomStation.b().log(Level.INFO, "automatic decoder configured");
                        break block3;
                    }
                    case SOFTWARE: {
                        videoDecoder = ElementFactory.make((String)"avdec_h264", (String)"video-decoder");
                        videoDecoder.set("direct-rendering", (Object)false);
                        videoDecoder.set("lowres", (Object)1);
                        videoDecoder.set("max-threads", (Object)0);
                        videoDecoder.set("thread-type", (Object)2);
                        videoElements.add(videoDecoder);
                        videoElements.add(ElementFactory.make((String)"videoconvert", (String)"video-convert"));
                        RomStation.b().log(Level.INFO, "software decoder configured");
                        break block3;
                    }
                }
            }
        }
        this.r = new A("app-sink");
        this.r.a().set("sync", (Object)false);
        videoElements.add(this.r.a());
        audioElements.add(ElementFactory.make((String)"rtpmp4adepay", (String)"audio-depay"));
        audioElements.add(ElementFactory.make((String)"aacparse", (String)"audio-parse"));
        audioElements.add(ElementFactory.make((String)"avdec_aac", (String)"audio-decoder"));
        audioElements.add(ElementFactory.make((String)"audioconvert", (String)"audio-convert"));
        audioElements.add(ElementFactory.make((String)"audioresample", (String)"audio-resample"));
        audioElements.add(ElementFactory.make((String)"volume", (String)"volume"));
        switch (E.c()) {
            case WINDOWS: {
                Element audioSink;
                try {
                    audioSink = Float.parseFloat(System.getProperty("os.version")) >= 10.0f ? ElementFactory.make((String)"wasapi2sink", (String)"audio-sink") : ElementFactory.make((String)"wasapisink", (String)"audio-sink");
                }
                catch (Exception exception) {
                    RomStation.b().log(Level.WARNING, "unable to detect Windows version", exception);
                    audioSink = ElementFactory.make((String)"wasapisink", (String)"audio-sink");
                }
                audioSink.set("low-latency", (Object)true);
                audioElements.add(audioSink);
                break;
            }
            case MAC_OS: {
                audioElements.add(ElementFactory.make((String)"osxaudiosink", (String)"audio-sink"));
            }
        }
        this.q = new Pipeline("pipeline");
        this.q.connect(this::a);
        this.q.getBus().connect(this::a);
        this.q.getBus().connect(this::a);
        this.q.add(source);
        this.q.addMany(videoElements.toArray(new Element[0]));
        this.q.addMany(audioElements.toArray(new Element[0]));
        Element.linkMany((Element[])videoElements.toArray(new Element[0]));
        Element.linkMany((Element[])audioElements.toArray(new Element[0]));
        this.t = this.i.getAsJsonObject("stream").get("dynamic-latency").getAsBoolean();
    }

    @FXML
    private void initialize() {
        this.f.register((Object)this);
        this.j = new Timeline(new KeyFrame[]{new KeyFrame(Duration.seconds((double)10.0), actionEvent -> this.osdMessagesVBox.setVisible(false), new KeyValue[0])});
        this.k = new Timeline(new KeyFrame[]{new KeyFrame(Duration.seconds((double)1.0), actionEvent -> {
            Iterator iterator = this.osdMessagesVBox.getChildren().iterator();
            while (iterator.hasNext()) {
                long timestamp = ((by)((Node)iterator.next()).getUserData()).a();
                if (Instant.now().getEpochSecond() - timestamp < 30L) continue;
                iterator.remove();
            }
        }, new KeyValue[0])});
        this.k.setCycleCount(-1);
        this.k.play();
        try {
            this.l = this.a(this.i.getAsJsonObject("controller").get("id").getAsInt());
            if (this.l.d() == null) {
                dd.a(this.l);
            }
            try {
                this.m = new dc(new InetSocketAddress(this.i.getAsJsonObject("controller").getAsJsonObject("server").get("hostname").getAsString(), this.i.getAsJsonObject("controller").getAsJsonObject("server").get("port").getAsInt()));
                this.n = new c((Node)this.imageView, (Node)this.stackPane);
                if (this.l.d() != null) {
                    this.m.a(this.l.d());
                    if (this.m.c() != null && this.m.c() instanceof d) {
                        ((d)this.m.c()).a(this.n);
                    }
                }
            }
            catch (SocketException exception) {
                RomStation.b().log(Level.SEVERE, "failed to create virtual controller", exception);
            }
        }
        catch (IOException exception) {
            RomStation.b().log(Level.SEVERE, "failed to load virtual controller config", exception);
        }
        this.g();
        this.stretchMenuItem.setSelected(Boolean.parseBoolean(RomStation.c().getProperty("cloudPlayer.video.stretch")));
        this.stretchMenuAction();
        this.preserveRatioMenuItem.setSelected(Boolean.parseBoolean(RomStation.c().getProperty("cloudPlayer.video.preserveRatio")));
        this.preserveRatioMenuAction();
        this.alwaysOnTopMenuItem.setSelected(Boolean.parseBoolean(RomStation.c().getProperty("cloudPlayer.video.alwaysOnTop")));
        this.alwaysOnTopMenuAction();
        this.muteMenuItem.setSelected(Boolean.parseBoolean(RomStation.c().getProperty("cloudPlayer.audio.mute")));
        this.muteMenuAction();
        this.toolBarMenuItem.setSelected(Boolean.parseBoolean(RomStation.c().getProperty("cloudPlayer.view.toolbar")));
        this.toolBarMenuAction();
        this.playerMessagesMenuItem.setSelected(Boolean.parseBoolean(RomStation.c().getProperty("cloudPlayer.view.playerMessages")));
        this.i.getAsJsonArray("features").forEach(element -> {
            String feature;
            switch (feature = element.getAsString()) {
                case "save_state": {
                    this.saveStateMenuItem.setDisable(false);
                    this.saveStateButton.setDisable(false);
                    break;
                }
                case "load_state": {
                    this.loadStateMenuItem.setDisable(false);
                    this.loadStateButton.setDisable(false);
                    break;
                }
                case "reset": {
                    this.resetMenuItem.setDisable(false);
                    this.resetButton.setDisable(false);
                    break;
                }
                case "drive": {
                    this.driveMenu.setDisable(false);
                    this.driveMenuButton.setDisable(false);
                    break;
                }
                case "open_drive": {
                    this.openDriveMenuItem.setDisable(false);
                    this.openDriveToolBarMenuItem.setDisable(false);
                    break;
                }
                case "close_drive": {
                    this.closeDriveMenuItem.setDisable(false);
                    this.closeDriveToolBarMenuItem.setDisable(false);
                    break;
                }
                case "change_medium": {
                    this.changeMediumMenuItem.setDisable(false);
                    this.changeMediumToolBarMenuItem.setDisable(false);
                }
            }
        });
        this.s.addListener((observableValue, previous, current) -> {
            this.loadingLabel.setVisible(current.booleanValue());
            if (current.booleanValue()) {
                BoxBlur boxBlur = new BoxBlur(5.0, 5.0, 1);
                boxBlur.setInput((Effect)new ColorAdjust(0.0, 0.0, -0.7, 0.0));
                this.imageView.setEffect((Effect)boxBlur);
            } else {
                this.imageView.setEffect(null);
            }
        });
        this.o = new AnimationTimer(){

            public void handle(long now) {
                cX.this.a(now);
            }
        };
        this.o.start();
        this.p = new Timeline(new KeyFrame[]{new KeyFrame(Duration.seconds((double)1.0), actionEvent -> this.e(), new KeyValue[0])});
        this.stage.setTitle(this.g);
        this.stage.getIcons().add((Object)this.h);
        this.stage.fullScreenProperty().addListener((observableValue, previous, fullscreen) -> {
            this.fullscreenMenuItem.setSelected(fullscreen.booleanValue());
            this.menuBar.setVisible(fullscreen == false);
            this.menuBar.setManaged(fullscreen == false);
            this.toolBar.setVisible(fullscreen == false && this.toolBarMenuItem.isSelected());
            this.toolBar.setManaged(fullscreen == false && this.toolBarMenuItem.isSelected());
            if (fullscreen.booleanValue()) {
                this.scene.setCursor(Cursor.NONE);
            } else {
                this.scene.setCursor(Cursor.DEFAULT);
            }
        });
        this.scene.getStylesheets().add((Object)RomStation.e());
    }

    @Subscribe
    private void a(cI event) {
        this.a(event.a());
    }

    private void a(String message) {
        this.a(new bH(message));
    }

    private void a(by message) {
        if (!this.playerMessagesMenuItem.isSelected() && message instanceof bF) {
            return;
        }
        TextFlow textFlow = new TextFlow();
        textFlow.setUserData((Object)message);
        textFlow.setMaxWidth(Double.NEGATIVE_INFINITY);
        textFlow.getStyleClass().add((Object)"message");
        if (message instanceof bH) {
            textFlow.getStyleClass().add((Object)"system");
        } else if (message instanceof bF) {
            if (((bF)message).c().h()) {
                textFlow.getStyleClass().add((Object)"host");
            }
            if (((bF)message).c().j() == this.a()) {
                textFlow.getStyleClass().add((Object)"self");
            }
        }
        if (message instanceof bF) {
            Label nameLabel = new Label(String.format(RomStation.d().getString("cloudPlayer.message.playerNameFormat"), ((bF)message).c().d()));
            nameLabel.getStyleClass().add((Object)"player-name");
            textFlow.getChildren().add((Object)nameLabel);
        }
        Text messageText = new Text(message.b());
        messageText.getStyleClass().add((Object)"content");
        textFlow.getChildren().add((Object)messageText);
        this.osdMessagesVBox.getChildren().add((Object)textFlow);
        if (this.osdMessagesVBox.getChildren().size() > 10) {
            this.osdMessagesVBox.getChildren().remove(0);
        }
        this.osdMessagesVBox.setVisible(true);
        if (!this.chatTextField.isVisible()) {
            this.j.playFromStart();
        }
    }

    @FXML
    private void sendMessage() {
        String text = this.chatTextField.getText();
        if (text != null && !text.isEmpty()) {
            this.f.post((Object)new cK(text));
            this.chatTextField.clear();
        }
        this.j.playFromStart();
        this.chatTextField.setVisible(false);
    }

    @FXML
    private void screenshotMenuAction() {
        Image image = this.imageView.getImage();
        if (image != null) {
            Thread thread = new Thread(() -> {
                cX cX2 = this;
                synchronized (cX2) {
                    try {
                        Path path = Paths.get(RomStation.c().getProperty("path.screenshots"), String.format("%1$tY%1$tm%1$td%1$tH%1$tM%1$tS.png", Calendar.getInstance().getTime()));
                        if (Files.notExists(path.getParent(), new LinkOption[0])) {
                            Files.createDirectories(path.getParent(), new FileAttribute[0]);
                        }
                        BufferedImage bufferedImage = SwingFXUtils.fromFXImage((Image)image, null);
                        ImageIO.write((RenderedImage)bufferedImage, "png", path.toFile());
                        Platform.runLater(() -> this.a(String.format(RomStation.d().getString("cloudPlayer.message.screenshotSaved"), path.toAbsolutePath())));
                    }
                    catch (IOException exception) {
                        RomStation.b().log(Level.WARNING, "failed to take screenshot", exception);
                    }
                }
            });
            thread.start();
        }
    }

    @FXML
    private void saveStateMenuAction() {
        this.f.post((Object)new cJ("send_session_command", "save_state"));
    }

    @FXML
    private void loadStateMenuAction() {
        this.f.post((Object)new cJ("send_session_command", "load_state"));
    }

    @FXML
    private void resetMenuAction() {
        this.f.post((Object)new cJ("send_session_command", "reset"));
    }

    @FXML
    private void openDriveMenuAction() {
        this.f.post((Object)new cJ("send_session_command", "open_drive"));
    }

    @FXML
    private void changeMediumMenuAction() {
        this.f.post((Object)new cJ("send_session_command", "change_medium"));
    }

    @FXML
    private void closeDriveMenuAction() {
        this.f.post((Object)new cJ("send_session_command", "close_drive"));
    }

    @FXML
    private void configureControllerMenuAction() {
        if (this.m != null && this.l != null) {
            this.m.a(true);
            bU dialog = new bU(this.l);
            dialog.showAndWait().ifPresent(profile -> this.m.a((db)profile));
            this.m.a(false);
            if (this.m.c() != null && this.m.c() instanceof d) {
                ((d)this.m.c()).a(this.n);
            }
        }
    }

    @FXML
    private void previousControllerProfileMenuAction() {
        if (this.m != null && !this.l.e().isEmpty()) {
            if (this.l.d() == null) {
                this.a(this.l.e().get(0));
            } else if (this.l.e().size() > 1) {
                int currentIndex = this.l.e().indexOf(this.l.d());
                int lastIndex = this.l.e().size() - 1;
                int index = currentIndex == 0 ? lastIndex : currentIndex - 1;
                this.a(this.l.e().get(index));
            }
        }
    }

    @FXML
    private void nextControllerProfileMenuAction() {
        if (this.m != null && !this.l.e().isEmpty()) {
            if (this.l.d() == null) {
                this.a(this.l.e().get(0));
            } else if (this.l.e().size() > 1) {
                int lastIndex;
                int currentIndex = this.l.e().indexOf(this.l.d());
                int index = currentIndex == (lastIndex = this.l.e().size() - 1) ? 0 : currentIndex + 1;
                this.a(this.l.e().get(index));
            }
        }
    }

    @FXML
    private void fullScreenMenuAction() {
        boolean fullscreen = this.fullscreenMenuItem.isSelected();
        this.stage.setFullScreen(fullscreen);
    }

    @FXML
    private void toggleFullScreen() {
        boolean fullscreen = !this.stage.isFullScreen();
        this.stage.setFullScreen(fullscreen);
    }

    @FXML
    public void stretchMenuAction() {
        if (this.stretchMenuItem.isSelected()) {
            this.imageView.fitWidthProperty().bind((ObservableValue)this.stackPane.widthProperty());
            this.imageView.fitHeightProperty().bind((ObservableValue)this.stackPane.heightProperty());
            this.stackPane.setMinSize(0.0, 0.0);
        } else {
            this.imageView.fitWidthProperty().unbind();
            this.imageView.fitHeightProperty().unbind();
            this.imageView.setFitWidth(0.0);
            this.imageView.setFitHeight(0.0);
            this.stackPane.setMinSize(-1.0, -1.0);
        }
    }

    @FXML
    private void preserveRatioMenuAction() {
        this.imageView.setPreserveRatio(this.preserveRatioMenuItem.isSelected());
    }

    @FXML
    private void alwaysOnTopMenuAction() {
        this.stage.setAlwaysOnTop(this.alwaysOnTopMenuItem.isSelected());
    }

    @FXML
    private void muteMenuAction() {
        this.q.getElementByName("volume").set("mute", (Object)this.muteMenuItem.isSelected());
    }

    @FXML
    private void toolBarMenuAction() {
        boolean showToolBar = this.toolBarMenuItem.isSelected();
        this.toolBar.setVisible(showToolBar);
        this.toolBar.setManaged(showToolBar);
    }

    @FXML
    private void openChatMenuAction() {
        if (!this.chatTextField.isVisible()) {
            this.j.stop();
            this.osdMessagesVBox.setVisible(true);
            this.chatTextField.setVisible(true);
            Platform.runLater(() -> {
                this.chatTextField.requestFocus();
                this.chatTextField.end();
            });
        }
    }

    @FXML
    private void closeChatMenuAction() {
        if (this.chatTextField.isVisible()) {
            this.j.playFromStart();
            this.chatTextField.setVisible(false);
        }
    }

    @FXML
    private void playerMessagesMenuAction() {
        boolean visible = this.playerMessagesMenuItem.isSelected();
        for (Node child : this.osdMessagesVBox.getChildren()) {
            if (!(child.getUserData() instanceof bF)) continue;
            child.setVisible(visible);
            child.setManaged(visible);
        }
    }

    @FXML
    private void helpMenuAction() {
        try {
            Desktop.getDesktop().browse(new URI(org.romstation.application.network.b.b() + "/documentation/online/multiplayer/cloud-server/"));
        }
        catch (Exception exception) {
            RomStation.b().log(Level.WARNING, exception.getMessage(), exception);
        }
    }
}

