/*
 * Decompiled with CFR 0.152.
 */
package org.romstation.application.database.entity;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.stream.Collectors;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.CascadeType;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.MapKeyColumn;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.PostPersist;
import javax.persistence.PostRemove;
import javax.persistence.PostUpdate;
import javax.persistence.PrePersist;
import javax.persistence.PreRemove;
import javax.persistence.PreUpdate;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.jruby.Ruby;
import org.jruby.RubyObject;
import org.jruby.javasupport.JavaUtil;
import org.romstation.application.N;
import org.romstation.application.RomStation;
import org.romstation.application.database.entity.EmulatorFile;
import org.romstation.application.database.entity.EmulatorProfile;
import org.romstation.application.database.entity.Image;
import org.romstation.application.database.entity.Link;
import org.romstation.application.database.entity.RemoteEntity;
import org.romstation.application.database.entity.Script;
import org.romstation.application.database.entity.System;

@Entity
@Table(name="EMULATOR")
@Access(value=AccessType.PROPERTY)
@NamedQueries(value={@NamedQuery(name="Emulator.countAll", query="select count(emulator) from Emulator emulator"), @NamedQuery(name="Emulator.findForSystem", query="select distinct emulator from Emulator emulator join emulator.files file join file.profiles profile where :system member of profile.systems order by emulator.name asc"), @NamedQuery(name="Emulator.findByRid", query="select emulator from Emulator emulator where emulator.rid = :rid")})
public class Emulator
extends RemoteEntity {
    public static final String a = "Emulator.countAll";
    public static final String b = "Emulator.findForSystem";
    public static final String c = "Emulator.findByRid";
    private String d;
    private String e;
    private Image f;
    private boolean g;
    private List<Link> h = new LinkedList<Link>();
    private List<Script> i = new LinkedList<Script>();
    private List<EmulatorFile> j = new LinkedList<EmulatorFile>();
    private Map<String, String> k = new HashMap<String, String>();

    @Override
    @Id
    @SequenceGenerator(name="EMULATOR_GENERATOR", sequenceName="EMULATOR_SEQUENCE", allocationSize=1)
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="EMULATOR_GENERATOR")
    public Integer getId() {
        return super.getId();
    }

    public String getName() {
        return this.d;
    }

    public void setName(String name) {
        this.d = name;
    }

    public String getDirectory() {
        return this.e;
    }

    public void setDirectory(String directory) {
        this.e = directory;
    }

    @OneToOne(cascade={CascadeType.ALL}, orphanRemoval=true)
    @JoinColumn(name="GRAPHIC_IMAGE_ID")
    public Image getGraphic() {
        return this.f;
    }

    public void setGraphic(Image icon) {
        this.f = icon;
    }

    public boolean isManaged() {
        return this.g;
    }

    public void setManaged(boolean managed) {
        this.g = managed;
    }

    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true)
    @JoinTable(inverseJoinColumns={@JoinColumn(name="LINK_ID")})
    public List<Link> getLinks() {
        return this.h;
    }

    public void setLinks(List<Link> links) {
        this.h = links;
    }

    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true)
    @JoinTable(inverseJoinColumns={@JoinColumn(name="SCRIPT_ID")})
    public List<Script> getScripts() {
        return this.i;
    }

    public void setScripts(List<Script> scripts) {
        this.i = scripts;
    }

    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true)
    @JoinColumn(name="EMULATOR_ID")
    public List<EmulatorFile> getFiles() {
        return this.j;
    }

    public void setFiles(List<EmulatorFile> files) {
        this.j = files;
    }

    @ElementCollection
    @MapKeyColumn(name="\"KEY\"")
    @Column(name="VALUE", length=32672)
    @CollectionTable(name="EMULATOR_META", joinColumns={@JoinColumn(name="EMULATOR_ID")})
    public Map<String, String> getMetas() {
        return this.k;
    }

    public void setMetas(Map<String, String> meta) {
        this.k = meta;
    }

    @Transient
    public List<System> getSystems() {
        return this.j.stream().map(EmulatorFile::getProfiles).flatMap(Collection::stream).map(EmulatorProfile::getSystems).flatMap(Collection::stream).distinct().collect(Collectors.toList());
    }

    @PrePersist
    private void prePersist() {
        for (Script script : this.getScripts()) {
            try {
                RubyObject rubyObject = N.a(script);
                if (!rubyObject.respondsTo("on_pre_persist")) continue;
                rubyObject.callMethod("on_pre_persist", JavaUtil.convertJavaToRuby((Ruby)rubyObject.getRuntime(), (Object)this));
            }
            catch (Exception exception) {
                RomStation.b().log(Level.WARNING, exception.getMessage(), exception);
            }
        }
        if (N.a().database.emulator.on_pre_persist != null) {
            N.a().database.emulator.on_pre_persist.accept(this);
        }
    }

    @PostPersist
    private void postPersist() {
        for (Script script : this.getScripts()) {
            try {
                RubyObject rubyObject = N.a(script);
                if (!rubyObject.respondsTo("on_post_persist")) continue;
                rubyObject.callMethod("on_post_persist", JavaUtil.convertJavaToRuby((Ruby)rubyObject.getRuntime(), (Object)this));
            }
            catch (Exception exception) {
                RomStation.b().log(Level.WARNING, exception.getMessage(), exception);
            }
        }
        if (N.a().database.emulator.on_post_persist != null) {
            N.a().database.emulator.on_post_persist.accept(this);
        }
    }

    @PreUpdate
    private void preUpdate() {
        for (Script script : this.getScripts()) {
            try {
                RubyObject rubyObject = N.a(script);
                if (!rubyObject.respondsTo("on_pre_update")) continue;
                rubyObject.callMethod("on_pre_update", JavaUtil.convertJavaToRuby((Ruby)rubyObject.getRuntime(), (Object)this));
            }
            catch (Exception exception) {
                RomStation.b().log(Level.WARNING, exception.getMessage(), exception);
            }
        }
        if (N.a().database.emulator.on_pre_update != null) {
            N.a().database.emulator.on_pre_update.accept(this);
        }
    }

    @PostUpdate
    private void postUpdate() {
        for (Script script : this.getScripts()) {
            try {
                RubyObject rubyObject = N.a(script);
                if (!rubyObject.respondsTo("on_post_update")) continue;
                rubyObject.callMethod("on_post_update", JavaUtil.convertJavaToRuby((Ruby)rubyObject.getRuntime(), (Object)this));
            }
            catch (Exception exception) {
                RomStation.b().log(Level.WARNING, exception.getMessage(), exception);
            }
        }
        if (N.a().database.emulator.on_post_update != null) {
            N.a().database.emulator.on_post_update.accept(this);
        }
    }

    @PreRemove
    private void preRemove() {
        for (Script script : this.getScripts()) {
            try {
                RubyObject rubyObject = N.a(script);
                if (!rubyObject.respondsTo("on_pre_remove")) continue;
                rubyObject.callMethod("on_pre_remove", JavaUtil.convertJavaToRuby((Ruby)rubyObject.getRuntime(), (Object)this));
            }
            catch (Exception exception) {
                RomStation.b().log(Level.WARNING, exception.getMessage(), exception);
            }
        }
        if (N.a().database.emulator.on_pre_remove != null) {
            N.a().database.emulator.on_pre_remove.accept(this);
        }
    }

    @PostRemove
    private void postRemove() {
        for (Script script : this.getScripts()) {
            try {
                RubyObject rubyObject = N.a(script);
                if (!rubyObject.respondsTo("on_post_remove")) continue;
                rubyObject.callMethod("on_post_remove", JavaUtil.convertJavaToRuby((Ruby)rubyObject.getRuntime(), (Object)this));
            }
            catch (Exception exception) {
                RomStation.b().log(Level.WARNING, exception.getMessage(), exception);
            }
        }
        if (N.a().database.emulator.on_post_remove != null) {
            N.a().database.emulator.on_post_remove.accept(this);
        }
    }

    public String toString() {
        return "[" + this.getId() + "] " + this.d;
    }
}

