/*
 * Decompiled with CFR 0.152.
 */
package org.romstation.application.database.entity;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.CascadeType;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToOne;
import javax.persistence.MapKeyColumn;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.PostPersist;
import javax.persistence.PostRemove;
import javax.persistence.PostUpdate;
import javax.persistence.PrePersist;
import javax.persistence.PreRemove;
import javax.persistence.PreUpdate;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.jruby.Ruby;
import org.jruby.RubyObject;
import org.jruby.javasupport.JavaUtil;
import org.romstation.application.N;
import org.romstation.application.RomStation;
import org.romstation.application.database.entity.Emulator;
import org.romstation.application.database.entity.EmulatorProfile;
import org.romstation.application.database.entity.RemoteEntity;
import org.romstation.application.database.entity.Script;

@Entity
@Table(name="EMULATOR_FILE")
@Access(value=AccessType.PROPERTY)
@NamedQueries(value={@NamedQuery(name="EmulatorFile.findByRID", query="select emulatorFile from EmulatorFile emulatorFile where emulatorFile.rid = :rid")})
public class EmulatorFile
extends RemoteEntity {
    public static final String a = "EmulatorFile.findByRID";
    private String b;
    private String c;
    private boolean d;
    private Emulator e;
    private List<EmulatorProfile> f = new LinkedList<EmulatorProfile>();
    private List<Script> g = new LinkedList<Script>();
    private Map<String, String> h = new HashMap<String, String>();

    public EmulatorFile() {
    }

    public EmulatorFile(EmulatorFile entity) {
        this.setRid(entity.getRid());
        this.b = entity.getName();
        this.c = entity.getDirectory();
        this.e = entity.getEmulator();
        this.d = false;
        entity.getProfiles().forEach(emulatorProfile -> this.f.add(new EmulatorProfile((EmulatorProfile)emulatorProfile)));
        this.g.addAll(entity.getScripts());
        this.h.putAll(entity.getMetas());
    }

    @Override
    @Id
    @SequenceGenerator(name="EMULATOR_FILE_GENERATOR", sequenceName="EMULATOR_FILE_SEQUENCE", allocationSize=1)
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="EMULATOR_FILE_GENERATOR")
    public Integer getId() {
        return super.getId();
    }

    public String getName() {
        return this.b;
    }

    public void setName(String name) {
        this.b = name;
    }

    public String getDirectory() {
        return this.c;
    }

    public void setDirectory(String directory) {
        this.c = directory;
    }

    public boolean isManaged() {
        return this.d;
    }

    public void setManaged(boolean managed) {
        this.d = managed;
    }

    @ManyToOne(cascade={CascadeType.PERSIST, CascadeType.MERGE})
    public Emulator getEmulator() {
        return this.e;
    }

    public void setEmulator(Emulator emulator) {
        this.e = emulator;
    }

    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true)
    @JoinColumn(name="EMULATOR_FILE_ID")
    public List<EmulatorProfile> getProfiles() {
        return this.f;
    }

    public void setProfiles(List<EmulatorProfile> profiles) {
        this.f = profiles;
    }

    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true)
    @JoinTable(joinColumns={@JoinColumn(name="EMULATOR_FILE_ID")}, inverseJoinColumns={@JoinColumn(name="SCRIPT_ID")})
    public List<Script> getScripts() {
        return this.g;
    }

    public void setScripts(List<Script> scripts) {
        this.g = scripts;
    }

    @ElementCollection
    @MapKeyColumn(name="\"KEY\"")
    @Column(name="VALUE", length=32672)
    @CollectionTable(name="EMULATOR_FILE_META", joinColumns={@JoinColumn(name="EMULATOR_FILE_ID")})
    public Map<String, String> getMetas() {
        return this.h;
    }

    public void setMetas(Map<String, String> meta) {
        this.h = meta;
    }

    @PrePersist
    private void prePersist() {
        for (Script script : this.getScripts()) {
            try {
                RubyObject rubyObject = N.a(script);
                if (!rubyObject.respondsTo("on_pre_persist")) continue;
                rubyObject.callMethod("on_pre_persist", JavaUtil.convertJavaToRuby((Ruby)rubyObject.getRuntime(), (Object)this));
            }
            catch (Exception exception) {
                RomStation.b().log(Level.WARNING, exception.getMessage(), exception);
            }
        }
        if (N.a().database.emulator_file.on_pre_persist != null) {
            N.a().database.emulator_file.on_pre_persist.accept(this);
        }
    }

    @PostPersist
    private void postPersist() {
        for (Script script : this.getScripts()) {
            try {
                RubyObject rubyObject = N.a(script);
                if (!rubyObject.respondsTo("on_post_persist")) continue;
                rubyObject.callMethod("on_post_persist", JavaUtil.convertJavaToRuby((Ruby)rubyObject.getRuntime(), (Object)this));
            }
            catch (Exception exception) {
                RomStation.b().log(Level.WARNING, exception.getMessage(), exception);
            }
        }
        if (N.a().database.emulator_file.on_post_persist != null) {
            N.a().database.emulator_file.on_post_persist.accept(this);
        }
    }

    @PreUpdate
    private void preUpdate() {
        for (Script script : this.getScripts()) {
            try {
                RubyObject rubyObject = N.a(script);
                if (!rubyObject.respondsTo("on_pre_update")) continue;
                rubyObject.callMethod("on_pre_update", JavaUtil.convertJavaToRuby((Ruby)rubyObject.getRuntime(), (Object)this));
            }
            catch (Exception exception) {
                RomStation.b().log(Level.WARNING, exception.getMessage(), exception);
            }
        }
        if (N.a().database.emulator_file.on_pre_update != null) {
            N.a().database.emulator_file.on_pre_update.accept(this);
        }
    }

    @PostUpdate
    private void postUpdate() {
        for (Script script : this.getScripts()) {
            try {
                RubyObject rubyObject = N.a(script);
                if (!rubyObject.respondsTo("on_post_update")) continue;
                rubyObject.callMethod("on_post_update", JavaUtil.convertJavaToRuby((Ruby)rubyObject.getRuntime(), (Object)this));
            }
            catch (Exception exception) {
                RomStation.b().log(Level.WARNING, exception.getMessage(), exception);
            }
        }
        if (N.a().database.emulator_file.on_post_update != null) {
            N.a().database.emulator_file.on_post_update.accept(this);
        }
    }

    @PreRemove
    private void preRemove() {
        for (Script script : this.getScripts()) {
            try {
                RubyObject rubyObject = N.a(script);
                if (!rubyObject.respondsTo("on_pre_remove")) continue;
                rubyObject.callMethod("on_pre_remove", JavaUtil.convertJavaToRuby((Ruby)rubyObject.getRuntime(), (Object)this));
            }
            catch (Exception exception) {
                RomStation.b().log(Level.WARNING, exception.getMessage(), exception);
            }
        }
        if (N.a().database.emulator_file.on_pre_remove != null) {
            N.a().database.emulator_file.on_pre_remove.accept(this);
        }
    }

    @PostRemove
    private void postRemove() {
        for (Script script : this.getScripts()) {
            try {
                RubyObject rubyObject = N.a(script);
                if (!rubyObject.respondsTo("on_post_remove")) continue;
                rubyObject.callMethod("on_post_remove", JavaUtil.convertJavaToRuby((Ruby)rubyObject.getRuntime(), (Object)this));
            }
            catch (Exception exception) {
                RomStation.b().log(Level.WARNING, exception.getMessage(), exception);
            }
        }
        if (N.a().database.emulator_file.on_post_remove != null) {
            N.a().database.emulator_file.on_post_remove.accept(this);
        }
    }

    public String toString() {
        return this.b;
    }
}

